/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.control;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.control.SideButton;
import com.raoulvdberge.refinedstorage.integration.jei.IntegrationJEI;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public abstract class SideButtonSearchBoxMode
extends SideButton {
    private static final List<Integer> MODE_ROTATION = Arrays.asList(0, 1, 2, 3, 4, 5, 0);

    private static int nextMode(int oldMode) {
        return MODE_ROTATION.get(MODE_ROTATION.indexOf(oldMode) + 1);
    }

    public SideButtonSearchBoxMode(GuiBase gui) {
        super(gui);
    }

    @Override
    public String getTooltip() {
        return I18n.func_135052_a((String)"sidebutton.refinedstorage:grid.search_box_mode", (Object[])new Object[0]) + "\n" + TextFormatting.GRAY + I18n.func_135052_a((String)("sidebutton.refinedstorage:grid.search_box_mode." + this.getSearchBoxMode()), (Object[])new Object[0]);
    }

    @Override
    protected void drawButtonIcon(int x, int y) {
        int mode = this.getSearchBoxMode();
        this.gui.drawTexture(x, y, IGrid.isSearchBoxModeWithAutoselection(mode) ? 16 : 0, 96, 16, 16);
    }

    @Override
    public void actionPerformed() {
        int mode = SideButtonSearchBoxMode.nextMode(this.getSearchBoxMode());
        if (IGrid.doesSearchBoxModeUseJEI(mode) && !IntegrationJEI.isLoaded()) {
            mode = 0;
        }
        this.setSearchBoxMode(mode);
    }

    protected abstract int getSearchBoxMode();

    protected abstract void setSearchBoxMode(int var1);
}

