/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid;

import com.google.common.collect.Lists;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSKeyBindings;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridNetworkAware;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilter;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.IResizableDisplay;
import com.raoulvdberge.refinedstorage.gui.control.Scrollbar;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridSearchBoxMode;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridSize;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridSortingDirection;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridSortingType;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridViewType;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonType;
import com.raoulvdberge.refinedstorage.gui.control.TabList;
import com.raoulvdberge.refinedstorage.gui.control.TextFieldSearch;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGridCraftingSettings;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterID;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterInventoryTweaks;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterLastModified;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterName;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterQuantity;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.IGridSorter;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.gui.grid.view.GridViewImpl;
import com.raoulvdberge.refinedstorage.gui.grid.view.IGridView;
import com.raoulvdberge.refinedstorage.network.MessageGridClear;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidInsertHeld;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidPull;
import com.raoulvdberge.refinedstorage.network.MessageGridItemInsertHeld;
import com.raoulvdberge.refinedstorage.network.MessageGridItemInsertInventory;
import com.raoulvdberge.refinedstorage.network.MessageGridItemInventoryScroll;
import com.raoulvdberge.refinedstorage.network.MessageGridItemPull;
import com.raoulvdberge.refinedstorage.network.MessageGridItemScroll;
import com.raoulvdberge.refinedstorage.network.MessageGridPatternCreate;
import com.raoulvdberge.refinedstorage.network.MessageGridPatternSlotScroll;
import com.raoulvdberge.refinedstorage.tile.config.FilterType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.grid.TileGrid;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.tile.grid.portable.TilePortableGrid;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import com.raoulvdberge.refinedstorage.util.TimeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class GuiGrid
extends GuiBase
implements IResizableDisplay {
    private IGridView view;
    private TextFieldSearch searchField;
    private GuiCheckBox oredictPattern;
    private GuiCheckBox processingPattern;
    private final IGrid grid;
    private final TabList tabs;
    private boolean wasConnected;
    private UUID lockedStackUUID;
    private int slotNumber;

    public GuiGrid(ContainerGrid container, final IGrid grid) {
        super(container, 227, 0);
        this.grid = grid;
        this.view = new GridViewImpl(this, GuiGrid.getDefaultSorter(), GuiGrid.getSorters());
        this.wasConnected = this.grid.isActive();
        this.tabs = new TabList(this, new GuiBase.ElementDrawers(this), grid::getTabs, grid::getTotalTabPages, grid::getTabPage, grid::getTabSelected, 5);
        this.tabs.addListener(new TabList.ITabListListener(){

            @Override
            public void onSelectionChanged(int tab) {
                grid.onTabSelectionChanged(tab);
            }

            @Override
            public void onPageChanged(int page) {
                grid.onTabPageChanged(page);
            }
        });
    }

    @Override
    protected void calcHeight() {
        this.screenHeight = this.field_147000_g = this.getTopHeight() + this.getBottomHeight() + this.getVisibleRows() * 18;
    }

    @Override
    public void init(int x, int y) {
        ((ContainerGrid)this.field_147002_h).initSlots();
        this.tabs.init(this.field_146999_f - 32);
        this.scrollbar = new Scrollbar(174, this.getTopHeight(), 12, this.getVisibleRows() * 18 - 2);
        if (this.grid instanceof NetworkNodeGrid || this.grid instanceof TilePortableGrid) {
            this.addSideButton(new SideButtonRedstoneMode(this, this.grid instanceof NetworkNodeGrid ? TileGrid.REDSTONE_MODE : TilePortableGrid.REDSTONE_MODE));
        }
        int sx = x + 80 + 1;
        int sy = y + 6 + 1;
        if (this.searchField == null) {
            this.searchField = new TextFieldSearch(0, this.field_146289_q, sx, sy, 82);
            this.searchField.addListener(() -> {
                this.lockedStackUUID = null;
                this.getView().sort();
            });
            this.searchField.setMode(this.grid.getSearchBoxMode());
        } else {
            this.searchField.field_146209_f = sx;
            this.searchField.field_146210_g = sy;
        }
        if (this.grid.getGridType() != GridType.FLUID && this.grid.getViewType() != -1) {
            this.addSideButton(new SideButtonGridViewType(this, this.grid));
        }
        this.addSideButton(new SideButtonGridSortingDirection(this, this.grid));
        this.addSideButton(new SideButtonGridSortingType(this, this.grid));
        this.addSideButton(new SideButtonGridSearchBoxMode(this));
        this.addSideButton(new SideButtonGridSize(this, this.grid::getSize, this.grid::onSizeChanged));
        if (this.grid.getGridType() == GridType.PATTERN) {
            boolean showOredict;
            this.processingPattern = this.addCheckBox(x + 7, y + this.getTopHeight() + this.getVisibleRows() * 18 + 60, GuiGrid.t("misc.refinedstorage:processing", new Object[0]), TileGrid.PROCESSING_PATTERN.getValue());
            boolean bl = showOredict = !((NetworkNodeGrid)this.grid).isProcessingPattern() || ((NetworkNodeGrid)this.grid).getProcessingType() != FilterType.FLUIDS;
            if (showOredict) {
                this.oredictPattern = this.addCheckBox(this.processingPattern.field_146128_h + this.processingPattern.field_146120_f + 5, y + this.getTopHeight() + this.getVisibleRows() * 18 + 60, GuiGrid.t("misc.refinedstorage:oredict", new Object[0]), TileGrid.OREDICT_PATTERN.getValue());
            }
            this.addSideButton(new SideButtonType(this, TileGrid.PROCESSING_TYPE));
        }
        this.updateScrollbar();
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public void setView(IGridView view) {
        this.view = view;
    }

    public IGridView getView() {
        return this.view;
    }

    @Override
    public void update(int x, int y) {
        if (this.wasConnected != this.grid.isActive()) {
            this.wasConnected = this.grid.isActive();
            this.view.sort();
        }
        this.tabs.update();
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        if (!(Keyboard.getEventKey() != 42 && Keyboard.getEventKey() != 54 && Keyboard.getEventKey() != 29 && Keyboard.getEventKey() != 157 || Keyboard.getEventKeyState() || this.lockedStackUUID == null)) {
            this.lockedStackUUID = null;
            this.view.sort();
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        int delta;
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (!(this.lockedStackUUID == null || this.isOverSlotArea(mouseX - this.field_147003_i, mouseY - this.field_147009_r) && (GuiGrid.func_146272_n() || GuiGrid.func_146271_m()))) {
            this.lockedStackUUID = null;
            this.view.sort();
        }
        if ((delta = Mouse.getEventDWheel()) == 0) {
            super.func_146274_d();
            return;
        }
        Slot hoveredSlot = this.getSlotUnderMouse();
        boolean prevState = this.scrollbar.isEnabled();
        if (this.getGrid().getGridType() == GridType.PATTERN && hoveredSlot instanceof SlotFilter && !hoveredSlot.func_75211_c().func_190926_b()) {
            this.scrollbar.setEnabled(false);
        }
        super.func_146274_d();
        this.scrollbar.setEnabled(prevState);
        if (hoveredSlot != null && hoveredSlot.func_75211_c().func_190926_b()) {
            return;
        }
        if (GuiGrid.func_146272_n() && this.isOverInventoryAndHotBar(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            if (this.grid.getGridType() != GridType.FLUID && hoveredSlot != null) {
                RS.INSTANCE.network.sendToServer((IMessage)new MessageGridItemInventoryScroll(hoveredSlot.getSlotIndex(), delta > 0));
            }
        } else if ((GuiGrid.func_146272_n() || GuiGrid.func_146271_m()) && this.isOverSlotArea(mouseX - this.field_147003_i, mouseY - this.field_147009_r) && this.grid.getGridType() != GridType.FLUID) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridItemScroll(this.isOverSlotWithStack() ? this.view.getStacks().get(this.slotNumber).getId() : new UUID(0L, 0L), GuiGrid.func_146272_n(), delta > 0));
        } else if (this.getGrid().getGridType() == GridType.PATTERN && hoveredSlot instanceof SlotFilter) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridPatternSlotScroll(hoveredSlot.field_75222_d, delta > 0));
        }
    }

    private boolean isOverInventoryAndHotBar(int x, int y) {
        return this.inBounds(8, this.getYPlayerInventory(), 160, 74, x, y);
    }

    private boolean isOverInventory(int x, int y) {
        return this.inBounds(8, this.getYPlayerInventory(), 160, 74, x, y);
    }

    private boolean isOverHotBar(int x, int y) {
        return this.inBounds(8, this.getYPlayerInventory() + 56, 160, 20, x, y);
    }

    @Override
    public int getTopHeight() {
        return 19;
    }

    @Override
    public int getBottomHeight() {
        if (this.grid.getGridType() == GridType.CRAFTING) {
            return 156;
        }
        if (this.grid.getGridType() == GridType.PATTERN) {
            return 169;
        }
        return 99;
    }

    @Override
    public int getYPlayerInventory() {
        int yp = this.getTopHeight() + this.getVisibleRows() * 18;
        if (this.grid.getGridType() == GridType.NORMAL || this.grid.getGridType() == GridType.FLUID) {
            yp += 16;
        } else if (this.grid.getGridType() == GridType.CRAFTING) {
            yp += 73;
        } else if (this.grid.getGridType() == GridType.PATTERN) {
            yp += 86;
        }
        return yp;
    }

    @Override
    public int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.view.getStacks().size() / 9.0f));
    }

    @Override
    public int getCurrentOffset() {
        return this.scrollbar.getOffset();
    }

    @Override
    public String getSearchFieldText() {
        return this.searchField == null ? "" : this.searchField.func_146179_b();
    }

    @Override
    public int getVisibleRows() {
        switch (this.grid.getSize()) {
            case 0: {
                int screenSpaceAvailable = this.field_146295_m - this.getTopHeight() - this.getBottomHeight();
                return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, RS.INSTANCE.config.maxRowsStretch));
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
        }
        return 3;
    }

    private boolean isOverSlotWithStack() {
        return this.grid.isActive() && this.isOverSlot() && this.slotNumber < this.view.getStacks().size();
    }

    private boolean isOverSlot() {
        return this.slotNumber >= 0;
    }

    public boolean isOverSlotArea(int mouseX, int mouseY) {
        return this.inBounds(7, 19, 162, 18 * this.getVisibleRows(), mouseX, mouseY);
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    private boolean isOverClear(int mouseX, int mouseY) {
        int y = this.getTopHeight() + this.getVisibleRows() * 18 + 4;
        switch (this.grid.getGridType()) {
            case CRAFTING: {
                return this.inBounds(82, y, 7, 7, mouseX, mouseY);
            }
            case PATTERN: {
                if (((NetworkNodeGrid)this.grid).isProcessingPattern()) {
                    return this.inBounds(154, y, 7, 7, mouseX, mouseY);
                }
                return this.inBounds(82, y, 7, 7, mouseX, mouseY);
            }
        }
        return false;
    }

    private boolean isOverCreatePattern(int mouseX, int mouseY) {
        return this.grid.getGridType() == GridType.PATTERN && this.inBounds(172, this.getTopHeight() + this.getVisibleRows() * 18 + 22, 16, 16, mouseX, mouseY) && ((NetworkNodeGrid)this.grid).canCreatePattern();
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.tabs.drawBackground(x, y - this.tabs.getHeight());
        if (this.grid instanceof IPortableGrid) {
            this.bindTexture("gui/portable_grid.png");
        } else if (this.grid.getGridType() == GridType.CRAFTING) {
            this.bindTexture("gui/crafting_grid.png");
        } else if (this.grid.getGridType() == GridType.PATTERN) {
            this.bindTexture("gui/pattern_grid" + (((NetworkNodeGrid)this.grid).isProcessingPattern() ? "_processing" : "") + ".png");
        } else {
            this.bindTexture("gui/grid.png");
        }
        int yy = y;
        this.drawTexture(x, yy, 0, 0, this.screenWidth - 34, this.getTopHeight());
        this.drawTexture(x + this.screenWidth - 34 + 4, y, 197, 0, 30, this.grid instanceof IPortableGrid ? 114 : 82);
        int rows = this.getVisibleRows();
        for (int i = 0; i < rows; ++i) {
            this.drawTexture(x, yy += 18, 0, this.getTopHeight() + (i > 0 ? (i == rows - 1 ? 36 : 18) : 0), this.screenWidth - 34, 18);
        }
        this.drawTexture(x, yy += 18, 0, this.getTopHeight() + 54, this.screenWidth - 34, this.getBottomHeight());
        if (this.grid.getGridType() == GridType.PATTERN) {
            int ty = 0;
            if (this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                ty = 1;
            }
            if (!((NetworkNodeGrid)this.grid).canCreatePattern()) {
                ty = 2;
            }
            this.drawTexture(x + 172, y + this.getTopHeight() + this.getVisibleRows() * 18 + 22, 240, ty * 16, 16, 16);
        }
        this.tabs.drawForeground(x, y - this.tabs.getHeight(), mouseX, mouseY, true);
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.lockedStackUUID = null;
        if (this.isOverSlotWithStack()) {
            if ((GuiGrid.func_146272_n() || GuiGrid.func_146271_m()) && !this.view.getStacks().get(this.slotNumber).isCraftable()) {
                this.lockedStackUUID = this.view.getStacks().get(this.slotNumber).getId();
            }
            this.drawGridTooltip(this.view.getStacks().get(this.slotNumber), mouseX, mouseY);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiGrid.t(this.grid.getGuiTitle(), new Object[0]));
        this.drawString(7, this.getYPlayerInventory() - 12, GuiGrid.t("container.inventory", new Object[0]));
        int x = 8;
        int y = 19;
        this.slotNumber = -1;
        int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 9 : 0;
        RenderHelper.func_74520_c();
        for (int i = 0; i < 9 * this.getVisibleRows(); ++i) {
            if (this.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isActive()) {
                this.slotNumber = slot;
            }
            if (slot < this.view.getStacks().size()) {
                this.view.getStacks().get(slot).draw(this, x, y);
            }
            if (this.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isActive()) {
                int color = this.grid.isActive() ? -2130706433 : -10790053;
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                this.field_73735_i = 190.0f;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_73733_a(x, y, x + 16, y + 16, color, color);
                this.field_73735_i = 0.0f;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            ++slot;
            x += 18;
            if ((i + 1) % 9 != 0) continue;
            x = 8;
            y += 18;
        }
        if (this.isOverClear(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, GuiGrid.t("misc.refinedstorage:clear", new Object[0]));
        }
        if (this.isOverCreatePattern(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, GuiGrid.t("gui.refinedstorage:grid.pattern_create", new Object[0]));
        }
        this.tabs.drawTooltip(this.field_146289_q, mouseX, mouseY);
    }

    private void drawGridTooltip(IGridStack gridStack, int mouseX, int mouseY) {
        ArrayList textLines = Lists.newArrayList((Object[])gridStack.getTooltip(false).split("\n"));
        ArrayList<String> smallTextLines = new ArrayList<String>();
        if (!gridStack.isCraftable()) {
            smallTextLines.add(I18n.func_135052_a((String)"misc.refinedstorage:total", (Object[])new Object[]{gridStack.getFormattedFullQuantity()}));
        }
        if (gridStack.getTrackerEntry() != null) {
            smallTextLines.add(TimeUtils.getAgo(gridStack.getTrackerEntry().getTime(), gridStack.getTrackerEntry().getName()));
        }
        ItemStack stack = gridStack instanceof GridStackItem ? ((GridStackItem)gridStack).getStack() : ItemStack.field_190927_a;
        RenderUtils.drawTooltipWithSmallText(textLines, smallTextLines, RS.INSTANCE.config.detailedTooltip, stack, mouseX, mouseY, this.field_146294_l, this.field_146295_m, this.field_146289_q);
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        this.tabs.actionPerformed(button);
        if (button == this.oredictPattern) {
            TileDataManager.setParameter(TileGrid.OREDICT_PATTERN, this.oredictPattern.isChecked());
        } else if (button == this.processingPattern) {
            TileGrid.PROCESSING_PATTERN.setValue(false, this.processingPattern.isChecked());
            ((NetworkNodeGrid)this.grid).clearMatrix();
            ((ContainerGrid)this.field_147002_h).initSlots();
            TileDataManager.setParameter(TileGrid.PROCESSING_PATTERN, this.processingPattern.isChecked());
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int clickedButton) throws IOException {
        boolean clickedCreatePattern;
        if (Keyboard.isKeyDown((int)57) && this.grid.isActive() && this.grid.getGridType() != GridType.FLUID && this.isOverInventory(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridItemInsertInventory(this.isOverHotBar(mouseX - this.field_147003_i, mouseY - this.field_147009_r)));
            return;
        }
        super.func_73864_a(mouseX, mouseY, clickedButton);
        this.tabs.mouseClicked();
        if (this.searchField != null) {
            this.searchField.func_146192_a(mouseX, mouseY, clickedButton);
        }
        boolean clickedClear = clickedButton == 0 && this.isOverClear(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        boolean bl = clickedCreatePattern = clickedButton == 0 && this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        if (clickedCreatePattern) {
            BlockPos gridPos = ((NetworkNodeGrid)this.grid).getNetworkNodePos();
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridPatternCreate(gridPos.func_177958_n(), gridPos.func_177956_o(), gridPos.func_177952_p()));
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        } else if (clickedClear && this.grid instanceof IGridNetworkAware) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridClear());
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        } else if (this.grid.isActive()) {
            EntityPlayer player = ((ContainerGrid)this.field_147002_h).getPlayer();
            ItemStack held = player.field_71071_by.func_70445_o();
            if (this.isOverSlotArea(mouseX - this.field_147003_i, mouseY - this.field_147009_r) && !held.func_190926_b() && (clickedButton == 0 || clickedButton == 1)) {
                RS.INSTANCE.network.sendToServer((IMessage)(this.grid.getGridType() == GridType.FLUID ? new MessageGridFluidInsertHeld() : new MessageGridItemInsertHeld(clickedButton == 1)));
            } else if (this.isOverSlotWithStack()) {
                boolean isMiddleClickPulling = !held.func_190926_b() && clickedButton == 2;
                boolean isPulling = held.func_190926_b() || isMiddleClickPulling;
                IGridStack stack = this.view.getStacks().get(this.slotNumber);
                if (isPulling) {
                    if (stack.isCraftable() && this.view.canCraft()) {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiGridCraftingSettings(this, player, stack));
                    } else if (this.view.canCraft() && !stack.isCraftable() && stack.getOtherId() != null && GuiScreen.func_146272_n() && GuiScreen.func_146271_m()) {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiGridCraftingSettings(this, player, this.view.get(stack.getOtherId())));
                    } else if (this.grid.getGridType() == GridType.FLUID && held.func_190926_b()) {
                        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridFluidPull(this.view.getStacks().get(this.slotNumber).getId(), GuiScreen.func_146272_n()));
                    } else if (this.grid.getGridType() != GridType.FLUID) {
                        int flags = 0;
                        if (clickedButton == 1) {
                            flags |= 1;
                        }
                        if (GuiScreen.func_146272_n()) {
                            flags |= 4;
                        }
                        if (clickedButton == 2) {
                            flags |= 2;
                        }
                        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridItemPull(stack.getId(), flags));
                    }
                }
            }
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (this.searchField == null || this.func_146983_a(keyCode)) {
            return;
        }
        if (this.searchField.func_146201_a(character, keyCode)) {
            this.keyHandled = true;
        } else if (keyCode == RSKeyBindings.CLEAR_GRID_CRAFTING_MATRIX.func_151463_i()) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridClear());
        } else {
            super.func_73869_a(character, keyCode);
        }
    }

    public TextFieldSearch getSearchField() {
        return this.searchField;
    }

    public void updateOredictPattern(boolean checked) {
        if (this.oredictPattern != null) {
            this.oredictPattern.setIsChecked(checked);
        }
    }

    public void updateScrollbar() {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > this.getVisibleRows());
            this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
        }
    }

    public void resetLockedStackUUID() {
        this.lockedStackUUID = null;
    }

    @Nullable
    public UUID getLockedStackUUID() {
        return this.lockedStackUUID;
    }

    public static List<IGridSorter> getSorters() {
        LinkedList<IGridSorter> sorters = new LinkedList<IGridSorter>();
        sorters.add(GuiGrid.getDefaultSorter());
        sorters.add(new GridSorterQuantity());
        sorters.add(new GridSorterID());
        sorters.add(new GridSorterInventoryTweaks());
        sorters.add(new GridSorterLastModified());
        return sorters;
    }

    public static IGridSorter getDefaultSorter() {
        return new GridSorterName();
    }
}

