/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.stack;

import com.raoulvdberge.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.OreDictionary;

public class GridStackItem
implements IGridStack {
    private UUID id;
    @Nullable
    private UUID otherId;
    private final ItemStack stack;
    private long count;
    private String cachedName;
    private boolean craftable;
    private String[] oreIds = null;
    @Nullable
    private StorageTrackerEntry entry;
    private String modId;
    private String modName;
    private String tooltip;

    public GridStackItem(ItemStack stack, long count) {
        this.stack = stack;
        this.count = count;
    }

    public GridStackItem(UUID id, @Nullable UUID otherId, ItemStack stack, long count, boolean craftable, @Nullable StorageTrackerEntry entry) {
        this.id = id;
        this.otherId = otherId;
        this.stack = stack;
        this.count = count;
        this.craftable = craftable;
        this.entry = entry;
    }

    @Override
    @Nullable
    public UUID getOtherId() {
        return this.otherId;
    }

    @Override
    public void updateOtherId(@Nullable UUID otherId) {
        this.otherId = otherId;
    }

    @Nullable
    static String getModNameByModId(String modId) {
        ModContainer container = Loader.instance().getActiveModList().stream().filter(m -> m.getModId().equalsIgnoreCase(modId)).findFirst().orElse(null);
        return container == null ? null : container.getName();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getName() {
        try {
            if (this.cachedName == null) {
                this.cachedName = this.stack.func_82833_r();
            }
            return this.cachedName;
        }
        catch (Exception t) {
            return "";
        }
    }

    @Override
    public String getModId() {
        if (this.modId == null) {
            this.modId = this.stack.func_77973_b().getCreatorModId(this.stack);
            if (this.modId == null) {
                this.modId = "???";
            }
        }
        return this.modId;
    }

    @Override
    public String getModName() {
        if (this.modName == null) {
            this.modName = GridStackItem.getModNameByModId(this.getModId());
            if (this.modName == null) {
                this.modName = "???";
            }
        }
        return this.modName;
    }

    @Override
    public String[] getOreIds() {
        if (this.oreIds == null) {
            this.oreIds = this.stack.func_190926_b() ? new String[0] : (String[])Arrays.stream(OreDictionary.getOreIDs((ItemStack)this.stack)).mapToObj(OreDictionary::getOreName).toArray(String[]::new);
        }
        return this.oreIds;
    }

    @Override
    public String getTooltip(boolean cached) {
        if (this.tooltip == null) {
            try {
                this.tooltip = String.join((CharSequence)"\n", RenderUtils.getItemTooltip(this.stack));
            }
            catch (Exception e) {
                this.tooltip = "";
            }
        }
        if (cached) {
            return this.tooltip;
        }
        try {
            return String.join((CharSequence)"\n", RenderUtils.getItemTooltip(this.stack));
        }
        catch (Exception t) {
            return "";
        }
    }

    @Override
    public long getQuantity() {
        return this.isCraftable() ? 0L : this.getCount();
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void setCount(long count) {
        this.count = count;
    }

    @Override
    public void grow(long count) {
        this.count += count;
    }

    @Override
    public String getFormattedFullQuantity() {
        return API.instance().getQuantityFormatter().format(this.getQuantity());
    }

    @Override
    public void draw(GuiBase gui, int x, int y) {
        String text = null;
        if (this.isCraftable()) {
            text = I18n.func_135052_a((String)"gui.refinedstorage:grid.craft", (Object[])new Object[0]);
        } else if (this.getCount() > 1L) {
            text = API.instance().getQuantityFormatter().formatWithUnits(this.getQuantity());
        }
        gui.drawItem(x, y, this.stack, true, text);
    }

    @Override
    public Object getIngredient() {
        return this.getStack();
    }

    @Override
    @Nullable
    public StorageTrackerEntry getTrackerEntry() {
        return this.entry;
    }

    @Override
    public void setTrackerEntry(@Nullable StorageTrackerEntry entry) {
        this.entry = entry;
    }
}

