/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.view;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterParser;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterDirection;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.IGridSorter;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.gui.grid.view.IGridView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class GridViewImpl
implements IGridView {
    private final GuiGrid gui;
    private boolean canCraft;
    private boolean active;
    private final IGridSorter defaultSorter;
    private final List<IGridSorter> sorters;
    private List<IGridStack> stacks = new ArrayList<IGridStack>();
    protected final Map<UUID, IGridStack> map = new HashMap<UUID, IGridStack>();

    public GridViewImpl(GuiGrid gui, IGridSorter defaultSorter, List<IGridSorter> sorters) {
        this.gui = gui;
        this.defaultSorter = defaultSorter;
        this.sorters = sorters;
    }

    @Override
    public void sort() {
        if (this.gui.getGrid().isActive()) {
            Predicate<IGridStack> activeFilters = this.getActiveFilters();
            this.gui.resetLockedStackUUID();
            this.stacks = new ArrayList<IGridStack>(this.map.values());
            this.stacks.removeIf(gridStack -> {
                if (this.gui.getGrid().getViewType() != 2 && gridStack.isCraftable() && gridStack.getOtherId() != null && this.map.containsKey(gridStack.getOtherId())) {
                    return true;
                }
                return !activeFilters.test((IGridStack)gridStack);
            });
            this.stacks.sort(this.getActiveSort());
            this.active = true;
        } else {
            this.stacks = new ArrayList<IGridStack>();
            this.active = false;
        }
        this.gui.updateScrollbar();
    }

    @Override
    public void postChange(IGridStack stack, long delta) {
        boolean lockedStackModified;
        if (!this.active) {
            return;
        }
        if (!stack.isCraftable() && stack.getOtherId() != null && this.map.containsKey(stack.getOtherId())) {
            IGridStack craftingStack = this.map.get(stack.getOtherId());
            craftingStack.updateOtherId(stack.getId());
            craftingStack.setTrackerEntry(stack.getTrackerEntry());
        }
        IGridStack existing = this.map.get(stack.getId());
        boolean stillExists = true;
        UUID lockedStackUUID = this.gui.getLockedStackUUID();
        boolean lockedStackExists = this.map.containsKey(lockedStackUUID);
        boolean bl = lockedStackModified = lockedStackUUID != null && (lockedStackUUID.equals(stack.getId()) || stack.getOtherId() != null && stack.getOtherId().equals(lockedStackUUID));
        if (!lockedStackModified) {
            this.stacks.remove(this.map.get(lockedStackUUID));
        }
        Predicate<IGridStack> activeFilters = this.getActiveFilters();
        if (existing == null) {
            IGridStack craftingStack;
            stack.setCount(delta);
            this.map.put(stack.getId(), stack);
            if (!stack.isCraftable() && stack.getOtherId() != null && (craftingStack = this.map.get(stack.getOtherId())) != null) {
                this.stacks.remove(craftingStack);
            }
            existing = stack;
        } else {
            existing.grow(delta);
            this.stacks.remove(existing);
            if (existing.getCount() <= 0L) {
                IGridStack craftingStack;
                this.map.remove(existing.getId());
                if (!existing.isCraftable() && existing.getOtherId() != null && (craftingStack = this.map.get(stack.getOtherId())) != null && activeFilters.test(craftingStack)) {
                    this.binaryInsert(craftingStack);
                }
                stillExists = false;
            }
            existing.setTrackerEntry(stack.getTrackerEntry());
        }
        if (!lockedStackModified && stillExists && activeFilters.test(existing)) {
            this.binaryInsert(existing);
        }
        if (lockedStackExists && (stillExists || !lockedStackModified)) {
            this.indexedInsert(this.gui.getSlotNumber(), this.map.get(lockedStackUUID));
        }
        this.gui.updateScrollbar();
    }

    private void binaryInsert(IGridStack stack) {
        int insertionPos = Collections.binarySearch(this.stacks, stack, this.getActiveSort());
        if (insertionPos < 0) {
            insertionPos = -insertionPos - 1;
        }
        this.stacks.add(insertionPos, stack);
    }

    private void indexedInsert(int index, IGridStack stack) {
        index = Math.min(index, this.stacks.size());
        this.stacks.add(index, stack);
    }

    @Override
    public void setStacks(List<IGridStack> stacks) {
        this.map.clear();
        for (IGridStack stack : stacks) {
            this.map.put(stack.getId(), stack);
        }
    }

    @Override
    public void setCanCraft(boolean canCraft) {
        this.canCraft = canCraft;
    }

    @Override
    public boolean canCraft() {
        return this.canCraft;
    }

    private Predicate<IGridStack> getActiveFilters() {
        IGrid grid = this.gui.getGrid();
        return GridFilterParser.getFilters(grid, this.gui.getSearchField() != null ? this.gui.getSearchField().func_146179_b() : "", grid.getTabSelected() >= 0 && grid.getTabSelected() < grid.getTabs().size() ? grid.getTabs().get(grid.getTabSelected()).getFilters() : grid.getFilters());
    }

    private Comparator<IGridStack> getActiveSort() {
        IGrid grid = this.gui.getGrid();
        GridSorterDirection sortingDirection = grid.getSortingDirection() == 1 ? GridSorterDirection.DESCENDING : GridSorterDirection.ASCENDING;
        return Stream.concat(Stream.of(this.defaultSorter), this.sorters.stream().filter(s -> s.isApplicable(grid))).map(sorter -> (o1, o2) -> sorter.compare((IGridStack)o1, (IGridStack)o2, sortingDirection)).reduce((l, r) -> r.thenComparing(l)).orElseThrow(IllegalStateException::new);
    }

    @Override
    @Nullable
    public IGridStack get(UUID id) {
        return this.map.get(id);
    }

    @Override
    public List<IGridStack> getStacks() {
        return this.stacks;
    }
}

