/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.oc;

import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.integration.oc.EnvironmentNetwork;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import li.cil.oc.api.driver.Converter;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ConverterCraftingTask
implements Converter {
    public void convert(Object value, Map<Object, Object> output) {
        if (value instanceof ICraftingTask) {
            ICraftingTask task = (ICraftingTask)value;
            ObjectArrayList missingItemStacks = new ObjectArrayList();
            for (StackListEntry<ItemStack> entry : task.getMissing().getStacks()) {
                missingItemStacks.add(EnvironmentNetwork.serializeItemStackStackListEntry(entry));
            }
            ObjectArrayList missingFluidStacks = new ObjectArrayList();
            for (StackListEntry<FluidStack> entry : task.getMissingFluids().getStacks()) {
                missingFluidStacks.add(EnvironmentNetwork.serializeFluidStackListEntry(entry));
            }
            output.put("stack", task.getRequested());
            output.put("missing", missingItemStacks);
            output.put("missingFluids", missingFluidStacks);
            output.put("pattern", task.getPattern());
            output.put("quantity", task.getQuantity());
        }
    }
}

