/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.oc;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IStorageExternal;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EnvironmentNetwork
extends AbstractManagedEnvironment {
    protected final INetworkNode node;
    private static final String ERROR_NOT_CONNECTED = "not connected";
    private final List<Map<String, Object>> list = new ObjectArrayList();

    public EnvironmentNetwork(INetworkNode node) {
        this.node = node;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("refinedstorage", Visibility.Network).create());
    }

    @Callback(doc="function():boolean -- Whether the node is connected.")
    public Object[] isConnected(Context context, Arguments args) {
        return new Object[]{this.node.canUpdate()};
    }

    @Callback(doc="function():number -- Gets the energy usage of this network.")
    public Object[] getEnergyUsage(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        return new Object[]{this.node.getNetwork().getEnergyUsage()};
    }

    @Callback(doc="function():table -- Gets the crafting tasks of this network.")
    public Object[] getTasks(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        return new Object[]{this.node.getNetwork().getCraftingManager().getTasks()};
    }

    @Callback(doc="function(stack:table):table -- Get one pattern of this network.")
    public Object[] getPattern(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        ItemStack stack = args.checkItemStack(0);
        return new Object[]{this.node.getNetwork().getCraftingManager().getPattern(stack)};
    }

    @Callback(doc="function(stack:table):table -- Get one fluid pattern of this network.")
    public Object[] getFluidPattern(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        FluidStack stack = this.checkFluid(args.checkTable(0), 1000);
        return new Object[]{this.node.getNetwork().getCraftingManager().getPattern(stack)};
    }

    @Callback(doc="function():table -- Gets the patterns of this network.")
    public Object[] getPatterns(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        LinkedList<ItemStack> patterns = new LinkedList<ItemStack>();
        for (ICraftingPattern pattern : this.node.getNetwork().getCraftingManager().getPatterns()) {
            if (pattern.getOutputs().isEmpty()) continue;
            patterns.addAll((Collection<ItemStack>)pattern.getOutputs());
        }
        return new Object[]{patterns};
    }

    @Callback(doc="function():table -- Gets the fluid patterns of this network.")
    public Object[] getFluidPatterns(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        LinkedList<FluidStack> patterns = new LinkedList<FluidStack>();
        for (ICraftingPattern pattern : this.node.getNetwork().getCraftingManager().getPatterns()) {
            if (pattern.getFluidOutputs().isEmpty()) continue;
            patterns.addAll((Collection<FluidStack>)pattern.getFluidOutputs());
        }
        return new Object[]{patterns};
    }

    @Callback(doc="function(stack:table):boolean -- Whether a crafting pattern exists for this item.")
    public Object[] hasPattern(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        ItemStack stack = args.checkItemStack(0);
        return new Object[]{this.node.getNetwork().getCraftingManager().getPattern(stack) != null};
    }

    @Callback(doc="function(stack:table):boolean -- Whether a crafting pattern exists for this fluid.")
    public Object[] hasFluidPattern(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        FluidStack stack = this.checkFluid(args.checkTable(0), 1000);
        return new Object[]{this.node.getNetwork().getCraftingManager().getPattern(stack) != null};
    }

    @Callback(doc="function(stack:table[, count: number[, canSchedule: boolean]]):table -- Schedules a crafting task.")
    public Object[] scheduleTask(Context context, Arguments args) {
        ICraftingTaskError error;
        if (this.node.getNetwork() == null) {
            return new Object[]{ERROR_NOT_CONNECTED};
        }
        ItemStack stack = args.checkItemStack(0);
        int amount = args.optInteger(1, 1);
        ICraftingTask task = this.node.getNetwork().getCraftingManager().create(stack, (long)amount);
        if (task == null) {
            throw new IllegalArgumentException("Could not create crafting task");
        }
        try {
            error = task.calculate();
        }
        catch (Throwable t) {
            t.printStackTrace();
            task.onCancelled();
            return new Object[0];
        }
        if (error == null && !task.hasMissing() && args.optBoolean(2, true)) {
            task.setCanUpdate(true);
            this.node.getNetwork().getCraftingManager().add(task);
        }
        return new Object[]{task};
    }

    @Callback(doc="function(stack:table[, count: number[, canSchedule: boolean]]):table -- Schedules a fluid crafting task.")
    public Object[] scheduleFluidTask(Context context, Arguments args) {
        ICraftingTaskError error;
        if (this.node.getNetwork() == null) {
            return new Object[]{ERROR_NOT_CONNECTED};
        }
        FluidStack stack = this.checkFluid(args.checkTable(0), args.optInteger(1, 1000));
        ICraftingTask task = this.node.getNetwork().getCraftingManager().create(stack, (long)stack.amount);
        if (task == null) {
            throw new IllegalArgumentException("Could not create crafting task");
        }
        try {
            error = task.calculate();
        }
        catch (Throwable t) {
            t.printStackTrace();
            task.onCancelled();
            return new Object[0];
        }
        if (error == null && !task.hasMissing() && args.optBoolean(2, true)) {
            task.setCanUpdate(true);
            this.node.getNetwork().getCraftingManager().add(task);
        }
        return new Object[]{task};
    }

    @Callback(doc="function(stack:table):number -- Cancels a task and returns the amount of tasks cancelled.")
    public Object[] cancelTask(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        ItemStack stack = args.checkItemStack(0);
        int count = 0;
        for (ICraftingTask task : this.node.getNetwork().getCraftingManager().getTasks()) {
            if (task.getRequested().getItem() == null || !API.instance().getComparer().isEqual(task.getRequested().getItem(), stack, 3)) continue;
            this.node.getNetwork().getCraftingManager().cancel(task.getId());
            ++count;
        }
        return new Object[]{count};
    }

    @Callback(doc="function(stack:table):number -- Cancels a fluid task and returns the amount of tasks cancelled.")
    public Object[] cancelFluidTask(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        FluidStack stack = this.checkFluid(args.checkTable(0), 1000);
        int count = 0;
        for (ICraftingTask task : this.node.getNetwork().getCraftingManager().getTasks()) {
            if (task.getRequested().getFluid() == null || !API.instance().getComparer().isEqual(task.getRequested().getFluid(), stack, 2)) continue;
            this.node.getNetwork().getCraftingManager().cancel(task.getId());
            ++count;
        }
        return new Object[]{count};
    }

    @Callback(doc="function(stack:table[, amount:number[, direction:number]]):table -- Extracts a fluid from the network.")
    public Object[] extractFluid(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        FluidStack stack = this.checkFluid(args.checkTable(0), args.checkInteger(1));
        EnumFacing facing = EnumFacing.func_82600_a((int)args.optInteger(2, 0));
        TileEntity targetEntity = this.node.getNetwork().world().func_175625_s(this.node.getNetworkNodePos().func_177972_a(facing));
        if (targetEntity == null || !targetEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
            throw new IllegalArgumentException("No fluid tank on the given side");
        }
        FluidStack extractedSim = this.node.getNetwork().extractFluid(stack, stack.amount, Action.SIMULATE);
        if (extractedSim == null || extractedSim.amount <= 0) {
            return new Object[]{null, "could not extract the specified fluid"};
        }
        IFluidHandler handler = (IFluidHandler)targetEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
        int filledAmountSim = handler.fill(extractedSim, false);
        if (filledAmountSim <= 0) {
            return new Object[]{0};
        }
        FluidStack extractedActual = this.node.getNetwork().extractFluid(stack, filledAmountSim, Action.PERFORM);
        int filledAmountActual = handler.fill(extractedActual, true);
        if (extractedActual != null && extractedActual.amount > filledAmountActual) {
            this.node.getNetwork().insertFluid(stack, extractedActual.amount - filledAmountActual, Action.PERFORM);
        }
        return new Object[]{filledAmountActual};
    }

    @Callback(doc="function(stack:table):table -- Gets a fluid from the network.")
    public Object[] getFluid(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        FluidStack needle = this.checkFluid(args.checkTable(0), 1000);
        return new Object[]{this.node.getNetwork().getFluidStorageCache().getList().getEntry(needle, 2)};
    }

    @Callback(doc="function():table -- Gets a list of all fluids in this network.")
    public Object[] getFluids(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        ObjectArrayList result = new ObjectArrayList();
        for (StackListEntry<FluidStack> entry : this.node.getNetwork().getFluidStorageCache().getList().getStacks()) {
            this.list.add(EnvironmentNetwork.serializeFluidStackListEntry(entry));
        }
        return new Object[]{result};
    }

    @Callback(doc="function(stack:table[, count:number[, direction:number]]):table -- Extracts an item from the network.")
    public Object[] extractItem(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        ItemStack stack = args.checkItemStack(0);
        int count = Math.max(1, args.optInteger(1, 1));
        count = Math.min(count, stack.func_77976_d());
        EnumFacing facing = EnumFacing.func_82600_a((int)args.optInteger(2, 0));
        TileEntity targetEntity = this.node.getNetwork().world().func_175625_s(this.node.getNetworkNodePos().func_177972_a(facing));
        if (targetEntity == null || !targetEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
            throw new IllegalArgumentException("No inventory on the given side");
        }
        StackListResult<ItemStack> extracted = this.node.getNetwork().extractItem(stack, (long)count, Action.SIMULATE);
        if (extracted == null) {
            return new Object[]{null, "could not extract the specified item"};
        }
        long transferableAmount = extracted.getCount();
        IItemHandler handler = (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)extracted.getFixedStack(), (boolean)true);
        if (!remainder.func_190926_b()) {
            transferableAmount -= (long)remainder.func_190916_E();
        }
        if (transferableAmount <= 0L) {
            return new Object[]{0};
        }
        extracted = this.node.getNetwork().extractItem(stack, transferableAmount, Action.PERFORM);
        if (extracted != null && !(remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)extracted.getFixedStack(), (boolean)false)).func_190926_b()) {
            this.node.getNetwork().insertItem(remainder, (long)remainder.func_190916_E(), Action.PERFORM);
        }
        return new Object[]{transferableAmount};
    }

    @Callback(doc="function(stack:table[, compareMeta:boolean[, compareNBT:boolean]]):table -- Gets an item from the network.")
    public Object[] getItem(Context context, Arguments args) {
        StackListEntry<ItemStack> entry;
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        ItemStack stack = args.checkItemStack(0);
        boolean compareMeta = args.optBoolean(1, true);
        boolean compareNBT = args.optBoolean(2, true);
        int flags = 0;
        if (compareMeta) {
            flags |= 1;
        }
        if (compareNBT) {
            flags |= 2;
        }
        if ((entry = this.node.getNetwork().getItemStorageCache().getList().getEntry(stack, flags)) == null) {
            return new Object[]{null};
        }
        return new Object[]{EnvironmentNetwork.serializeItemStackStackListEntry(entry)};
    }

    @Callback(doc="function():table -- Gets a list of all items in this network.")
    public Object[] getItems(Context context, Arguments args) {
        this.list.clear();
        if (this.node.getNetwork() == null) {
            return new Object[]{null, ERROR_NOT_CONNECTED};
        }
        for (StackListEntry<ItemStack> entry : this.node.getNetwork().getItemStorageCache().getList().getStacks()) {
            this.list.add(EnvironmentNetwork.serializeItemStackStackListEntry(entry));
        }
        return new Object[]{this.list};
    }

    @Callback(doc="function():table -- Gets a list of all connected storage disks and blocks in this network.")
    public Object[] getStorages(Context context, Arguments args) {
        long totalItemStored = 0L;
        long totalItemCapacity = 0L;
        long totalFluidStored = 0L;
        long totalFluidCapacity = 0L;
        ArrayList devices = new ArrayList();
        Function<IStorage, Long> getCapacity = storage -> {
            if (storage instanceof IStorageDisk) {
                return ((IStorageDisk)storage).getCapacity();
            }
            if (storage instanceof IStorageExternal) {
                return ((IStorageExternal)storage).getCapacity();
            }
            throw new IllegalArgumentException();
        };
        if (this.node.getNetwork() != null) {
            long capacity;
            HashMap<String, Object> data;
            for (IStorage<ItemStack> iStorage : this.node.getNetwork().getItemStorageCache().getStorages()) {
                if (!(iStorage instanceof IStorageDisk) && !(iStorage instanceof IStorageExternal)) continue;
                data = new HashMap<String, Object>();
                data.put("type", "item");
                data.put("usage", iStorage.getStored());
                totalItemStored += iStorage.getStored();
                capacity = getCapacity.apply(iStorage);
                data.put("capacity", capacity);
                totalItemCapacity += capacity;
                devices.add(data);
            }
            for (IStorage<ItemStack> iStorage : this.node.getNetwork().getFluidStorageCache().getStorages()) {
                if (!(iStorage instanceof IStorageDisk) && !(iStorage instanceof IStorageExternal)) continue;
                data = new HashMap();
                data.put("type", "fluid");
                data.put("usage", iStorage.getStored());
                totalItemStored += iStorage.getStored();
                capacity = getCapacity.apply(iStorage);
                data.put("capacity", capacity);
                totalItemCapacity += capacity;
                devices.add(data);
            }
        }
        HashMap<String, Long> itemTotals = new HashMap<String, Long>();
        itemTotals.put("usage", totalItemStored);
        itemTotals.put("capacity", totalItemCapacity);
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("usage", totalFluidStored);
        hashMap.put("capacity", totalFluidCapacity);
        HashMap<String, HashMap<String, Long>> totals = new HashMap<String, HashMap<String, Long>>();
        totals.put("item", itemTotals);
        totals.put("fluid", hashMap);
        HashMap<String, Cloneable> response = new HashMap<String, Cloneable>();
        response.put("total", totals);
        response.put("devices", devices);
        return new Object[]{response};
    }

    private FluidStack checkFluid(Map<String, Object> fluidMap, int amount) {
        if (!fluidMap.containsKey("name") || !(fluidMap.get("name") instanceof String) || ((String)fluidMap.get("name")).length() == 0) {
            throw new IllegalArgumentException("no fluid name");
        }
        String fluid = (String)fluidMap.get("name");
        FluidStack stack = FluidRegistry.getFluidStack((String)fluid, (int)(amount = Math.max(1, amount)));
        if (stack == null) {
            throw new IllegalArgumentException("invalid fluid stack, does not exist");
        }
        return stack;
    }

    static Map<String, Object> serializeItemStackStackListEntry(StackListEntry<ItemStack> entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ItemStack stack = entry.getStack();
        map.put("damage", stack.func_77952_i());
        map.put("maxDamage", stack.func_77958_k());
        map.put("size", entry.getCount());
        map.put("maxSize", stack.func_77976_d());
        map.put("name", Item.field_150901_e.func_177774_c((Object)stack.func_77973_b()));
        map.put("label", stack.func_82833_r());
        return map;
    }

    static Map<String, Object> serializeFluidStackListEntry(StackListEntry<FluidStack> entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("size", entry.getCount());
        map.put("stack", entry.getStack());
        return map;
    }
}

