/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory.fluid;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerProxy
implements IFluidHandler {
    private final FluidTank insertHandler;
    private final FluidTank extractHandler;
    private final IFluidTankProperties[] properties;

    public FluidHandlerProxy(FluidTank insertHandler, FluidTank extractHandler) {
        this.insertHandler = insertHandler;
        this.extractHandler = extractHandler;
        this.properties = new IFluidTankProperties[]{new FluidTankPropertiesWrapper(insertHandler), new FluidTankPropertiesWrapper(extractHandler)};
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.insertHandler.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.extractHandler.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.extractHandler.drain(maxDrain, doDrain);
    }
}

