/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory.fluid;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class FluidInventory {
    private static final String NBT_SLOT = "Slot_%d";
    private final FluidStack[] fluids;
    private final int maxAmount;
    private boolean empty = true;
    @Nullable
    protected Consumer<Integer> listener;

    public FluidInventory(int size, int maxAmount, @Nullable Consumer<Integer> listener) {
        this.fluids = new FluidStack[size];
        this.maxAmount = maxAmount;
        this.listener = listener;
    }

    public FluidInventory(int size, @Nullable Consumer<Integer> listener) {
        this(size, Integer.MAX_VALUE, listener);
    }

    public FluidInventory(int size) {
        this(size, Integer.MAX_VALUE, null);
    }

    public int getSlots() {
        return this.fluids.length;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public FluidStack[] getFluids() {
        return this.fluids;
    }

    @Nullable
    public FluidStack getFluid(int slot) {
        return this.fluids[slot];
    }

    public void setFluid(int slot, @Nullable FluidStack stack) {
        if (stack != null && stack.amount <= 0 && stack.amount > this.maxAmount) {
            throw new IllegalArgumentException("Fluid size is invalid (given: " + stack.amount + ", max size: " + this.maxAmount + ")");
        }
        this.fluids[slot] = stack;
        if (this.listener != null) {
            this.listener.accept(slot);
        }
        this.updateEmptyState();
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < this.getSlots(); ++i) {
            FluidStack stack = this.getFluid(i);
            if (stack == null) continue;
            tag.func_74782_a(String.format(NBT_SLOT, i), (NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public void readFromNbt(NBTTagCompound tag) {
        for (int i = 0; i < this.getSlots(); ++i) {
            String key = String.format(NBT_SLOT, i);
            if (!tag.func_74764_b(key)) continue;
            this.fluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l(key));
        }
        this.updateEmptyState();
    }

    private void updateEmptyState() {
        this.empty = true;
        for (FluidStack fluid : this.fluids) {
            if (fluid == null) continue;
            this.empty = false;
            return;
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

