/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.storage.StorageType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskSyncData;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.block.enums.FluidStorageType;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.item.info.ItemInfo;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidStorageDisk
extends ItemBase
implements IStorageDiskProvider {
    private static final String NBT_ID = "Id";
    public static final int TYPE_64K = 0;
    public static final int TYPE_256K = 1;
    public static final int TYPE_1024K = 2;
    public static final int TYPE_4096K = 3;
    public static final int TYPE_CREATIVE = 4;

    public ItemFluidStorageDisk() {
        super(new ItemInfo("refinedstorage", "fluid_storage_disk"));
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModelVariants(this, new ResourceLocation("refinedstorage", "64k_fluid_storage_disk"), new ResourceLocation("refinedstorage", "256k_fluid_storage_disk"), new ResourceLocation("refinedstorage", "1024k_fluid_storage_disk"), new ResourceLocation("refinedstorage", "4096k_fluid_storage_disk"), new ResourceLocation("refinedstorage", "creative_fluid_storage_disk"));
        modelRegistration.setModel(this, 0, new ModelResourceLocation("refinedstorage:64k_fluid_storage_disk", "inventory"));
        modelRegistration.setModel(this, 1, new ModelResourceLocation("refinedstorage:256k_fluid_storage_disk", "inventory"));
        modelRegistration.setModel(this, 2, new ModelResourceLocation("refinedstorage:1024k_fluid_storage_disk", "inventory"));
        modelRegistration.setModel(this, 3, new ModelResourceLocation("refinedstorage:4096k_fluid_storage_disk", "inventory"));
        modelRegistration.setModel(this, 4, new ModelResourceLocation("refinedstorage:creative_fluid_storage_disk", "inventory"));
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!world.field_72995_K && !stack.func_77942_o()) {
            UUID id = UUID.randomUUID();
            API.instance().getStorageDiskManager(world).set(id, API.instance().createDefaultFluidDisk(world, this.getCapacity(stack)));
            API.instance().getStorageDiskManager(world).markForSaving();
            this.setId(stack, id);
        }
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (this.isValid(stack)) {
            UUID id = this.getId(stack);
            API.instance().getStorageDiskSync().sendRequest(id);
            IStorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity2() == -1L) {
                    tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored2())}));
                } else {
                    tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored_capacity", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored2()), API.instance().getQuantityFormatter().format(data.getCapacity2())}));
                }
            }
            if (flag.func_194127_a()) {
                tooltip.add(id.toString());
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        IStorageDisk<?> disk;
        ItemStack diskStack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_70093_af() && diskStack.func_77960_j() != 4 && (disk = API.instance().getStorageDiskManager(world).getByStack(diskStack)) != null && disk.getStored() == 0L) {
            ItemStack storagePart = new ItemStack((Item)RSItems.FLUID_STORAGE_PART, diskStack.func_190916_E(), diskStack.func_77960_j());
            if (!player.field_71071_by.func_70441_a(storagePart.func_77946_l())) {
                InventoryHelper.func_180173_a((World)world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)storagePart);
            }
            API.instance().getStorageDiskManager(world).remove(this.getId(diskStack));
            API.instance().getStorageDiskManager(world).markForSaving();
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)RSItems.STORAGE_HOUSING));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)diskStack);
    }

    public int getEntityLifespan(@Nonnull ItemStack stack, @Nonnull World world) {
        return Integer.MAX_VALUE;
    }

    @Override
    public UUID getId(ItemStack disk) {
        return disk.func_77978_p().func_186857_a(NBT_ID);
    }

    @Override
    public void setId(ItemStack disk, UUID id) {
        disk.func_77982_d(new NBTTagCompound());
        disk.func_77978_p().func_186854_a(NBT_ID, id);
    }

    @Override
    public boolean isValid(ItemStack disk) {
        return disk.func_77942_o() && disk.func_77978_p().func_186855_b(NBT_ID);
    }

    @Override
    public int getCapacity(ItemStack disk) {
        return FluidStorageType.getById(disk.func_77952_i()).getCapacity();
    }

    @Override
    public StorageType getType() {
        return StorageType.FLUID;
    }
}

