/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.item.info.ItemInfo;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNetworkCard
extends ItemBase {
    private static final String NBT_RECEIVER_X = "ReceiverX";
    private static final String NBT_RECEIVER_Y = "ReceiverY";
    private static final String NBT_RECEIVER_Z = "ReceiverZ";
    private static final String NBT_DIMENSION = "Dimension";

    public ItemNetworkCard() {
        super(new ItemInfo("refinedstorage", "network_card"));
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "inventory"));
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == RSBlocks.NETWORK_RECEIVER) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(NBT_RECEIVER_X, pos.func_177958_n());
            tag.func_74768_a(NBT_RECEIVER_Y, pos.func_177956_o());
            tag.func_74768_a(NBT_RECEIVER_Z, pos.func_177952_p());
            tag.func_74768_a(NBT_DIMENSION, world.field_73011_w.getDimension());
            player.func_184586_b(hand).func_77982_d(tag);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        BlockPos pos = ItemNetworkCard.getReceiver(stack);
        if (pos != null) {
            tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:network_card.tooltip", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
        }
    }

    public static BlockPos getReceiver(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_RECEIVER_X) && stack.func_77978_p().func_74764_b(NBT_RECEIVER_Y) && stack.func_77978_p().func_74764_b(NBT_RECEIVER_Z)) {
            return new BlockPos(stack.func_77978_p().func_74762_e(NBT_RECEIVER_X), stack.func_77978_p().func_74762_e(NBT_RECEIVER_Y), stack.func_77978_p().func_74762_e(NBT_RECEIVER_Z));
        }
        return null;
    }

    public static int getDimension(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_DIMENSION) ? stack.func_77978_p().func_74762_e(NBT_DIMENSION) : 0;
    }
}

