/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemProvider;
import com.raoulvdberge.refinedstorage.item.ItemEnergyItem;
import com.raoulvdberge.refinedstorage.item.info.IItemInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public abstract class ItemNetworkItem
extends ItemEnergyItem
implements INetworkItemProvider {
    private static final String NBT_CONTROLLER_X = "ControllerX";
    private static final String NBT_CONTROLLER_Y = "ControllerY";
    private static final String NBT_CONTROLLER_Z = "ControllerZ";
    private static final String NBT_DIMENSION_ID = "DimensionID";
    private static final Map<UUID, Long> COOLDOWNS = new HashMap<UUID, Long>();

    public ItemNetworkItem(IItemInfo info, int energyCapacity) {
        super(info, energyCapacity);
        this.func_185043_a(new ResourceLocation("connected"), (stack, world, entity) -> entity != null && this.isValid(stack) ? 1.0f : 0.0f);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            long currentTimeMillis = System.currentTimeMillis();
            Long lastClicked = COOLDOWNS.get(player.func_110124_au());
            if (lastClicked == null || currentTimeMillis - lastClicked > 300L) {
                COOLDOWNS.put(player.func_110124_au(), currentTimeMillis);
                this.applyNetwork(stack, n -> n.getNetworkItemHandler().open(player, player.func_184586_b(hand), player.field_71071_by.field_70461_c), arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void applyNetwork(ItemStack stack, Consumer<INetwork> networkConsumer, Consumer<TextComponentTranslation> errorConsumer) {
        if (!this.isValid(stack)) {
            errorConsumer.accept(new TextComponentTranslation("misc.refinedstorage:network_item.not_found", new Object[0]));
        } else {
            TileEntity network;
            WorldServer networkWorld = DimensionManager.getWorld((int)ItemNetworkItem.getDimensionId(stack));
            if (networkWorld != null && (network = networkWorld.func_175625_s(new BlockPos(ItemNetworkItem.getX(stack), ItemNetworkItem.getY(stack), ItemNetworkItem.getZ(stack)))) instanceof INetwork) {
                networkConsumer.accept((INetwork)network);
            } else {
                errorConsumer.accept(new TextComponentTranslation("misc.refinedstorage:network_item.not_found", new Object[0]));
            }
        }
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (this.isValid(stack)) {
            tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:network_item.tooltip", (Object[])new Object[]{ItemNetworkItem.getX(stack), ItemNetworkItem.getY(stack), ItemNetworkItem.getZ(stack)}));
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == RSBlocks.CONTROLLER) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74768_a(NBT_CONTROLLER_X, pos.func_177958_n());
            tag.func_74768_a(NBT_CONTROLLER_Y, pos.func_177956_o());
            tag.func_74768_a(NBT_CONTROLLER_Z, pos.func_177952_p());
            tag.func_74768_a(NBT_DIMENSION_ID, player.field_71093_bK);
            stack.func_77982_d(tag);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static int getDimensionId(ItemStack stack) {
        return stack.func_77978_p().func_74762_e(NBT_DIMENSION_ID);
    }

    public static int getX(ItemStack stack) {
        return stack.func_77978_p().func_74762_e(NBT_CONTROLLER_X);
    }

    public static int getY(ItemStack stack) {
        return stack.func_77978_p().func_74762_e(NBT_CONTROLLER_Y);
    }

    public static int getZ(ItemStack stack) {
        return stack.func_77978_p().func_74762_e(NBT_CONTROLLER_Z);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean isValid(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_CONTROLLER_X) && stack.func_77978_p().func_74764_b(NBT_CONTROLLER_Y) && stack.func_77978_p().func_74764_b(NBT_CONTROLLER_Z) && stack.func_77978_p().func_74764_b(NBT_DIMENSION_ID);
    }
}

