/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.item.info.ItemInfo;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemUpgrade
extends ItemBase {
    public static final int TYPE_RANGE = 1;
    public static final int TYPE_SPEED = 2;
    public static final int TYPE_CRAFTING = 3;
    public static final int TYPE_STACK = 4;
    public static final int TYPE_SILK_TOUCH = 6;
    public static final int TYPE_FORTUNE_1 = 7;
    public static final int TYPE_FORTUNE_2 = 8;
    public static final int TYPE_FORTUNE_3 = 9;
    public static final int TYPE_REGULATOR = 10;
    public static final int TYPE_CREATIVE_RANGE = 11;

    public ItemUpgrade() {
        super(new ItemInfo("refinedstorage", "upgrade"));
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModelVariants(this, new ResourceLocation("refinedstorage", "upgrade"), new ResourceLocation("refinedstorage", "range_upgrade"), new ResourceLocation("refinedstorage", "speed_upgrade"), new ResourceLocation("refinedstorage", "stack_upgrade"), new ResourceLocation("refinedstorage", "silk_touch_upgrade"), new ResourceLocation("refinedstorage", "fortune_upgrade"), new ResourceLocation("refinedstorage", "regulator_upgrade"));
        modelRegistration.setModel(this, 0, new ModelResourceLocation("refinedstorage:upgrade", "inventory"));
        modelRegistration.setModel(this, 1, new ModelResourceLocation("refinedstorage:range_upgrade", "inventory"));
        modelRegistration.setModel(this, 11, new ModelResourceLocation("refinedstorage:range_upgrade", "inventory"));
        modelRegistration.setModel(this, 2, new ModelResourceLocation("refinedstorage:speed_upgrade", "inventory"));
        modelRegistration.setModel(this, 3, new ModelResourceLocation("refinedstorage:crafting_upgrade", "inventory"));
        modelRegistration.setModel(this, 4, new ModelResourceLocation("refinedstorage:stack_upgrade", "inventory"));
        modelRegistration.setModel(this, 6, new ModelResourceLocation("refinedstorage:silk_touch_upgrade", "inventory"));
        modelRegistration.setModel(this, 7, new ModelResourceLocation("refinedstorage:fortune_upgrade", "inventory"));
        modelRegistration.setModel(this, 8, new ModelResourceLocation("refinedstorage:fortune_upgrade", "inventory"));
        modelRegistration.setModel(this, 9, new ModelResourceLocation("refinedstorage:fortune_upgrade", "inventory"));
        modelRegistration.setModel(this, 10, new ModelResourceLocation("refinedstorage:regulator_upgrade", "inventory"));
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77960_j() == 6 || ItemUpgrade.getFortuneLevel(stack) > 0;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (ItemUpgrade.getFortuneLevel(stack) > 0) {
            tooltip.add(I18n.func_135052_a((String)"enchantment.lootBonusDigger", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("enchantment.level." + ItemUpgrade.getFortuneLevel(stack)), (Object[])new Object[0]));
        }
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i <= 11; ++i) {
            if (i == 5) continue;
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    public static int getFortuneLevel(@Nullable ItemStack stack) {
        if (stack != null) {
            if (stack.func_77960_j() == 7) {
                return 1;
            }
            if (stack.func_77960_j() == 8) {
                return 2;
            }
            if (stack.func_77960_j() == 9) {
                return 3;
            }
        }
        return 0;
    }

    public static int getEnergyUsage(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 1: {
                return RS.INSTANCE.config.rangeUpgradeUsage;
            }
            case 2: {
                return RS.INSTANCE.config.speedUpgradeUsage;
            }
            case 3: {
                return RS.INSTANCE.config.craftingUpgradeUsage;
            }
            case 4: {
                return RS.INSTANCE.config.stackUpgradeUsage;
            }
            case 6: {
                return RS.INSTANCE.config.silkTouchUpgradeUsage;
            }
            case 7: 
            case 8: 
            case 9: {
                return RS.INSTANCE.config.fortuneUpgradeUsagePerFortune * ItemUpgrade.getFortuneLevel(stack);
            }
            case 10: {
                return RS.INSTANCE.config.regulatorUpgradeUsage;
            }
        }
        return 0;
    }
}

