/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item.wrench;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeCrafter;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.Cover;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.block.BlockCable;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.item.ItemCover;
import com.raoulvdberge.refinedstorage.item.info.ItemInfo;
import com.raoulvdberge.refinedstorage.item.wrench.WrenchMode;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.collision.AdvancedRayTraceResult;
import com.raoulvdberge.refinedstorage.render.collision.AdvancedRayTracer;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.IRSFilterConfigProvider;
import com.raoulvdberge.refinedstorage.tile.config.IUpgradeContainer;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWrench
extends ItemBase {
    public ItemWrench() {
        super(new ItemInfo("refinedstorage", "wrench"));
        this.func_77625_d(1);
    }

    public static void addDefaultMode(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p() == null ? new NBTTagCompound() : stack.func_77978_p();
        if (!tag.func_74764_b("mode")) {
            tag.func_74778_a("mode", WrenchMode.COVER.name());
        }
        stack.func_77982_d(tag);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "inventory"));
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.FAIL;
        }
        ItemWrench.addDefaultMode(player.func_184614_ca());
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(tile instanceof TileNode)) {
            return EnumActionResult.FAIL;
        }
        INetworkNode node = ((TileNode)tile).getNode();
        if (node.getNetwork() != null && !node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, player)) {
            WorldUtils.sendNoPermissionMessage(player);
            return EnumActionResult.FAIL;
        }
        WrenchMode mode = WrenchMode.valueOf(player.func_184614_ca().func_77978_p().func_74779_i("mode"));
        if (mode == WrenchMode.COVER && block instanceof BlockCable && node instanceof ICoverable) {
            EnumFacing facingSelected;
            Cover targetCover;
            CoverManager manager = ((ICoverable)((Object)((TileNode)tile).getNode())).getCoverManager();
            AdvancedRayTraceResult<RayTraceResult> result = AdvancedRayTracer.rayTrace(pos, AdvancedRayTracer.getStart(player), AdvancedRayTracer.getEnd(player), ((BlockCable)block).getCollisions(tile, block.func_176221_a(state, (IBlockAccess)world, pos)));
            if (result != null && result.getGroup().getDirection() != null && (targetCover = manager.getCover(facingSelected = result.getGroup().getDirection())) != null) {
                ItemStack cover = targetCover.getType().createStack();
                ItemCover.setItem(cover, targetCover.getStack());
                manager.setCover(facingSelected, null);
                WorldUtils.updateBlock(world, pos);
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)cover);
                return EnumActionResult.SUCCESS;
            }
        } else {
            NBTTagCompound tag = player.func_184614_ca().func_77978_p();
            if (mode == WrenchMode.COPY) {
                if (node instanceof NetworkNode) {
                    if (node instanceof NetworkNodeCrafter) {
                        tag.func_74778_a("crafterMode", ((NetworkNodeCrafter)node).getCrafterMode().name());
                    } else {
                        tag.func_74778_a("redstoneMode", ((NetworkNode)node).getRedstoneMode().name());
                    }
                }
                if (node instanceof IUpgradeContainer) {
                    tag.func_74782_a("upgrades", (NBTBase)IUpgradeContainer.writeToNBT((IUpgradeContainer)((Object)node), new NBTTagCompound()));
                }
                if (node instanceof IRSFilterConfigProvider) {
                    IRSFilterConfigProvider configProvider = (IRSFilterConfigProvider)((Object)node);
                    configProvider.getConfig().writeToNBT(tag);
                    configProvider.writeExtraNbt(tag);
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("misc.refinedstorage:wrench.copied", new Object[0]));
            } else if (mode == WrenchMode.PASTE && !tag.func_82582_d()) {
                TextComponentString args = new TextComponentString("");
                if (node instanceof NetworkNode) {
                    if (node instanceof NetworkNodeCrafter && tag.func_74764_b("crafterMode")) {
                        ((NetworkNodeCrafter)node).setMode(ICraftingPatternContainer.CrafterMode.valueOf(tag.func_74779_i("crafterMode")));
                        args.func_150258_a(args.func_150253_a().size() == 0 ? "" : ", ").func_150257_a((ITextComponent)new TextComponentTranslation("sidebutton.refinedstorage:crafter_mode", new Object[0]));
                    } else if (tag.func_74764_b("redstoneMode")) {
                        ((NetworkNode)node).setRedstoneMode(RedstoneMode.valueOf(tag.func_74779_i("redstoneMode")));
                        args.func_150258_a(args.func_150253_a().size() == 0 ? "" : ", ").func_150257_a((ITextComponent)new TextComponentTranslation("sidebutton.refinedstorage:redstone_mode", new Object[0]));
                    }
                }
                if (node instanceof IUpgradeContainer && tag.func_74764_b("upgrades")) {
                    boolean success = IUpgradeContainer.readFromNBT((IUpgradeContainer)((Object)node), player, tag.func_74775_l("upgrades"));
                    args.func_150258_a(args.func_150253_a().size() == 0 ? "" : ", ").func_150257_a(new TextComponentTranslation("misc.refinedstorage:wrench.pasted.upgrades", new Object[0]).func_150255_a(new Style().func_150238_a(success ? TextFormatting.WHITE : TextFormatting.RED)));
                }
                if (node instanceof IRSFilterConfigProvider) {
                    IRSFilterConfigProvider configProvider = (IRSFilterConfigProvider)((Object)node);
                    configProvider.readExtraNbt(tag);
                    FilterConfig config = configProvider.getConfig();
                    NBTTagCompound configTag = tag.func_74775_l("config");
                    if (config.usesFilterType() && configTag.func_74764_b("type")) {
                        args.func_150258_a(args.func_150253_a().size() == 0 ? "" : ", ").func_150257_a((ITextComponent)new TextComponentTranslation("misc.refinedstorage:wrench.pasted.type", new Object[0]));
                    }
                    if (config.usesCompare() && configTag.func_74764_b("compare")) {
                        args.func_150258_a(args.func_150253_a().size() == 0 ? "" : ", ").func_150257_a((ITextComponent)new TextComponentTranslation("misc.refinedstorage:wrench.pasted.compareable", new Object[0]));
                    }
                    config.readFromNBT(tag);
                }
                if (!args.func_150253_a().isEmpty()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("misc.refinedstorage:wrench.pasted", new Object[]{args}));
                }
            } else if (mode == WrenchMode.ROTATE) {
                block.rotateBlock(world, pos, player.func_174811_aO().func_176734_d());
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

