/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.GuiCraftingPreview;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGridCraftingSettings;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageGridCraftingPreviewResponse
implements IMessage,
IMessageHandler<MessageGridCraftingPreviewResponse, IMessage> {
    private List<ICraftingPreviewElement<?>> stacks;
    private UUID id;
    private int quantity;
    private long calculationTime;
    private boolean fluids;

    public MessageGridCraftingPreviewResponse() {
    }

    public MessageGridCraftingPreviewResponse(List<ICraftingPreviewElement<?>> stacks, UUID id, long calculationTime, int quantity, boolean fluids) {
        this.stacks = stacks;
        this.id = id;
        this.quantity = quantity;
        this.calculationTime = calculationTime;
        this.fluids = fluids;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.quantity = buf.readInt();
        this.calculationTime = buf.readLong();
        this.fluids = buf.readBoolean();
        this.stacks = new LinkedList();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String type = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.stacks.add(API.instance().getCraftingPreviewElementRegistry().get(type).apply(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.writeInt(this.quantity);
        buf.writeLong(this.calculationTime);
        buf.writeBoolean(this.fluids);
        buf.writeInt(this.stacks.size());
        for (ICraftingPreviewElement<?> stack : this.stacks) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)stack.getId());
            stack.writeToByteBuf(buf);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageGridCraftingPreviewResponse message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            Object screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiGridCraftingSettings) {
                screen = ((GuiGridCraftingSettings)((Object)((Object)screen))).getParent();
            }
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiCraftingPreview((GuiScreen)screen, message.stacks, message.id, message.calculationTime, message.quantity, message.fluids));
        });
        return null;
    }
}

