/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageGridCraftingStart
extends MessageHandlerPlayerToServer<MessageGridCraftingStart>
implements IMessage {
    private UUID id;
    private int quantity;
    private boolean fluids;

    public MessageGridCraftingStart() {
    }

    public MessageGridCraftingStart(UUID id, int quantity, boolean fluids) {
        this.id = id;
        this.quantity = quantity;
        this.fluids = fluids;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.quantity = buf.readInt();
        this.fluids = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.writeInt(this.quantity);
        buf.writeBoolean(this.fluids);
    }

    @Override
    public void handle(MessageGridCraftingStart message, EntityPlayerMP player) {
        Container container = player.field_71070_bA;
        if (container instanceof ContainerGrid) {
            IGrid grid = ((ContainerGrid)container).getGrid();
            if (message.fluids) {
                if (grid.getFluidHandler() != null) {
                    grid.getFluidHandler().onCraftingStartRequested(player, message.id, message.quantity);
                }
            } else if (grid.getItemHandler() != null) {
                grid.getItemHandler().onCraftingRequested(player, message.id, message.quantity);
            }
        }
    }
}

