/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.gui.grid.view.GridViewImpl;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageGridFluidUpdate
implements IMessage,
IMessageHandler<MessageGridFluidUpdate, IMessage> {
    private INetwork network;
    private boolean canCraft;
    private final List<IGridStack> stacks = new ArrayList<IGridStack>();

    public MessageGridFluidUpdate() {
    }

    public MessageGridFluidUpdate(INetwork network, boolean canCraft) {
        this.network = network;
        this.canCraft = canCraft;
    }

    public void fromBytes(ByteBuf buf) {
        this.canCraft = buf.readBoolean();
        int items = buf.readInt();
        for (int i = 0; i < items; ++i) {
            this.stacks.add(StackUtils.readFluidGridStack(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.canCraft);
        int size = this.network.getFluidStorageCache().getList().getStacks().size() + this.network.getFluidStorageCache().getCraftablesList().getStacks().size();
        buf.writeInt(size);
        for (StackListEntry<FluidStack> stack : this.network.getFluidStorageCache().getList().getStacks()) {
            StackListEntry<FluidStack> craftingEntry = this.network.getFluidStorageCache().getCraftablesList().getEntry(stack.getStack(), 2);
            StackUtils.writeFluidGridStack(buf, stack.getStack(), stack.getCount(), stack.getId(), craftingEntry != null ? craftingEntry.getId() : null, false, this.network.getFluidStorageTracker().get(stack.getStack()));
        }
        for (StackListEntry<FluidStack> stack : this.network.getFluidStorageCache().getCraftablesList().getStacks()) {
            StackListEntry<FluidStack> regularEntry = this.network.getFluidStorageCache().getList().getEntry(stack.getStack(), 2);
            StackUtils.writeFluidGridStack(buf, stack.getStack(), stack.getCount(), stack.getId(), regularEntry != null ? regularEntry.getId() : null, true, this.network.getFluidStorageTracker().get(stack.getStack()));
        }
    }

    public IMessage onMessage(MessageGridFluidUpdate message, MessageContext ctx) {
        GuiBase.executeLater(GuiGrid.class, grid -> {
            grid.setView(new GridViewImpl((GuiGrid)grid, GuiGrid.getDefaultSorter(), GuiGrid.getSorters()));
            grid.getView().setCanCraft(message.canCraft);
            grid.getView().setStacks(message.stacks);
            grid.getView().sort();
        });
        return null;
    }
}

