/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageGridItemInventoryScroll
extends MessageHandlerPlayerToServer<MessageGridItemInventoryScroll>
implements IMessage {
    private int slot;
    private boolean up;

    public MessageGridItemInventoryScroll() {
    }

    public MessageGridItemInventoryScroll(int slot, boolean up) {
        this.slot = slot;
        this.up = up;
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.up = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        buf.writeBoolean(this.up);
    }

    @Override
    protected void handle(MessageGridItemInventoryScroll message, EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        Container container = player.field_71070_bA;
        if (!(container instanceof ContainerGrid)) {
            return;
        }
        IGrid grid = ((ContainerGrid)container).getGrid();
        if (grid.getItemHandler() == null) {
            return;
        }
        int flags = 6;
        ItemStack stackInSlot = player.field_71071_by.func_70301_a(message.slot);
        if (message.up) {
            player.field_71071_by.func_70299_a(message.slot, StackUtils.nullToEmpty(grid.getItemHandler().onInsert(player, stackInSlot, true)));
        } else {
            grid.getItemHandler().onExtract(player, stackInSlot, message.slot, flags);
        }
    }
}

