/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.StorageCacheItem;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageGridItemScroll
extends MessageHandlerPlayerToServer<MessageGridItemScroll>
implements IMessage {
    private UUID id;
    private boolean shift;
    private boolean up;

    public MessageGridItemScroll() {
    }

    public MessageGridItemScroll(UUID id, boolean shift, boolean up) {
        this.id = id;
        this.shift = shift;
        this.up = up;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.shift = buf.readBoolean();
        this.up = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.writeBoolean(this.shift);
        buf.writeBoolean(this.up);
    }

    @Override
    protected void handle(MessageGridItemScroll message, EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        Container container = player.field_71070_bA;
        if (!(container instanceof ContainerGrid)) {
            return;
        }
        IGrid grid = ((ContainerGrid)container).getGrid();
        if (grid.getItemHandler() == null) {
            return;
        }
        if (message.up && !message.shift) {
            grid.getItemHandler().onInsert(player, player.field_71071_by.func_70445_o(), true);
            player.func_71113_k();
            return;
        }
        if (message.up) {
            StorageCacheItem cache = (StorageCacheItem)grid.getStorageCache();
            if (cache == null) {
                return;
            }
            ItemStack entry = cache.getList().get((ItemStack)message.id);
            if (entry == null) {
                return;
            }
            ItemStack stack = (ItemStack)entry.getStack();
            stack.func_190920_e((int)entry.getCount());
            int slot = player.field_71071_by.func_70432_d(stack);
            if (slot != -1) {
                grid.getItemHandler().onInsert(player, player.field_71071_by.func_70301_a(slot), true);
            }
            return;
        }
        if (message.id.equals(new UUID(0L, 0L))) {
            return;
        }
        if (!message.shift) {
            grid.getItemHandler().onExtract(player, message.id, -1, 2);
            return;
        }
        grid.getItemHandler().onExtract(player, message.id, -1, 6);
    }
}

