/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilter;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageGridPatternSlotScroll
extends MessageHandlerPlayerToServer<MessageGridPatternSlotScroll>
implements IMessage {
    private int slot;
    private boolean up;

    public MessageGridPatternSlotScroll() {
    }

    public MessageGridPatternSlotScroll(int slot, boolean up) {
        this.slot = slot;
        this.up = up;
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.up = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        buf.writeBoolean(this.up);
    }

    @Override
    protected void handle(MessageGridPatternSlotScroll message, EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        Container container = player.field_71070_bA;
        if (!(container instanceof ContainerGrid)) {
            return;
        }
        IGrid grid = ((ContainerGrid)container).getGrid();
        if (grid.getItemHandler() == null) {
            return;
        }
        Slot slot = (Slot)container.field_75151_b.get(message.slot);
        if (grid.getGridType() != GridType.PATTERN || !(slot instanceof SlotFilter)) {
            return;
        }
        int newStackSize = MathHelper.func_76125_a((int)(slot.func_75211_c().func_190916_E() + (message.up ? 1 : -1)), (int)1, (int)slot.func_75211_c().func_77976_d());
        if (newStackSize != slot.func_75211_c().func_190916_E()) {
            slot.func_75211_c().func_190920_e(newStackSize);
            slot.func_75218_e();
        }
    }
}

