/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.gui.grid.view.GridViewImpl;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessagePortableGridFluidUpdate
implements IMessage,
IMessageHandler<MessagePortableGridFluidUpdate, IMessage> {
    private IPortableGrid portableGrid;
    private final List<IGridStack> stacks = new ArrayList<IGridStack>();

    public MessagePortableGridFluidUpdate(IPortableGrid portableGrid) {
        this.portableGrid = portableGrid;
    }

    public MessagePortableGridFluidUpdate() {
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.stacks.add(StackUtils.readFluidGridStack(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        int size = this.portableGrid.getFluidCache().getList().getStacks().size();
        buf.writeInt(size);
        for (StackListEntry<FluidStack> stack : this.portableGrid.getFluidCache().getList().getStacks()) {
            StackUtils.writeFluidGridStack(buf, stack.getStack(), stack.getCount(), stack.getId(), null, false, this.portableGrid.getFluidStorageTracker().get(stack.getStack()));
        }
    }

    public IMessage onMessage(MessagePortableGridFluidUpdate message, MessageContext ctx) {
        GuiBase.executeLater(GuiGrid.class, grid -> {
            grid.setView(new GridViewImpl((GuiGrid)grid, GuiGrid.getDefaultSorter(), GuiGrid.getSorters()));
            grid.getView().setStacks(message.stacks);
            grid.getView().sort();
        });
        return null;
    }
}

