/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilterFluid;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageSlotFilterFluidSetAmount
extends MessageHandlerPlayerToServer<MessageSlotFilterFluidSetAmount>
implements IMessage {
    private int containerSlot;
    private int amount;

    public MessageSlotFilterFluidSetAmount(int containerSlot, int amount) {
        this.containerSlot = containerSlot;
        this.amount = amount;
    }

    public MessageSlotFilterFluidSetAmount() {
    }

    @Override
    protected void handle(MessageSlotFilterFluidSetAmount message, EntityPlayerMP player) {
        Container container = player.field_71070_bA;
        if (container == null) {
            return;
        }
        if (message.containerSlot < 0 || message.containerSlot >= container.field_75151_b.size()) {
            return;
        }
        Slot slot = container.func_75139_a(message.containerSlot);
        if (!(slot instanceof SlotFilterFluid)) {
            return;
        }
        FluidInventory inventory = ((SlotFilterFluid)slot).getFluidInventory();
        FluidStack stack = inventory.getFluid(slot.getSlotIndex());
        if (stack != null && message.amount > 0 && message.amount <= inventory.getMaxAmount()) {
            inventory.setFluid(slot.getSlotIndex(), StackUtils.copy(stack, message.amount));
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.containerSlot = buf.readInt();
        this.amount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.containerSlot);
        buf.writeInt(this.amount);
    }
}

