/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilterFluid;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSlotFilterFluidUpdate
implements IMessage,
IMessageHandler<MessageSlotFilterFluidUpdate, IMessage> {
    private int containerSlot;
    private FluidStack stack;

    public MessageSlotFilterFluidUpdate(int containerSlot, FluidStack stack) {
        this.containerSlot = containerSlot;
        this.stack = stack;
    }

    public MessageSlotFilterFluidUpdate() {
    }

    public void fromBytes(ByteBuf buf) {
        this.containerSlot = buf.readInt();
        if (buf.readBoolean()) {
            this.stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.containerSlot);
        if (this.stack == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.stack.writeToNBT(new NBTTagCompound()));
        }
    }

    public IMessage onMessage(MessageSlotFilterFluidUpdate message, MessageContext ctx) {
        GuiBase.executeLater(gui -> {
            Slot slot;
            if (message.containerSlot >= 0 && message.containerSlot < gui.field_147002_h.field_75151_b.size() && (slot = gui.field_147002_h.func_75139_a(message.containerSlot)) instanceof SlotFilterFluid) {
                ((SlotFilterFluid)slot).getFluidInventory().setFluid(slot.getSlotIndex(), message.stack);
            }
        });
        return null;
    }
}

