/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilterFluid;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageSlotFilterSetFluid
extends MessageHandlerPlayerToServer<MessageSlotFilterSetFluid>
implements IMessage {
    private int containerSlot;
    private FluidStack stack;

    public MessageSlotFilterSetFluid(int containerSlot, FluidStack stack) {
        this.containerSlot = containerSlot;
        this.stack = stack;
    }

    public MessageSlotFilterSetFluid() {
    }

    @Override
    protected void handle(MessageSlotFilterSetFluid message, EntityPlayerMP player) {
        Container container = player.field_71070_bA;
        if (container == null) {
            return;
        }
        if (message.containerSlot < 0 || message.containerSlot >= container.field_75151_b.size()) {
            return;
        }
        Slot slot = container.func_75139_a(message.containerSlot);
        if (!(slot instanceof SlotFilterFluid)) {
            return;
        }
        ((SlotFilterFluid)slot).getFluidInventory().setFluid(slot.getSlotIndex(), message.stack);
    }

    public void fromBytes(ByteBuf buf) {
        this.containerSlot = buf.readInt();
        this.stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.containerSlot);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.stack.writeToNBT(new NBTTagCompound()));
    }
}

