/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model.baked;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.Cover;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.raoulvdberge.refinedstorage.block.BlockBase;
import com.raoulvdberge.refinedstorage.block.BlockCable;
import com.raoulvdberge.refinedstorage.render.CubeBuilder;
import com.raoulvdberge.refinedstorage.render.constants.ConstantsCable;
import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelDelegate;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.lwjgl.util.vector.Vector3f;

public class BakedModelCableCover
extends BakedModelDelegate {
    private static TextureAtlasSprite BORDER_SPRITE;

    public BakedModelCableCover(IBakedModel base) {
        super(base);
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.base.func_188616_a(state, side, rand));
        if (state != null) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            BakedModelCableCover.addCover(quads, (Cover)extendedState.getValue(BlockCable.COVER_NORTH), EnumFacing.NORTH, side, rand, extendedState, true);
            BakedModelCableCover.addCover(quads, (Cover)extendedState.getValue(BlockCable.COVER_SOUTH), EnumFacing.SOUTH, side, rand, extendedState, true);
            BakedModelCableCover.addCover(quads, (Cover)extendedState.getValue(BlockCable.COVER_EAST), EnumFacing.EAST, side, rand, extendedState, true);
            BakedModelCableCover.addCover(quads, (Cover)extendedState.getValue(BlockCable.COVER_WEST), EnumFacing.WEST, side, rand, extendedState, true);
            BakedModelCableCover.addCover(quads, (Cover)extendedState.getValue(BlockCable.COVER_DOWN), EnumFacing.DOWN, side, rand, extendedState, true);
            BakedModelCableCover.addCover(quads, (Cover)extendedState.getValue(BlockCable.COVER_UP), EnumFacing.UP, side, rand, extendedState, true);
        }
        return quads;
    }

    private static int getHollowCoverSize(@Nullable IBlockState state, EnumFacing coverSide) {
        if (state == null) {
            return 6;
        }
        BlockBase block = (BlockBase)state.func_177230_c();
        if (block.getDirection() != null && state.func_177229_b((IProperty)block.getDirection().getProperty()) == coverSide) {
            if (block == RSBlocks.CABLE || block == RSBlocks.EXPORTER) {
                return 6;
            }
            if (block == RSBlocks.EXTERNAL_STORAGE || block == RSBlocks.IMPORTER) {
                return 3;
            }
            if (block == RSBlocks.CONSTRUCTOR || block == RSBlocks.DESTRUCTOR || block == RSBlocks.READER || block == RSBlocks.WRITER) {
                return 2;
            }
        }
        return 6;
    }

    protected static void addCover(List<BakedQuad> quads, @Nullable Cover cover, EnumFacing coverSide, EnumFacing side, long rand, @Nullable IExtendedBlockState state, boolean handle) {
        if (cover == null) {
            return;
        }
        IBlockState coverState = CoverManager.getBlockState(cover.getStack());
        if (coverState == null) {
            return;
        }
        boolean hasUp = false;
        boolean hasDown = false;
        boolean hasEast = false;
        boolean hasWest = false;
        if (state != null) {
            hasUp = state.getValue(BlockCable.COVER_UP) != null;
            hasDown = state.getValue(BlockCable.COVER_DOWN) != null;
            hasEast = state.getValue(BlockCable.COVER_EAST) != null;
            hasWest = state.getValue(BlockCable.COVER_WEST) != null;
        }
        TextureAtlasSprite sprite = RenderUtils.getSprite(Minecraft.func_71410_x().func_175602_ab().func_184389_a(coverState), coverState, side, rand);
        if (cover.getType() == CoverType.NORMAL) {
            BakedModelCableCover.addNormalCover(quads, sprite, coverSide, hasUp, hasDown, hasEast, hasWest, handle);
        } else if (cover.getType() == CoverType.HOLLOW) {
            BakedModelCableCover.addHollowCover(quads, sprite, coverSide, hasUp, hasDown, hasEast, hasWest, BakedModelCableCover.getHollowCoverSize((IBlockState)state, coverSide));
        }
    }

    private static void addNormalCover(List<BakedQuad> quads, TextureAtlasSprite sprite, EnumFacing coverSide, boolean hasUp, boolean hasDown, boolean hasEast, boolean hasWest, boolean handle) {
        AxisAlignedBB bounds = ConstantsCable.getCoverBounds(coverSide);
        Vector3f from = new Vector3f((float)bounds.field_72340_a * 16.0f, (float)bounds.field_72338_b * 16.0f, (float)bounds.field_72339_c * 16.0f);
        Vector3f to = new Vector3f((float)bounds.field_72336_d * 16.0f, (float)bounds.field_72337_e * 16.0f, (float)bounds.field_72334_f * 16.0f);
        if (coverSide.func_176740_k() == EnumFacing.Axis.Z) {
            if (hasWest) {
                from.setX(2.0f);
            }
            if (hasEast) {
                to.setX(14.0f);
            }
        }
        if (coverSide.func_176740_k() != EnumFacing.Axis.Y) {
            if (hasDown) {
                from.setY(2.0f);
            }
            if (hasUp) {
                to.setY(14.0f);
            }
        }
        quads.addAll(new CubeBuilder().from(from.getX(), from.getY(), from.getZ()).to(to.getX(), to.getY(), to.getZ()).addFaces(face -> new CubeBuilder.Face((EnumFacing)face, sprite)).bake());
        if (handle) {
            if (BORDER_SPRITE == null) {
                BORDER_SPRITE = Minecraft.func_71410_x().func_147117_R().func_110572_b("refinedstorage:blocks/cable_part_border");
            }
            bounds = ConstantsCable.getHolderBounds(coverSide);
            from = new Vector3f((float)bounds.field_72340_a * 16.0f, (float)bounds.field_72338_b * 16.0f, (float)bounds.field_72339_c * 16.0f);
            to = new Vector3f((float)bounds.field_72336_d * 16.0f, (float)bounds.field_72337_e * 16.0f, (float)bounds.field_72334_f * 16.0f);
            quads.addAll(new CubeBuilder().from(from.getX(), from.getY(), from.getZ()).to(to.getX(), to.getY(), to.getZ()).addFaces(face -> new CubeBuilder.Face((EnumFacing)face, BORDER_SPRITE)).bake());
        }
    }

    private static void addHollowCover(List<BakedQuad> quads, TextureAtlasSprite sprite, EnumFacing coverSide, boolean hasUp, boolean hasDown, boolean hasEast, boolean hasWest, int size) {
        AxisAlignedBB bounds = ConstantsCable.getCoverBounds(coverSide);
        Vector3f from = new Vector3f((float)bounds.field_72340_a * 16.0f, (float)bounds.field_72338_b * 16.0f, (float)bounds.field_72339_c * 16.0f);
        Vector3f to = new Vector3f((float)bounds.field_72336_d * 16.0f, (float)bounds.field_72337_e * 16.0f, (float)bounds.field_72334_f * 16.0f);
        if (coverSide.func_176740_k() != EnumFacing.Axis.Y) {
            if (hasDown) {
                from.setY(2.0f);
            }
            if (hasUp) {
                to.setY(14.0f);
            }
        }
        if (coverSide == EnumFacing.NORTH) {
            if (hasWest) {
                from.setX(2.0f);
            } else {
                from.setX(0.0f);
            }
            to.setX((float)size);
        } else if (coverSide == EnumFacing.SOUTH) {
            if (hasEast) {
                to.setX(14.0f);
            } else {
                to.setX(16.0f);
            }
            from.setX(16.0f - (float)size);
        } else if (coverSide == EnumFacing.EAST) {
            from.setZ(0.0f);
            to.setZ((float)size);
        } else if (coverSide == EnumFacing.WEST || coverSide == EnumFacing.DOWN || coverSide == EnumFacing.UP) {
            from.setZ(16.0f - (float)size);
            to.setZ(16.0f);
        }
        quads.addAll(new CubeBuilder().from(from.getX(), from.getY(), from.getZ()).to(to.getX(), to.getY(), to.getZ()).addFaces(face -> new CubeBuilder.Face((EnumFacing)face, sprite)).bake());
        if (coverSide == EnumFacing.NORTH) {
            if (hasEast) {
                to.setX(14.0f);
            } else {
                to.setX(16.0f);
            }
            from.setX(16.0f - (float)size);
        } else if (coverSide == EnumFacing.SOUTH) {
            if (hasWest) {
                from.setX(2.0f);
            } else {
                from.setX(0.0f);
            }
            to.setX((float)size);
        } else if (coverSide == EnumFacing.EAST) {
            from.setZ(16.0f - (float)size);
            to.setZ(16.0f);
        } else if (coverSide == EnumFacing.WEST || coverSide == EnumFacing.DOWN || coverSide == EnumFacing.UP) {
            from.setZ(0.0f);
            to.setZ((float)size);
        }
        quads.addAll(new CubeBuilder().from(from.getX(), from.getY(), from.getZ()).to(to.getX(), to.getY(), to.getZ()).addFaces(face -> new CubeBuilder.Face((EnumFacing)face, sprite)).bake());
        if (coverSide.func_176740_k() == EnumFacing.Axis.Z) {
            from.setX((float)size);
            to.setX(16.0f - (float)size);
            if (hasDown) {
                from.setY(2.0f);
            } else {
                from.setY(0.0f);
            }
            to.setY((float)size);
        } else if (coverSide.func_176740_k() == EnumFacing.Axis.X) {
            from.setZ((float)size);
            to.setZ(16.0f - (float)size);
            if (hasDown) {
                from.setY(2.0f);
            } else {
                from.setY(0.0f);
            }
            to.setY((float)size);
        } else if (coverSide == EnumFacing.DOWN || coverSide == EnumFacing.UP) {
            from.setZ((float)size);
            to.setZ(16.0f - (float)size);
            from.setX(0.0f);
            to.setX((float)size);
        }
        quads.addAll(new CubeBuilder().from(from.getX(), from.getY(), from.getZ()).to(to.getX(), to.getY(), to.getZ()).addFaces(face -> new CubeBuilder.Face((EnumFacing)face, sprite)).bake());
        if (coverSide.func_176740_k() == EnumFacing.Axis.Z) {
            from.setX((float)size);
            to.setX(16.0f - (float)size);
            if (hasUp) {
                to.setY(14.0f);
            } else {
                to.setY(16.0f);
            }
            from.setY(16.0f - (float)size);
        } else if (coverSide.func_176740_k() == EnumFacing.Axis.X) {
            from.setZ((float)size);
            to.setZ(16.0f - (float)size);
            if (hasUp) {
                to.setY(14.0f);
            } else {
                to.setY(16.0f);
            }
            from.setY(16.0f - (float)size);
        } else if (coverSide == EnumFacing.DOWN || coverSide == EnumFacing.UP) {
            from.setZ((float)size);
            to.setZ(16.0f - (float)size);
            from.setX(16.0f - (float)size);
            to.setX(16.0f);
        }
        quads.addAll(new CubeBuilder().from(from.getX(), from.getY(), from.getZ()).to(to.getX(), to.getY(), to.getZ()).addFaces(face -> new CubeBuilder.Face((EnumFacing)face, sprite)).bake());
    }
}

