/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model.baked;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.Cover;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.raoulvdberge.refinedstorage.item.ItemCover;
import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelCableCover;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelCover
extends BakedModelCableCover {
    private static final LoadingCache<CacheKey, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(@Nonnull CacheKey key) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            BakedModelCableCover.addCover(quads, new Cover(key.stack, key.type), EnumFacing.NORTH, key.side, 0L, null, false);
            return quads;
        }
    });
    @Nullable
    private final ItemStack stack;
    private final CoverType type;

    public BakedModelCover(@Nullable ItemStack stack, CoverType type) {
        super(null);
        this.stack = stack;
        this.type = type;
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (this.stack == null) {
            return Collections.emptyList();
        }
        CacheKey key = new CacheKey(state, ItemCover.getItem(this.stack), side, this.type);
        return (List)CACHE.getUnchecked((Object)key);
    }

    @Override
    @Nonnull
    public ItemOverrideList func_188617_f() {
        if (this.stack != null) {
            return ItemOverrideList.field_188022_a;
        }
        return new ItemOverrideList(Collections.emptyList()){

            @Nonnull
            public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return new BakedModelCover(stack, BakedModelCover.this.type);
            }
        };
    }

    @Override
    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = (TRSRTransformation)RenderUtils.getDefaultBlockTransforms().get((Object)cameraTransformType);
        return Pair.of((Object)this, (Object)(transform == null ? RenderUtils.EMPTY_MATRIX_TRANSFORM : transform.getMatrix()));
    }

    @Override
    public boolean func_177555_b() {
        return true;
    }

    @Override
    public boolean func_177556_c() {
        return true;
    }

    @Override
    public boolean func_188618_c() {
        return false;
    }

    @Override
    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    @Override
    public boolean isAmbientOcclusion(@Nonnull IBlockState state) {
        return true;
    }

    @Override
    @Nonnull
    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    private static class CacheKey {
        private final IBlockState state;
        private final ItemStack stack;
        private final EnumFacing side;
        private final CoverType type;

        CacheKey(IBlockState state, ItemStack stack, EnumFacing side, CoverType type) {
            this.state = state;
            this.stack = stack;
            this.side = side;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return cacheKey.type == this.type && cacheKey.stack.func_77973_b() == this.stack.func_77973_b() && cacheKey.stack.func_77952_i() == this.stack.func_77952_i() && cacheKey.side == this.side && Objects.equals(cacheKey.state, this.state);
        }

        public int hashCode() {
            int result = this.stack.func_77973_b().hashCode();
            result = 31 * result + this.stack.func_77952_i();
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

