/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model.baked;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelDelegate;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.common.property.IExtendedBlockState;

public class BakedModelFullbright
extends BakedModelDelegate {
    private static final LoadingCache<CacheKey, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(@Nonnull CacheKey key) {
            return BakedModelFullbright.transformQuads(key.base.func_188616_a(key.state, key.side, 0L), key.textures);
        }
    });
    private final Set<String> textures;
    private boolean cacheDisabled = false;

    public BakedModelFullbright(IBakedModel base, String ... textures) {
        super(base);
        this.textures = new HashSet<String>(Arrays.asList(textures));
    }

    public BakedModelFullbright setCacheDisabled() {
        this.cacheDisabled = true;
        return this;
    }

    public static void invalidateCache() {
        CACHE.invalidateAll();
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null) {
            return this.base.func_188616_a(null, side, rand);
        }
        if (this.cacheDisabled) {
            return BakedModelFullbright.transformQuads(this.base.func_188616_a(state, side, 0L), this.textures);
        }
        return (List)CACHE.getUnchecked((Object)new CacheKey(this.base, this.textures, state instanceof IExtendedBlockState ? ((IExtendedBlockState)state).getClean() : state, side));
    }

    private static List<BakedQuad> transformQuads(List<BakedQuad> oldQuads, Set<String> textures) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(oldQuads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            if (!textures.contains(quad.func_187508_a().func_94215_i())) continue;
            quads.set(i, BakedModelFullbright.transformQuad(quad, 0.007f));
        }
        return quads;
    }

    private static BakedQuad transformQuad(BakedQuad quad, final float light) {
        if (RenderUtils.isLightMapDisabled()) {
            return quad;
        }
        VertexFormat newFormat = RenderUtils.getFormatWithLightMap(quad.getFormat());
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(newFormat);
        VertexLighterFlat trans = new VertexLighterFlat(Minecraft.func_71410_x().func_184125_al()){

            protected void updateLightmap(@Nonnull float[] normal, float[] lightmap, float x, float y, float z) {
                lightmap[0] = light;
                lightmap[1] = light;
            }

            public void setQuadTint(int tint) {
            }
        };
        trans.setParent((IVertexConsumer)builder);
        quad.pipe((IVertexConsumer)trans);
        builder.setQuadTint(quad.func_178211_c());
        builder.setQuadOrientation(quad.func_178210_d());
        builder.setTexture(quad.func_187508_a());
        builder.setApplyDiffuseLighting(false);
        return builder.build();
    }

    private static class CacheKey {
        private final IBakedModel base;
        private final Set<String> textures;
        private final IBlockState state;
        private final EnumFacing side;

        public CacheKey(IBakedModel base, Set<String> textures, IBlockState state, EnumFacing side) {
            this.base = base;
            this.textures = textures;
            this.state = state;
            this.side = side;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (cacheKey.side != this.side) {
                return false;
            }
            return this.state.equals(cacheKey.state);
        }

        public int hashCode() {
            return this.state.hashCode() + 31 * (this.side != null ? this.side.hashCode() : 0);
        }
    }
}

