/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model.baked;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternRenderHandler;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelDelegate;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelPattern
extends BakedModelDelegate {
    public BakedModelPattern(IBakedModel base) {
        super(base);
    }

    @Override
    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = (TRSRTransformation)RenderUtils.getDefaultItemTransforms().get((Object)cameraTransformType);
        return Pair.of((Object)this, (Object)(transform == null ? RenderUtils.EMPTY_MATRIX_TRANSFORM : transform.getMatrix()));
    }

    @Override
    @Nonnull
    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList((List)this.base.func_188617_f().getOverrides()){

            @Nonnull
            public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
                CraftingPattern pattern = ItemPattern.getPatternFromCache(world, stack);
                if (BakedModelPattern.canDisplayOutput(stack, pattern)) {
                    ItemStack outputToRender = (ItemStack)pattern.getOutputs().get(0);
                    return Minecraft.func_71410_x().func_175599_af().func_184393_a(outputToRender, world, entity);
                }
                return super.handleItemState(originalModel, stack, world, entity);
            }
        };
    }

    public static boolean canDisplayOutput(ItemStack patternStack, CraftingPattern pattern) {
        if (pattern.isValid() && pattern.getOutputs().size() == 1) {
            for (ICraftingPatternRenderHandler renderHandler : API.instance().getPatternRenderHandlers()) {
                if (!renderHandler.canRenderOutput(patternStack)) continue;
                return true;
            }
        }
        return false;
    }
}

