/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.google.common.base.Preconditions;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.energy.IEnergy;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeGraph;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterListener;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterManager;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityManager;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IStorageExternal;
import com.raoulvdberge.refinedstorage.api.storage.tracker.IStorageTracker;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingManager;
import com.raoulvdberge.refinedstorage.apiimpl.energy.Energy;
import com.raoulvdberge.refinedstorage.apiimpl.network.NetworkNodeGraph;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler.FluidGridHandler;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler.ItemGridHandler;
import com.raoulvdberge.refinedstorage.apiimpl.network.item.NetworkItemHandler;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.readerwriter.ReaderWriterManager;
import com.raoulvdberge.refinedstorage.apiimpl.network.security.SecurityManager;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.StorageCacheFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.StorageCacheItem;
import com.raoulvdberge.refinedstorage.apiimpl.storage.tracker.StorageTrackerFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.tracker.StorageTrackerItem;
import com.raoulvdberge.refinedstorage.block.BlockController;
import com.raoulvdberge.refinedstorage.block.enums.ControllerEnergyType;
import com.raoulvdberge.refinedstorage.block.enums.ControllerType;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import com.raoulvdberge.refinedstorage.integration.forgeenergy.EnergyProxy;
import com.raoulvdberge.refinedstorage.tile.ClientNode;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.config.IRedstoneConfigurable;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.tile.data.RSSerializers;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;

public class TileController
extends TileBase
implements ITickable,
INetwork,
IRedstoneConfigurable,
INetworkNode,
INetworkNodeProxy<TileController>,
INetworkNodeVisitor {
    private static final Comparator<ClientNode> CLIENT_NODE_COMPARATOR = (left, right) -> {
        if (left.getEnergyUsage() == right.getEnergyUsage()) {
            return 0;
        }
        return left.getEnergyUsage() > right.getEnergyUsage() ? -1 : 1;
    };
    public static final TileDataParameter<Integer, TileController> REDSTONE_MODE = RedstoneMode.createParameter();
    public static final TileDataParameter<Integer, TileController> ENERGY_USAGE = new TileDataParameter<Integer, TileController>(DataSerializers.field_187192_b, 0, TileController::getEnergyUsage);
    public static final TileDataParameter<Integer, TileController> ENERGY_STORED = new TileDataParameter<Integer, TileController>(DataSerializers.field_187192_b, 0, t -> t.getEnergy().getStored());
    public static final TileDataParameter<Integer, TileController> ENERGY_CAPACITY = new TileDataParameter<Integer, TileController>(DataSerializers.field_187192_b, 0, t -> t.getEnergy().getCapacity());
    public static final TileDataParameter<List<ClientNode>, TileController> NODES = new TileDataParameter<List, TileController>(RSSerializers.CLIENT_NODE_SERIALIZER, new ArrayList(), t -> {
        ArrayList<ClientNode> nodes = new ArrayList<ClientNode>();
        for (INetworkNode node : t.nodeGraph.allActualNodes()) {
            ItemStack stack;
            if (!node.canUpdate() || (stack = node.getItemStack()).func_190926_b()) continue;
            ClientNode clientNode = new ClientNode(stack, 1, node.getEnergyUsage());
            if (nodes.contains(clientNode)) {
                ClientNode other = (ClientNode)nodes.get(nodes.indexOf(clientNode));
                other.setAmount(other.getAmount() + 1);
                continue;
            }
            nodes.add(clientNode);
        }
        nodes.sort(CLIENT_NODE_COMPARATOR);
        return nodes;
    });
    private static final int THROTTLE_INACTIVE_TO_ACTIVE = 20;
    private static final int THROTTLE_ACTIVE_TO_INACTIVE = 4;
    public static final String NBT_ENERGY = "Energy";
    public static final String NBT_ENERGY_TYPE = "EnergyType";
    private static final String NBT_ITEM_STORAGE_TRACKER = "ItemStorageTracker";
    private static final String NBT_FLUID_STORAGE_TRACKER = "FluidStorageTracker";
    private final IItemGridHandler itemGridHandler = new ItemGridHandler(this);
    private final IFluidGridHandler fluidGridHandler = new FluidGridHandler(this);
    private final INetworkItemHandler networkItemHandler = new NetworkItemHandler(this);
    private final INetworkNodeGraph nodeGraph = new NetworkNodeGraph(this);
    private final ICraftingManager craftingManager = new CraftingManager(this);
    private final ISecurityManager securityManager = new SecurityManager(this);
    private final IStorageCache<ItemStack> itemStorage = new StorageCacheItem(this);
    private final StorageTrackerItem itemStorageTracker = new StorageTrackerItem(this::markNetworkNodeDirty);
    private final IStorageCache<FluidStack> fluidStorage = new StorageCacheFluid(this);
    private final StorageTrackerFluid fluidStorageTracker = new StorageTrackerFluid(this::markNetworkNodeDirty);
    private final IReaderWriterManager readerWriterManager = new ReaderWriterManager(this);
    private final IEnergy energy;
    private final EnergyProxy energyProxy;
    private boolean throttlingDisabled;
    private boolean couldRun;
    private int ticksSinceUpdateChanged;
    private int lastEnergyUsage;
    private ControllerType type;
    private ControllerEnergyType energyType;
    private RedstoneMode redstoneMode;
    private boolean redstoneModeEnabled;

    public TileController() {
        this.energy = new Energy(RS.INSTANCE.config.controllerCapacity);
        this.energyProxy = new EnergyProxy(this.energy, RS.INSTANCE.config.controllerMaxReceive, 0);
        this.throttlingDisabled = true;
        this.energyType = ControllerEnergyType.OFF;
        this.redstoneMode = RedstoneMode.IGNORE;
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
        this.dataManager.addWatchedParameter(ENERGY_USAGE);
        this.dataManager.addWatchedParameter(ENERGY_STORED);
        this.dataManager.addParameter(ENERGY_CAPACITY);
        this.dataManager.addParameter(NODES);
        this.readerWriterManager.addListener(new IReaderWriterListener(){

            @Override
            public void onAttached() {
            }

            @Override
            public void onChanged() {
                TileController.this.markNetworkNodeDirty();
            }
        });
        this.nodeGraph.addListener(() -> this.dataManager.sendParameterToWatchers(NODES));
    }

    @Override
    public void updateNetworkNode() {
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ControllerEnergyType energyType;
            this.updateEnergyUsage();
            this.updateRedstoneMode();
            boolean canRun = this.canRun();
            if (canRun) {
                this.craftingManager.update();
                this.readerWriterManager.update();
                if (!this.craftingManager.getTasks().isEmpty()) {
                    this.markNetworkNodeDirty();
                }
            }
            if (this.getType() == ControllerType.NORMAL) {
                int energyUsage = this.getEnergyUsage();
                if (!RS.INSTANCE.config.controllerUsesEnergy) {
                    this.energy.setStored(this.energy.getCapacity());
                } else if (this.energy.extract(energyUsage, Action.SIMULATE) == energyUsage) {
                    this.energy.extract(energyUsage, Action.PERFORM);
                }
            } else if (this.getType() == ControllerType.CREATIVE) {
                this.energy.setStored(this.energy.getCapacity());
            }
            if (this.couldRun != canRun) {
                ++this.ticksSinceUpdateChanged;
                if ((!canRun ? this.ticksSinceUpdateChanged > 4 : this.ticksSinceUpdateChanged > 20) || this.throttlingDisabled) {
                    this.ticksSinceUpdateChanged = 0;
                    this.couldRun = canRun;
                    this.throttlingDisabled = false;
                    this.nodeGraph.invalidate(Action.PERFORM, this.field_145850_b, this.field_174879_c);
                    this.securityManager.invalidate();
                }
            } else {
                this.ticksSinceUpdateChanged = 0;
            }
            if (this.energyType != (energyType = this.getEnergyType())) {
                this.energyType = energyType;
                WorldUtils.updateBlock(this.field_145850_b, this.field_174879_c);
            }
        }
    }

    @Override
    public boolean canRun() {
        return this.energy.getStored() >= this.getEnergyUsage() && this.redstoneModeEnabled;
    }

    @Override
    @Nullable
    public synchronized StackListResult<ItemStack> insertItem(@Nonnull ItemStack stack, long size, Action action) {
        if (size < 1L || this.itemStorage.getStorages().isEmpty()) {
            return new StackListResult<ItemStack>(stack.func_77946_l(), size);
        }
        StackListResult<ItemStack> remainder = null;
        long inserted = 0L;
        long insertedExternally = 0L;
        for (IStorage<ItemStack> storage : this.itemStorage.getStorages()) {
            if (storage.getAccessType() == AccessType.EXTRACT) continue;
            long storedPre = storage.getStored();
            remainder = storage.insert(stack, size, action);
            if (action == Action.PERFORM) {
                inserted += storage.getCacheDelta(storedPre, size, remainder == null ? 0L : remainder.getCount());
            }
            if (remainder == null) {
                if (!(storage instanceof IStorageExternal) || action != Action.PERFORM) break;
                ((IStorageExternal)storage).update(this);
                insertedExternally += size;
                break;
            }
            if (size != remainder.getCount() && storage instanceof IStorageExternal && action == Action.PERFORM) {
                ((IStorageExternal)storage).update(this);
                insertedExternally += size - remainder.getCount();
            }
            size = remainder.getCount();
        }
        if (action == Action.PERFORM && inserted - insertedExternally > 0L) {
            this.itemStorage.add(stack, inserted - insertedExternally, false);
        }
        return remainder;
    }

    @Override
    @Nullable
    public synchronized StackListResult<ItemStack> extractItem(@Nonnull ItemStack stack, long size, int flags, Action action, Predicate<IStorage<ItemStack>> filter) {
        long received = 0L;
        long extractedExternally = 0L;
        StackListResult newStack = null;
        for (IStorage<ItemStack> storage : this.itemStorage.getStorages()) {
            StackListResult<ItemStack> took = null;
            if (filter.test(storage) && storage.getAccessType() != AccessType.INSERT) {
                took = storage.extract(stack, size - received, flags, action);
            }
            if (took != null) {
                if (storage instanceof IStorageExternal && action == Action.PERFORM) {
                    ((IStorageExternal)storage).update(this);
                    extractedExternally += took.getCount();
                }
                if (newStack == null) {
                    newStack = took;
                } else {
                    newStack.grow(took.getCount());
                }
                received += took.getCount();
            }
            if (size != received) continue;
            break;
        }
        if (newStack != null && newStack.getCount() - extractedExternally > 0L && action == Action.PERFORM) {
            this.itemStorage.remove((ItemStack)newStack.getStack(), newStack.getCount() - extractedExternally, false);
        }
        return newStack;
    }

    @Override
    @Nullable
    public synchronized StackListResult<FluidStack> insertFluid(@Nonnull FluidStack stack, long size, Action action) {
        if (size < 1L || this.fluidStorage.getStorages().isEmpty()) {
            return new StackListResult<FluidStack>(StackUtils.copy(stack, 0), size);
        }
        StackListResult<FluidStack> remainder = null;
        long inserted = 0L;
        long insertedExternally = 0L;
        for (IStorage<FluidStack> storage : this.fluidStorage.getStorages()) {
            if (storage.getAccessType() == AccessType.EXTRACT) continue;
            long storedPre = storage.getStored();
            remainder = storage.insert(stack, size, action);
            if (action == Action.PERFORM) {
                inserted += storage.getCacheDelta(storedPre, size, remainder == null ? 0L : remainder.getCount());
            }
            if (remainder == null) {
                if (!(storage instanceof IStorageExternal) || action != Action.PERFORM) break;
                ((IStorageExternal)storage).update(this);
                insertedExternally += size;
                break;
            }
            if (size != remainder.getCount() && storage instanceof IStorageExternal && action == Action.PERFORM) {
                ((IStorageExternal)storage).update(this);
                insertedExternally += size - remainder.getCount();
            }
            size = remainder.getCount();
        }
        if (action == Action.PERFORM && inserted - insertedExternally > 0L) {
            this.fluidStorage.add(stack, inserted - insertedExternally, false);
        }
        return remainder;
    }

    @Override
    public synchronized StackListResult<FluidStack> extractFluid(@Nonnull FluidStack stack, long size, int flags, Action action, Predicate<IStorage<FluidStack>> filter) {
        long received = 0L;
        long extractedExternally = 0L;
        StackListResult newStack = null;
        for (IStorage<FluidStack> storage : this.fluidStorage.getStorages()) {
            StackListResult<FluidStack> took = null;
            if (filter.test(storage) && storage.getAccessType() != AccessType.INSERT) {
                took = storage.extract(stack, size - received, flags, action);
            }
            if (took != null) {
                if (storage instanceof IStorageExternal && action == Action.PERFORM) {
                    ((IStorageExternal)storage).update(this);
                    extractedExternally += took.getCount();
                }
                if (newStack == null) {
                    newStack = took;
                } else {
                    newStack.grow(took.getCount());
                }
                received += took.getCount();
            }
            if (size != received) continue;
            break;
        }
        if (newStack != null && newStack.getCount() - extractedExternally > 0L && action == Action.PERFORM) {
            this.fluidStorage.remove((FluidStack)newStack.getStack(), newStack.getCount() - extractedExternally, false);
        }
        return newStack;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_ENERGY)) {
            this.energy.setStored(tag.func_74762_e(NBT_ENERGY));
        }
        this.redstoneMode = RedstoneMode.read(tag);
        this.craftingManager.readFromNbt(tag);
        this.readerWriterManager.readFromNbt(tag);
        if (tag.func_74764_b(NBT_ITEM_STORAGE_TRACKER)) {
            this.itemStorageTracker.readFromNbt(tag.func_150295_c(NBT_ITEM_STORAGE_TRACKER, 10));
        }
        if (tag.func_74764_b(NBT_FLUID_STORAGE_TRACKER)) {
            this.fluidStorageTracker.readFromNbt(tag.func_150295_c(NBT_FLUID_STORAGE_TRACKER, 10));
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a(NBT_ENERGY, this.energy.getStored());
        this.redstoneMode.write(tag);
        this.craftingManager.writeToNbt(tag);
        this.readerWriterManager.writeToNbt(tag);
        tag.func_74782_a(NBT_ITEM_STORAGE_TRACKER, (NBTBase)this.itemStorageTracker.serializeNbt());
        tag.func_74782_a(NBT_FLUID_STORAGE_TRACKER, (NBTBase)this.fluidStorageTracker.serializeNbt());
        return tag;
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74768_a(NBT_ENERGY_TYPE, this.getEnergyType().getId());
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        if (tag.func_74764_b(NBT_ENERGY_TYPE)) {
            this.energyType = ControllerEnergyType.getById(tag.func_74762_e(NBT_ENERGY_TYPE));
        }
        super.readUpdate(tag);
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            INetworkNodeProxy otherNodeProxy;
            Object otherNode;
            BlockPos pos = this.field_174879_c.func_177972_a(facing);
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            if (tile != null && tile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing.func_176734_d()) && (otherNode = (otherNodeProxy = (INetworkNodeProxy)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast(tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing.func_176734_d()))).getNode()) instanceof ICoverable && ((ICoverable)otherNode).getCoverManager().hasCover(facing.func_176734_d())) continue;
            operator.apply(this.field_145850_b, pos, facing.func_176734_d());
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            for (ICraftingTask task : this.craftingManager.getTasks()) {
                task.onCancelled();
            }
            this.nodeGraph.disconnectAll();
        }
    }

    @Override
    public void onConnected(INetwork network) {
        Preconditions.checkArgument((this == network ? 1 : 0) != 0, (Object)"Should not be connected to another controller");
    }

    @Override
    public void onDisconnected(INetwork network) {
        Preconditions.checkArgument((this == network ? 1 : 0) != 0, (Object)"Should not be connected to another controller");
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.markNetworkNodeDirty();
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyProxy);
        }
        if (capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY) {
            return (T)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    @Nonnull
    public World world() {
        return this.field_145850_b;
    }

    @Override
    @Nonnull
    public World getNetworkNodeWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getNetworkNodePos() {
        return this.field_174879_c;
    }

    public static int getEnergyScaled(int stored, int capacity, int scale) {
        return (int)((float)stored / (float)capacity * (float)scale);
    }

    public static ControllerEnergyType getEnergyType(int stored, int capacity) {
        int energy = TileController.getEnergyScaled(stored, capacity, 100);
        if (energy <= 0) {
            return ControllerEnergyType.OFF;
        }
        if (energy <= 10) {
            return ControllerEnergyType.NEARLY_OFF;
        }
        if (energy <= 20) {
            return ControllerEnergyType.NEARLY_ON;
        }
        return ControllerEnergyType.ON;
    }

    public ControllerEnergyType getEnergyType() {
        if (this.field_145850_b.field_72995_K) {
            return this.energyType;
        }
        if (!this.redstoneMode.isEnabled(this.field_145850_b, this.field_174879_c)) {
            return ControllerEnergyType.OFF;
        }
        return TileController.getEnergyType(this.energy.getStored(), this.energy.getCapacity());
    }

    @Override
    public IEnergy getEnergy() {
        return this.energy;
    }

    private void updateEnergyUsage() {
        if (!this.redstoneModeEnabled || this.type == ControllerType.CREATIVE) {
            this.lastEnergyUsage = 0;
            return;
        }
        int usage = RS.INSTANCE.config.controllerBaseUsage;
        for (INetworkNode node : this.nodeGraph.all()) {
            if (!node.isEnabled()) continue;
            usage += node.getEnergyUsage();
        }
        this.lastEnergyUsage = usage;
    }

    private void updateRedstoneMode() {
        this.redstoneModeEnabled = this.redstoneMode.isEnabled(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public int getEnergyUsage() {
        return this.lastEnergyUsage;
    }

    @Override
    public INetworkNodeGraph getNodeGraph() {
        return this.nodeGraph;
    }

    @Override
    public IStorageCache<FluidStack> getFluidStorageCache() {
        return this.fluidStorage;
    }

    @Override
    public IStorageCache<ItemStack> getItemStorageCache() {
        return this.itemStorage;
    }

    @Override
    public IReaderWriterManager getReaderWriterManager() {
        return this.readerWriterManager;
    }

    @Override
    public ICraftingManager getCraftingManager() {
        return this.craftingManager;
    }

    @Override
    public ISecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public INetworkItemHandler getNetworkItemHandler() {
        return this.networkItemHandler;
    }

    @Override
    public IItemGridHandler getItemGridHandler() {
        return this.itemGridHandler;
    }

    @Override
    public IFluidGridHandler getFluidGridHandler() {
        return this.fluidGridHandler;
    }

    @Override
    public IStorageTracker<ItemStack> getItemStorageTracker() {
        return this.itemStorageTracker;
    }

    @Override
    public IStorageTracker<FluidStack> getFluidStorageTracker() {
        return this.fluidStorageTracker;
    }

    @Override
    @Nonnull
    public TileController getNode() {
        return this;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        return new ItemStack(item, 1, state.func_177230_c().func_176201_c(state));
    }

    @Override
    public INetwork getNetwork() {
        return this;
    }

    @Override
    public String getId() {
        return null;
    }

    public ControllerType getType() {
        IBlockState state;
        if (this.type == null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == RSBlocks.CONTROLLER) {
            this.type = (ControllerType)((Object)state.func_177229_b(BlockController.TYPE));
        }
        return this.type == null ? ControllerType.NORMAL : this.type;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TileController)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        TileController otherController = (TileController)o;
        if (this.field_145850_b.field_73011_w.getDimension() != otherController.field_145850_b.field_73011_w.getDimension()) {
            return false;
        }
        return this.field_174879_c.equals((Object)otherController.field_174879_c);
    }

    public int hashCode() {
        int result = this.field_174879_c.hashCode();
        result = 31 * result + this.field_145850_b.field_73011_w.getDimension();
        return result;
    }
}

