/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IStorageExternal;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeExternalStorage;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.data.RSSerializers;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileExternalStorage
extends TileNode<NetworkNodeExternalStorage> {
    public static final TileDataParameter<Integer, TileExternalStorage> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer, TileExternalStorage> COMPARE = FilterConfig.createCompareParameter();
    public static final TileDataParameter<Integer, TileExternalStorage> MODE = FilterConfig.createFilterModeParameter();
    public static final TileDataParameter<Integer, TileExternalStorage> TYPE = FilterConfig.createFilterTypeParameter();
    public static final TileDataParameter<AccessType, TileExternalStorage> ACCESS_TYPE = IAccessType.createParameter();
    public static final TileDataParameter<Long, TileExternalStorage> STORED = new TileDataParameter<Long, TileExternalStorage>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long stored = 0L;
        for (IStorageExternal<ItemStack> iStorageExternal : ((NetworkNodeExternalStorage)t.getNode()).getItemStorages()) {
            stored += iStorageExternal.getStored();
        }
        for (IStorageExternal<ItemStack> iStorageExternal : ((NetworkNodeExternalStorage)t.getNode()).getFluidStorages()) {
            stored += iStorageExternal.getStored();
        }
        return stored;
    });
    public static final TileDataParameter<Long, TileExternalStorage> CAPACITY = new TileDataParameter<Long, TileExternalStorage>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long capacity = 0L;
        for (IStorageExternal<ItemStack> iStorageExternal : ((NetworkNodeExternalStorage)t.getNode()).getItemStorages()) {
            capacity += iStorageExternal.getCapacity();
        }
        for (IStorageExternal<ItemStack> iStorageExternal : ((NetworkNodeExternalStorage)t.getNode()).getFluidStorages()) {
            capacity += iStorageExternal.getCapacity();
        }
        return capacity;
    });

    public TileExternalStorage() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(CAPACITY);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
    }

    @Override
    @Nonnull
    public NetworkNodeExternalStorage createNode(World world, BlockPos pos) {
        return new NetworkNodeExternalStorage(world, pos);
    }

    @Override
    public String getNodeId() {
        return "external_storage";
    }
}

