/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.config.IRedstoneConfigurable;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.tile.direction.DirectionHandlerNetworkNode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public abstract class TileNode<N extends NetworkNode>
extends TileBase
implements INetworkNodeProxy<N>,
IRedstoneConfigurable {
    public static final TileDataParameter<Integer, TileNode<?>> REDSTONE_MODE = RedstoneMode.createParameter();
    protected static final String NBT_ACTIVE = "Active";
    private static final String NBT_COVERS = "Cover";
    private N clientNode;
    private EnumFacing directionToMigrate;

    public TileNode() {
        this.directionHandler = new DirectionHandlerNetworkNode(this);
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return ((NetworkNode)this.getNode()).getRedstoneMode();
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        ((NetworkNode)this.getNode()).setRedstoneMode(mode);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        if (this.getNode() instanceof ICoverable) {
            tag.func_74782_a(NBT_COVERS, (NBTBase)((ICoverable)((Object)this.getNode())).getCoverManager().writeToNbt());
        }
        tag.func_74757_a(NBT_ACTIVE, ((NetworkNode)this.getNode()).canUpdate());
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        if (this.getNode() instanceof ICoverable && tag.func_74764_b(NBT_COVERS)) {
            ((ICoverable)((Object)this.getNode())).getCoverManager().readFromNbt(tag.func_150295_c(NBT_COVERS, 10));
        }
        ((NetworkNode)this.getNode()).setActive(tag.func_74767_n(NBT_ACTIVE));
    }

    @Override
    @Nullable
    public IItemHandler getDrops() {
        return ((NetworkNode)this.getNode()).getDrops();
    }

    @Override
    @Nonnull
    public N getNode() {
        if (this.field_145850_b.field_72995_K) {
            if (this.clientNode == null) {
                this.clientNode = this.createNode(this.field_145850_b, this.field_174879_c);
            }
            return this.clientNode;
        }
        INetworkNodeManager manager = API.instance().getNetworkNodeManager(this.field_145850_b);
        INetworkNode node = manager.getNode(this.field_174879_c);
        if (node == null || !node.getId().equals(this.getNodeId())) {
            node = this.createNode(this.field_145850_b, this.field_174879_c);
            manager.setNode(this.field_174879_c, node);
            manager.markForSaving();
        }
        return (N)((NetworkNode)node);
    }

    public abstract N createNode(World var1, BlockPos var2);

    public abstract String getNodeId();

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY) {
            return (T)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }
}

