/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.grid.portable;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridCraftingListener;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.StorageType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler.FluidGridHandlerPortable;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler.ItemGridHandlerPortable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.NetworkNodeDiskDrive;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.StorageCacheFluidPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.StorageCacheItemPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.listener.StorageCacheListenerGridPortableFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.listener.StorageCacheListenerGridPortableItem;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskFluidPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskItemPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.tracker.StorageTrackerFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.tracker.StorageTrackerItem;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerFilter;
import com.raoulvdberge.refinedstorage.item.ItemWirelessGrid;
import com.raoulvdberge.refinedstorage.network.MessageGridSettingsUpdate;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PortableGrid
implements IGrid,
IPortableGrid,
IStorageDiskContainerContext {
    public static int ID;
    static final String NBT_STORAGE_TRACKER = "StorageTracker";
    static final String NBT_FLUID_STORAGE_TRACKER = "FluidStorageTracker";
    @Nullable
    private IStorageDisk<?> storage;
    @Nullable
    private IStorageCache<?> cache;
    private final ItemGridHandlerPortable itemHandler = new ItemGridHandlerPortable(this, this);
    private final FluidGridHandlerPortable fluidHandler = new FluidGridHandlerPortable(this);
    private final EntityPlayer player;
    private ItemStack stack;
    private final int slotId;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private int tabSelected;
    private int tabPage;
    private int size;
    private final StorageTrackerItem storageTracker = new StorageTrackerItem(() -> this.stack.func_77978_p().func_74782_a(NBT_STORAGE_TRACKER, (NBTBase)this.getItemStorageTracker().serializeNbt()));
    private final StorageTrackerFluid fluidStorageTracker = new StorageTrackerFluid(() -> this.stack.func_77978_p().func_74782_a(NBT_FLUID_STORAGE_TRACKER, (NBTBase)this.getFluidStorageTracker().serializeNbt()));
    private final List<IFilter<?>> filters = new ArrayList();
    private final List<IGridTab> tabs = new ArrayList<IGridTab>();
    private final ItemHandlerFilter filter = new ItemHandlerFilter(this.filters, this.tabs, null){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!PortableGrid.this.stack.func_77942_o()) {
                PortableGrid.this.stack.func_77982_d(new NBTTagCompound());
            }
            StackUtils.writeItems((IItemHandler)this, 0, PortableGrid.this.stack.func_77978_p());
        }
    };
    private final ItemHandlerBase disk = new ItemHandlerBase(1, new Predicate[]{NetworkNodeDiskDrive.VALIDATOR_STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                ItemStack diskStack = this.getStackInSlot(slot);
                if (diskStack.func_190926_b()) {
                    PortableGrid.this.storage = null;
                    PortableGrid.this.cache = null;
                } else {
                    IStorageDisk<ItemStack> disk = API.instance().getStorageDiskManager(PortableGrid.this.player.func_130014_f_()).getByStack(PortableGrid.this.getDisk().getStackInSlot(0));
                    if (disk != null) {
                        StorageType type = ((IStorageDiskProvider)PortableGrid.this.getDisk().getStackInSlot(0).func_77973_b()).getType();
                        if (type == StorageType.ITEM) {
                            PortableGrid.this.storage = new StorageDiskItemPortable(disk, PortableGrid.this);
                            PortableGrid.this.cache = new StorageCacheItemPortable(PortableGrid.this);
                        } else if (type == StorageType.FLUID) {
                            PortableGrid.this.storage = new StorageDiskFluidPortable(disk, PortableGrid.this);
                            PortableGrid.this.cache = new StorageCacheFluidPortable(PortableGrid.this);
                        }
                        PortableGrid.this.storage.setSettings(null, PortableGrid.this);
                    } else {
                        PortableGrid.this.storage = null;
                        PortableGrid.this.cache = null;
                    }
                }
                if (PortableGrid.this.cache != null) {
                    PortableGrid.this.cache.invalidate();
                }
                StackUtils.writeItems((IItemHandler)this, 4, PortableGrid.this.stack.func_77978_p());
            }
        }
    };

    public PortableGrid(EntityPlayer player, ItemStack stack, int slotId) {
        this.player = player;
        this.stack = stack;
        this.slotId = slotId;
        if (player != null) {
            this.sortingType = ItemWirelessGrid.getSortingType(stack);
            this.sortingDirection = ItemWirelessGrid.getSortingDirection(stack);
            this.searchBoxMode = ItemWirelessGrid.getSearchBoxMode(stack);
            this.tabSelected = ItemWirelessGrid.getTabSelected(stack);
            this.tabPage = ItemWirelessGrid.getTabPage(stack);
            this.size = ItemWirelessGrid.getSize(stack);
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74764_b(NBT_STORAGE_TRACKER)) {
            this.storageTracker.readFromNbt(stack.func_77978_p().func_150295_c(NBT_STORAGE_TRACKER, 10));
        }
        if (stack.func_77978_p().func_74764_b(NBT_FLUID_STORAGE_TRACKER)) {
            this.fluidStorageTracker.readFromNbt(stack.func_77978_p().func_150295_c(NBT_FLUID_STORAGE_TRACKER, 10));
        }
        StackUtils.readItems((IItemHandlerModifiable)this.disk, 4, stack.func_77978_p());
        StackUtils.readItems((IItemHandlerModifiable)this.filter, 0, stack.func_77978_p());
        this.drainEnergy(RS.INSTANCE.config.portableGridOpenUsage);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    @Nullable
    public IStorageCache<?> getCache() {
        return this.cache;
    }

    @Override
    @Nullable
    public IStorageDisk<?> getStorage() {
        return this.storage;
    }

    @Override
    public void drainEnergy(int energy) {
        if (RS.INSTANCE.config.portableGridUsesEnergy && this.stack.func_77952_i() != 1) {
            ((IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energy, false);
        }
    }

    @Override
    public int getEnergy() {
        if (RS.INSTANCE.config.portableGridUsesEnergy && this.stack.func_77952_i() != 1) {
            return ((IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored();
        }
        return RS.INSTANCE.config.portableGridCapacity;
    }

    @Override
    public ItemHandlerBase getDisk() {
        return this.disk;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public GridType getGridType() {
        return this.getDisk().getStackInSlot(0).func_190926_b() || ((IStorageDiskProvider)this.getDisk().getStackInSlot(0).func_77973_b()).getType() == StorageType.ITEM ? GridType.NORMAL : GridType.FLUID;
    }

    @Nullable
    public IStorageCache getStorageCache() {
        return this.storage != null ? this.cache : null;
    }

    public IStorageCacheListener createListener(EntityPlayerMP player) {
        return this.getGridType() == GridType.FLUID ? new StorageCacheListenerGridPortableFluid(this, player) : new StorageCacheListenerGridPortableItem(this, player);
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    @Nullable
    public IFluidGridHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public void addCraftingListener(IGridCraftingListener listener) {
    }

    @Override
    public void removeCraftingListener(IGridCraftingListener listener) {
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:portable_grid";
    }

    @Override
    public int getViewType() {
        return -1;
    }

    @Override
    public int getSortingType() {
        return this.sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.searchBoxMode;
    }

    @Override
    public int getTabSelected() {
        return this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return Math.min(this.tabPage, this.getTotalTabPages());
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 5.0f);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void onViewTypeChanged(int type) {
    }

    @Override
    public void onSortingTypeChanged(int type) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), type, this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingType = type;
        GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort());
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), direction, this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingDirection = direction;
        GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort());
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), this.getSortingType(), searchBoxMode, this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.searchBoxMode = searchBoxMode;
    }

    @Override
    public void onSizeChanged(int size) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), size, this.getTabSelected(), this.getTabPage()));
        this.size = size;
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_73866_w_();
        }
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        this.tabSelected = tab == this.tabSelected ? -1 : tab;
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.tabSelected, this.getTabPage()));
        GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort());
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), page));
            this.tabPage = page;
        }
    }

    @Override
    public List<IFilter<?>> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    public StorageTrackerItem getItemStorageTracker() {
        return this.storageTracker;
    }

    public StorageTrackerFluid getFluidStorageTracker() {
        return this.fluidStorageTracker;
    }

    @Override
    public InventoryCrafting getCraftingMatrix() {
        return null;
    }

    @Override
    public InventoryCraftResult getCraftingResult() {
        return null;
    }

    @Override
    public void onCraftingMatrixChanged() {
    }

    @Override
    public void onCrafted(EntityPlayer player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
    }

    @Override
    public void onCraftedShift(EntityPlayer player) {
    }

    @Override
    public void onRecipeTransfer(EntityPlayer player, ItemStack[][] recipe) {
    }

    @Override
    public void onClear(EntityPlayer player) {
    }

    @Override
    public void onClosed(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            StackUtils.writeItems((IItemHandler)this.disk, 4, this.stack.func_77978_p());
        }
    }

    @Override
    public boolean isActive() {
        if (RS.INSTANCE.config.portableGridUsesEnergy && this.stack.func_77952_i() != 1 && ((IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() <= RS.INSTANCE.config.portableGridOpenUsage) {
            return false;
        }
        return !this.disk.getStackInSlot(0).func_190926_b();
    }

    @Override
    public int getSlotId() {
        return this.slotId;
    }

    @Override
    public AccessType getAccessType() {
        return AccessType.INSERT_EXTRACT;
    }
}

