/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.util;

import com.google.common.collect.ImmutableMap;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class RenderUtils {
    public static final Matrix4f EMPTY_MATRIX_TRANSFORM = RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).getMatrix();
    private static final TRSRTransformation FLIP_X = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> DEFAULT_ITEM_TRANSFORM;
    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> DEFAULT_BLOCK_TRANSFORM;
    private static final VertexFormat ITEM_FORMAT_WITH_LIGHTMAP;

    public static String shorten(String text, int length) {
        if (text.length() > length) {
            text = text.substring(0, length) + "...";
        }
        return text;
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        vertexBuffer.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    private static TRSRTransformation leftifyTransform(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)FLIP_X.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(FLIP_X));
    }

    private static TRSRTransformation getTransform(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getDefaultItemTransforms() {
        if (DEFAULT_ITEM_TRANSFORM != null) {
            return DEFAULT_ITEM_TRANSFORM;
        }
        DEFAULT_ITEM_TRANSFORM = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)RenderUtils.getTransform(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)RenderUtils.getTransform(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)RenderUtils.getTransform(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)RenderUtils.getTransform(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)RenderUtils.getTransform(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)RenderUtils.getTransform(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f)).build();
        return DEFAULT_ITEM_TRANSFORM;
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getDefaultBlockTransforms() {
        if (DEFAULT_BLOCK_TRANSFORM != null) {
            return DEFAULT_BLOCK_TRANSFORM;
        }
        TRSRTransformation thirdperson = RenderUtils.getTransform(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        DEFAULT_BLOCK_TRANSFORM = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)RenderUtils.getTransform(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)RenderUtils.leftifyTransform(thirdperson)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).build();
        return DEFAULT_BLOCK_TRANSFORM;
    }

    public static int getOffsetOnScale(int pos, float scale) {
        float multiplier = (float)pos / scale;
        return (int)multiplier;
    }

    public static void addCombinedItemsToTooltip(List<String> tooltip, boolean displayAmount, List<ItemStack> stacks) {
        HashSet<Integer> combinedIndices = new HashSet<Integer>();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).func_190926_b() || combinedIndices.contains(i)) continue;
            ItemStack stack = stacks.get(i);
            String data = stack.func_82833_r();
            int amount = stack.func_190916_E();
            for (int j = i + 1; j < stacks.size(); ++j) {
                if (!API.instance().getComparer().isEqual(stack, stacks.get(j))) continue;
                amount += stacks.get(j).func_190916_E();
                combinedIndices.add(j);
            }
            data = (displayAmount ? amount + "x " : "") + data;
            tooltip.add(data);
        }
    }

    public static void addCombinedFluidsToTooltip(List<String> tooltip, boolean showMb, NonNullList<FluidStack> stacks) {
        HashSet<Integer> combinedIndices = new HashSet<Integer>();
        for (int i = 0; i < stacks.size(); ++i) {
            if (combinedIndices.contains(i)) continue;
            FluidStack stack = (FluidStack)stacks.get(i);
            String data = stack.getLocalizedName();
            int amount = stack.amount;
            for (int j = i + 1; j < stacks.size(); ++j) {
                if (!API.instance().getComparer().isEqual(stack, (FluidStack)stacks.get(j), 2)) continue;
                amount += ((FluidStack)stacks.get((int)j)).amount;
                combinedIndices.add(j);
            }
            tooltip.add((showMb ? API.instance().getQuantityFormatter().formatInBucketForm(amount) + " " : "") + data);
        }
    }

    public static void drawTooltipWithSmallText(List<String> textLines, List<String> smallTextLines, boolean showSmallText, @Nonnull ItemStack stack, int mouseX, int mouseY, int screenWidth, int screenHeight, FontRenderer fontRenderer) {
        if (!textLines.isEmpty()) {
            int n;
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, mouseX, mouseY, screenWidth, screenHeight, -1, fontRenderer);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            mouseX = event.getX();
            mouseY = event.getY();
            screenWidth = event.getScreenWidth();
            screenHeight = event.getScreenHeight();
            int maxTextWidth = event.getMaxWidth();
            FontRenderer font = event.getFontRenderer();
            float textScale = font.func_82883_a() ? 1.0f : 0.7f;
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String string : textLines) {
                int textLineWidth = font.func_78256_a(string);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            if (showSmallText) {
                for (String smallText : smallTextLines) {
                    int size = (int)((float)font.func_78256_a(smallText) * textScale);
                    if (size <= tooltipTextWidth) continue;
                    tooltipTextWidth = size;
                }
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (showSmallText) {
                tooltipHeight += smallTextLines.size() * 10;
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            int borderColorStart = 0x505000FF;
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, textLines, tooltipX, tooltipY, font, backgroundColor, borderColorStart, borderColorEnd);
            MinecraftForge.EVENT_BUS.post((Event)colorEvent);
            backgroundColor = colorEvent.getBackground();
            borderColorStart = colorEvent.getBorderStart();
            borderColorEnd = colorEvent.getBorderEnd();
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight - (showSmallText ? smallTextLines.size() * 10 : 0)));
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                font.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, tooltipX, tooltipTop, font, tooltipTextWidth, tooltipHeight));
            if (showSmallText) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)1.0f);
                int y = tooltipTop + tooltipHeight - 6;
                for (int i = smallTextLines.size() - 1; i >= 0; --i) {
                    font.func_175063_a(TextFormatting.GRAY + smallTextLines.get(i), (float)RenderUtils.getOffsetOnScale(tooltipX, textScale), (float)RenderUtils.getOffsetOnScale(y - (font.func_82883_a() ? 2 : 0), textScale), -1);
                    y -= 9;
                }
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public static List<String> getItemTooltip(ItemStack stack) {
        List lines = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int i = 0; i < lines.size(); ++i) {
            if (i == 0) {
                lines.set(i, stack.func_77973_b().getForgeRarity(stack).getColor() + (String)lines.get(i));
                continue;
            }
            lines.set(i, TextFormatting.GRAY + (String)lines.get(i));
        }
        return lines;
    }

    public static boolean isLightMapDisabled() {
        return FMLClientHandler.instance().hasOptifine() || !ForgeModContainer.forgeLightPipelineEnabled;
    }

    public static VertexFormat getFormatWithLightMap(VertexFormat format) {
        if (RenderUtils.isLightMapDisabled()) {
            return format;
        }
        if (format == DefaultVertexFormats.field_176600_a) {
            return DefaultVertexFormats.field_176600_a;
        }
        if (format == DefaultVertexFormats.field_176599_b) {
            return ITEM_FORMAT_WITH_LIGHTMAP;
        }
        if (!format.func_177347_a(1)) {
            VertexFormat result = new VertexFormat(format);
            result.func_181721_a(DefaultVertexFormats.field_181716_p);
            return result;
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextureAtlasSprite getSprite(IBakedModel coverModel, IBlockState coverState, EnumFacing facing, long rand) {
        TextureAtlasSprite sprite = null;
        BlockRenderLayer originalLayer = MinecraftForgeClient.getRenderLayer();
        try {
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                Iterator iterator = coverModel.func_188616_a(coverState, facing, rand).iterator();
                if (iterator.hasNext()) {
                    BakedQuad bakedQuad = (BakedQuad)iterator.next();
                    TextureAtlasSprite textureAtlasSprite = bakedQuad.func_187508_a();
                    return textureAtlasSprite;
                }
                for (BakedQuad bakedQuad : coverModel.func_188616_a(coverState, null, rand)) {
                    if (sprite == null) {
                        sprite = bakedQuad.func_187508_a();
                    }
                    if (bakedQuad.func_178210_d() != facing) continue;
                    TextureAtlasSprite textureAtlasSprite = bakedQuad.func_187508_a();
                    return textureAtlasSprite;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)originalLayer);
        }
        if (sprite == null) {
            try {
                sprite = coverModel.func_177554_e();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sprite == null) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        return sprite;
    }

    static {
        ITEM_FORMAT_WITH_LIGHTMAP = new VertexFormat(DefaultVertexFormats.field_176599_b).func_181721_a(DefaultVertexFormats.field_181716_p);
    }

    public static class FluidRenderer {
        private static final int TEX_WIDTH = 16;
        private static final int TEX_HEIGHT = 16;
        private static final int MIN_FLUID_HEIGHT = 1;
        private final int capacityMb;
        private final int width;
        private final int height;

        public FluidRenderer(int capacityMb, int width, int height) {
            this.capacityMb = capacityMb;
            this.width = width;
            this.height = height;
        }

        public void draw(Minecraft minecraft, int xPosition, int yPosition, FluidStack fluidStack) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179140_f();
            this.drawFluid(minecraft, xPosition, yPosition, fluidStack);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
        }

        private void drawFluid(Minecraft minecraft, int xPosition, int yPosition, FluidStack fluidStack) {
            if (fluidStack == null) {
                return;
            }
            Fluid fluid = fluidStack.getFluid();
            if (fluid == null) {
                return;
            }
            TextureMap textureMapBlocks = minecraft.func_147117_R();
            ResourceLocation fluidStill = fluid.getStill();
            TextureAtlasSprite fluidStillSprite = null;
            if (fluidStill != null) {
                fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
            }
            if (fluidStillSprite == null) {
                fluidStillSprite = textureMapBlocks.func_174944_f();
            }
            int fluidColor = fluid.getColor(fluidStack);
            int scaledAmount = this.height;
            if (this.capacityMb != -1) {
                scaledAmount = fluidStack.amount * this.height / this.capacityMb;
                if (fluidStack.amount > 0 && scaledAmount < 1) {
                    scaledAmount = 1;
                }
                if (scaledAmount > this.height) {
                    scaledAmount = this.height;
                }
            }
            minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            RenderUtils.setGLColorFromInt(fluidColor);
            int xTileCount = this.width / 16;
            int xRemainder = this.width - xTileCount * 16;
            int yTileCount = scaledAmount / 16;
            int yRemainder = scaledAmount - yTileCount * 16;
            int yStart = yPosition + this.height;
            for (int xTile = 0; xTile <= xTileCount; ++xTile) {
                for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                    int width = xTile == xTileCount ? xRemainder : 16;
                    int height = yTile == yTileCount ? yRemainder : 16;
                    int x = xPosition + xTile * 16;
                    int y = yStart - (yTile + 1) * 16;
                    if (width <= 0 || height <= 0) continue;
                    int maskTop = 16 - height;
                    int maskRight = 16 - width;
                    RenderUtils.drawFluidTexture(x, y, fluidStillSprite, maskTop, maskRight, 100.0);
                }
            }
        }
    }
}

