/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.storage;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.common.blocks.RebornOrientableTileBlock;
import techreborn.Core;
import techreborn.tiles.storage.TileEnergyStorage;
import techreborn.utils.TechRebornCreativeTab;

public abstract class BlockEnergyStorage
extends RebornOrientableTileBlock {
    public String name;
    public int guiID;

    public BlockEnergyStorage(String name, int guiID) {
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.name = name;
        this.guiID = guiID;
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, "machines/energy", new IProperty[0]));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!playerIn.func_70093_af()) {
            playerIn.openGui((Object)Core.INSTANCE, this.guiID, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public TileEntity getTileEntitySafely(IBlockAccess blockAccess, BlockPos pos) {
        if (blockAccess instanceof ChunkCache) {
            return ((ChunkCache)blockAccess).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK);
        }
        return blockAccess.func_175625_s(pos);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = this.getTileEntitySafely(world, pos);
        if (!(tileEntity instanceof TileEnergyStorage)) {
            return 0;
        }
        return ((TileEnergyStorage)tileEntity).getRedstoneLevel();
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity tileEntity = this.getTileEntitySafely(world, pos);
        return tileEntity instanceof TileEnergyStorage;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tileEntity = this.getTileEntitySafely((IBlockAccess)world, pos);
        if (!(tileEntity instanceof TileEnergyStorage)) {
            return 0;
        }
        return ((TileEnergyStorage)tileEntity).getComparatorValue();
    }

    public int func_176201_c(IBlockState state) {
        int facingInt = this.getSideFromEnum((EnumFacing)state.func_177229_b((IProperty)FACING));
        return facingInt;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = this.getSideFromint(meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public EnumFacing getSideFromint(int i) {
        if (i == 0) {
            return EnumFacing.NORTH;
        }
        if (i == 1) {
            return EnumFacing.SOUTH;
        }
        if (i == 2) {
            return EnumFacing.EAST;
        }
        if (i == 3) {
            return EnumFacing.WEST;
        }
        if (i == 4) {
            return EnumFacing.UP;
        }
        if (i == 5) {
            return EnumFacing.DOWN;
        }
        return EnumFacing.NORTH;
    }

    public int getSideFromEnum(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return 0;
        }
        if (facing == EnumFacing.SOUTH) {
            return 1;
        }
        if (facing == EnumFacing.EAST) {
            return 2;
        }
        if (facing == EnumFacing.WEST) {
            return 3;
        }
        if (facing == EnumFacing.UP) {
            return 4;
        }
        if (facing == EnumFacing.DOWN) {
            return 5;
        }
        return 0;
    }
}

