/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.praescriptum.fuels.Fuel;
import reborncore.api.praescriptum.ingredients.input.FluidStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.common.util.ItemUtils;

public abstract class FuelWrapper
implements IRecipeWrapper {
    protected final Fuel fuel;
    protected final List<List<ItemStack>> itemInputs = new ArrayList<List<ItemStack>>();
    protected final List<List<FluidStack>> fluidInputs = new ArrayList<List<FluidStack>>();

    public FuelWrapper(Fuel fuel) {
        this.fuel = fuel;
        fuel.getInputIngredients().stream().filter(entry -> entry instanceof ItemStackInputIngredient).map(entry -> ImmutableList.of((Object)((ItemStack)entry.ingredient))).collect(Collectors.toCollection(() -> this.itemInputs));
        fuel.getInputIngredients().stream().filter(entry -> entry instanceof OreDictionaryInputIngredient).map(entry -> OreDictionary.getOres((String)((String)entry.ingredient)).stream().map(stack -> FuelWrapper.copyWithSize(stack, entry.getCount())).collect(Collectors.toList())).collect(Collectors.toCollection(() -> this.itemInputs));
        fuel.getInputIngredients().stream().filter(entry -> entry instanceof FluidStackInputIngredient).map(entry -> ImmutableList.of((Object)FuelWrapper.copyWithSize((FluidStack)entry.ingredient, entry.getCount()))).collect(Collectors.toCollection(() -> this.fluidInputs));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.itemInputs);
        ingredients.setInputLists(VanillaTypes.FLUID, this.fluidInputs);
    }

    public static ItemStack copyWithSize(ItemStack itemStack, int size) {
        if (ItemUtils.isEmpty((ItemStack)itemStack)) {
            return ItemStack.field_190927_a;
        }
        return ItemUtils.setSize((ItemStack)itemStack.func_77946_l(), (int)size);
    }

    public static FluidStack copyWithSize(FluidStack fluidStack, int size) {
        return new FluidStack(fluidStack.getFluid(), size);
    }
}

