/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipesGui;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.collect.ListMultiMap;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.recipes.RecipeClickableArea;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Translator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.input.Mouse;
import reborncore.api.praescriptum.fuels.Fuel;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.recipe.RecipeHandler;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.GuiSlotConfiguration;
import reborncore.common.util.StringUtils;
import techreborn.Core;
import techreborn.api.fluidreplicator.FluidReplicatorRecipe;
import techreborn.api.fluidreplicator.FluidReplicatorRecipeList;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.api.recipe.Fuels;
import techreborn.api.recipe.Recipes;
import techreborn.api.recipe.machines.BlastFurnaceRecipe;
import techreborn.api.recipe.machines.DistillationTowerRecipe;
import techreborn.api.recipe.machines.ImplosionCompressorRecipe;
import techreborn.api.recipe.machines.IndustrialElectrolyzerRecipe;
import techreborn.api.recipe.machines.IndustrialGrinderRecipe;
import techreborn.api.recipe.machines.IndustrialSawmillRecipe;
import techreborn.api.recipe.machines.ScrapboxRecipe;
import techreborn.api.recipe.machines.VacuumFreezerRecipe;
import techreborn.blocks.cable.EnumCableType;
import techreborn.client.gui.GuiAlloyFurnace;
import techreborn.client.gui.GuiBlastFurnace;
import techreborn.client.gui.GuiDistillationTower;
import techreborn.client.gui.GuiElectricFurnace;
import techreborn.client.gui.GuiFluidReplicator;
import techreborn.client.gui.GuiFusionReactor;
import techreborn.client.gui.GuiGenerator;
import techreborn.client.gui.GuiImplosionCompressor;
import techreborn.client.gui.GuiIndustrialElectrolyzer;
import techreborn.client.gui.GuiIndustrialGrinder;
import techreborn.client.gui.GuiIndustrialSawmill;
import techreborn.client.gui.GuiIronFurnace;
import techreborn.client.gui.GuiRollingMachine;
import techreborn.client.gui.GuiScrapboxinator;
import techreborn.client.gui.GuiVacuumFreezer;
import techreborn.client.gui.generator.lv.GuiDieselGenerator;
import techreborn.client.gui.generator.lv.GuiGasTurbine;
import techreborn.client.gui.generator.lv.GuiPlasmaGenerator;
import techreborn.client.gui.generator.lv.GuiSemifluidGenerator;
import techreborn.client.gui.generator.lv.GuiThermalGenerator;
import techreborn.client.gui.processing.GuiCentrifuge;
import techreborn.client.gui.processing.lv.GuiAlloySmelter;
import techreborn.client.gui.processing.lv.GuiAssemblingMachine;
import techreborn.client.gui.processing.lv.GuiChemicalReactor;
import techreborn.client.gui.processing.lv.GuiCompressor;
import techreborn.client.gui.processing.lv.GuiExtractor;
import techreborn.client.gui.processing.lv.GuiGrinder;
import techreborn.client.gui.processing.lv.GuiPlateBendingMachine;
import techreborn.client.gui.processing.lv.GuiSolidCanningMachine;
import techreborn.client.gui.processing.lv.GuiWireMill;
import techreborn.compat.CompatConfigs;
import techreborn.compat.CompatManager;
import techreborn.compat.jei.BuiltContainerTransferInfo;
import techreborn.compat.jei.blastFurnace.BlastFurnaceRecipeCategory;
import techreborn.compat.jei.blastFurnace.BlastFurnaceRecipeWrapper;
import techreborn.compat.jei.distillationTower.DistillationTowerRecipeCategory;
import techreborn.compat.jei.distillationTower.DistillationTowerRecipeWrapper;
import techreborn.compat.jei.fluidReplicator.FluidReplicatorRecipeCategory;
import techreborn.compat.jei.fluidReplicator.FluidReplicatorRecipeWrapper;
import techreborn.compat.jei.fusionReactor.FusionReactorRecipeCategory;
import techreborn.compat.jei.fusionReactor.FusionReactorRecipeWrapper;
import techreborn.compat.jei.implosionCompressor.ImplosionCompressorRecipeCategory;
import techreborn.compat.jei.implosionCompressor.ImplosionCompressorRecipeWrapper;
import techreborn.compat.jei.industrialElectrolyzer.IndustrialElectrolyzerRecipeCategory;
import techreborn.compat.jei.industrialElectrolyzer.IndustrialElectrolyzerRecipeWrapper;
import techreborn.compat.jei.industrialGrinder.IndustrialGrinderRecipeCategory;
import techreborn.compat.jei.industrialGrinder.IndustrialGrinderRecipeWrapper;
import techreborn.compat.jei.industrialSawmill.IndustrialSawmillRecipeCategory;
import techreborn.compat.jei.industrialSawmill.IndustrialSawmillRecipeWrapper;
import techreborn.compat.jei.praescriptum.alloysmelter.AlloySmelterRecipeCategory;
import techreborn.compat.jei.praescriptum.alloysmelter.AlloySmelterRecipeWrapper;
import techreborn.compat.jei.praescriptum.assemblingmachine.AssemblingMachineRecipeCategory;
import techreborn.compat.jei.praescriptum.assemblingmachine.AssemblingMachineRecipeWrapper;
import techreborn.compat.jei.praescriptum.centrifuge.CentrifugeRecipeCategory;
import techreborn.compat.jei.praescriptum.centrifuge.CentrifugeRecipeWrapper;
import techreborn.compat.jei.praescriptum.chemicalreactor.ChemicalReactorRecipeCategory;
import techreborn.compat.jei.praescriptum.chemicalreactor.ChemicalReactorRecipeWrapper;
import techreborn.compat.jei.praescriptum.compressor.CompressorRecipeCategory;
import techreborn.compat.jei.praescriptum.compressor.CompressorRecipeWrapper;
import techreborn.compat.jei.praescriptum.dieselgenerator.DieselGeneratorFuelCategory;
import techreborn.compat.jei.praescriptum.dieselgenerator.DieselGeneratorFuelWrapper;
import techreborn.compat.jei.praescriptum.extractor.ExtractorRecipeCategory;
import techreborn.compat.jei.praescriptum.extractor.ExtractorRecipeWrapper;
import techreborn.compat.jei.praescriptum.gasturbine.GasTurbineFuelCategory;
import techreborn.compat.jei.praescriptum.gasturbine.GasTurbineFuelWrapper;
import techreborn.compat.jei.praescriptum.grinder.GrinderRecipeCategory;
import techreborn.compat.jei.praescriptum.grinder.GrinderRecipeWrapper;
import techreborn.compat.jei.praescriptum.plasmagenerator.PlasmaGeneratorFuelCategory;
import techreborn.compat.jei.praescriptum.plasmagenerator.PlasmaGeneratorFuelWrapper;
import techreborn.compat.jei.praescriptum.platebendingmachine.PlateBendingMachineRecipeCategory;
import techreborn.compat.jei.praescriptum.platebendingmachine.PlateBendingMachineRecipeWrapper;
import techreborn.compat.jei.praescriptum.semifluidgenerator.SemiFluidGeneratorFuelCategory;
import techreborn.compat.jei.praescriptum.semifluidgenerator.SemiFluidGeneratorFuelWrapper;
import techreborn.compat.jei.praescriptum.solidcanningmachine.SolidCanningMachineRecipeCategory;
import techreborn.compat.jei.praescriptum.solidcanningmachine.SolidCanningMachineRecipeWrapper;
import techreborn.compat.jei.praescriptum.thermalgenerator.ThermalGeneratorFuelCategory;
import techreborn.compat.jei.praescriptum.thermalgenerator.ThermalGeneratorFuelWrapper;
import techreborn.compat.jei.praescriptum.wiremill.WireMillRecipeCategory;
import techreborn.compat.jei.praescriptum.wiremill.WireMillRecipeWrapper;
import techreborn.compat.jei.rollingMachine.RollingMachineRecipeCategory;
import techreborn.compat.jei.rollingMachine.RollingMachineRecipeMaker;
import techreborn.compat.jei.rollingMachine.RollingMachineRecipeWrapper;
import techreborn.compat.jei.scrapbox.ScrapboxRecipeCategory;
import techreborn.compat.jei.scrapbox.ScrapboxRecipeWrapper;
import techreborn.compat.jei.vacuumFreezer.VacuumFreezerRecipeCategory;
import techreborn.compat.jei.vacuumFreezer.VacuumFreezerRecipeWrapper;
import techreborn.dispenser.BehaviorDispenseScrapbox;
import techreborn.init.IC2Duplicates;
import techreborn.init.ModBlocks;
import techreborn.init.ModFluids;
import techreborn.init.ModItems;
import techreborn.items.ingredients.ItemParts;

@JEIPlugin
public class TechRebornJeiPlugin
implements IModPlugin {
    public static final ListMultiMap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreas = new ListMultiMap();
    static IRecipesGui recipesGui;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new BlastFurnaceRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new DistillationTowerRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FusionReactorRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ImplosionCompressorRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new IndustrialGrinderRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new IndustrialElectrolyzerRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new IndustrialSawmillRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RollingMachineRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new VacuumFreezerRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidReplicatorRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloySmelterRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AssemblingMachineRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CentrifugeRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalReactorRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompressorRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ExtractorRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GrinderRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PlateBendingMachineRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SolidCanningMachineRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new WireMillRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new DieselGeneratorFuelCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GasTurbineFuelCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PlasmaGeneratorFuelCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SemiFluidGeneratorFuelCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ThermalGeneratorFuelCategory(guiHelper)});
        if (CompatConfigs.showScrapbox) {
            registry.addRecipeCategories(new IRecipeCategory[]{new ScrapboxRecipeCategory(guiHelper)});
        }
    }

    public void register(@Nonnull IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_BERYLLIUM));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_CALCIUM));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_CALCIUM_CARBONATE));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_CHLORITE));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_DEUTERIUM));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_GLYCERYL));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_HELIUM));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_HELIUM_3));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_HELIUMPLASMA));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_HYDROGEN));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_LITHIUM));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_MERCURY));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_METHANE));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_NITROCOAL_FUEL));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_NITROFUEL));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_NITROGEN));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_NITROGENDIOXIDE));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_POTASSIUM));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_SILICON));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_SODIUM));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_SODIUMPERSULFATE));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_TRITIUM));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_WOLFRAMIUM));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_SULFUR));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_SULFURIC_ACID));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_CARBON));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_CARBON_FIBER));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_NITRO_CARBON));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_SODIUM_SULFIDE));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_DIESEL));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_NITRO_DIESEL));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_OIL));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_ELECTROLYZED_WATER));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)ModFluids.BLOCK_COMPRESSED_AIR));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModItems.MISSING_RECIPE_PLACEHOLDER));
        if (CompatManager.isQuantumStorageLoaded) {
            jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModBlocks.QUANTUM_CHEST));
            jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModBlocks.QUANTUM_TANK));
        }
        if (IC2Duplicates.deduplicate()) {
            for (IC2Duplicates duplicate : IC2Duplicates.values()) {
                if (!duplicate.hasIC2Stack()) continue;
                jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)duplicate.getTrStack());
            }
            for (int i = 0; i < EnumCableType.values().length; ++i) {
                jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModBlocks.CABLE, 1, i));
            }
            jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)ItemParts.getPartByName("rubber"));
            jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)ItemParts.getPartByName("rubberSap"));
            jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)ItemParts.getPartByName("electronicCircuit"));
            jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)ItemParts.getPartByName("advancedCircuit"));
            if (!Core.worldGen.config.rubberTreeConfig.shouldSpawn) {
                jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModBlocks.RUBBER_SAPLING));
                jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModBlocks.RUBBER_LOG));
                jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModBlocks.RUBBER_PLANKS));
                jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModBlocks.RUBBER_LEAVES));
                jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModItems.TREE_TAP));
                jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModItems.ELECTRIC_TREE_TAP));
            }
        }
        registry.handleRecipes(BlastFurnaceRecipe.class, recipe -> new BlastFurnaceRecipeWrapper(jeiHelpers, (BlastFurnaceRecipe)recipe), "TechReborn.BlastFurnace");
        registry.handleRecipes(FusionReactorRecipe.class, FusionReactorRecipeWrapper::new, "TechReborn.FusionReactor");
        registry.handleRecipes(ImplosionCompressorRecipe.class, recipe -> new ImplosionCompressorRecipeWrapper(jeiHelpers, (ImplosionCompressorRecipe)recipe), "TechReborn.ImplosionCompressor");
        registry.handleRecipes(IndustrialElectrolyzerRecipe.class, recipe -> new IndustrialElectrolyzerRecipeWrapper(jeiHelpers, (IndustrialElectrolyzerRecipe)recipe), "TechReborn.IndustrialElectrolyzer");
        registry.handleRecipes(IndustrialGrinderRecipe.class, recipe -> new IndustrialGrinderRecipeWrapper(jeiHelpers, (IndustrialGrinderRecipe)recipe), "TechReborn.IndustrialGrinder");
        registry.handleRecipes(IndustrialSawmillRecipe.class, recipe -> new IndustrialSawmillRecipeWrapper(jeiHelpers, (IndustrialSawmillRecipe)recipe), "TechReborn.IndustrialSawmill");
        registry.handleRecipes(VacuumFreezerRecipe.class, recipe -> new VacuumFreezerRecipeWrapper(jeiHelpers, (VacuumFreezerRecipe)recipe), "TechReborn.VacuumFreezer");
        registry.handleRecipes(DistillationTowerRecipe.class, recipe -> new DistillationTowerRecipeWrapper(jeiHelpers, (DistillationTowerRecipe)recipe), "TechReborn.DistillationTower");
        registry.handleRecipes(FluidReplicatorRecipe.class, recipe -> new FluidReplicatorRecipeWrapper(jeiHelpers, (FluidReplicatorRecipe)recipe), "TechReborn.FluidReplicator");
        registry.handleRecipes(ShapelessRecipes.class, recipe -> new RollingMachineRecipeWrapper((IRecipeWrapper)recipe), "TechReborn.RollingMachine");
        registry.handleRecipes(ShapedRecipes.class, recipe -> new RollingMachineRecipeWrapper((IRecipeWrapper)recipe), "TechReborn.RollingMachine");
        registry.handleRecipes(ShapedOreRecipe.class, recipe -> new RollingMachineRecipeWrapper((IRecipeWrapper)recipe), "TechReborn.RollingMachine");
        registry.handleRecipes(ShapelessOreRecipe.class, recipe -> new RollingMachineRecipeWrapper((IRecipeWrapper)recipe), "TechReborn.RollingMachine");
        registry.handleRecipes(Recipe.class, recipe -> new AlloySmelterRecipeWrapper(jeiHelpers, (Recipe)recipe), "TechReborn.AlloySmelter");
        registry.handleRecipes(Recipe.class, recipe -> new AssemblingMachineRecipeWrapper(jeiHelpers, (Recipe)recipe), "TechReborn.AssemblingMachine");
        registry.handleRecipes(Recipe.class, recipe -> new CentrifugeRecipeWrapper(jeiHelpers, (Recipe)recipe), "TechReborn.Centrifuge");
        registry.handleRecipes(Recipe.class, recipe -> new ChemicalReactorRecipeWrapper(jeiHelpers, (Recipe)recipe), "TechReborn.ChemicalReactor");
        registry.handleRecipes(Recipe.class, recipe -> new CompressorRecipeWrapper(jeiHelpers, (Recipe)recipe), "TechReborn.Compressor");
        registry.handleRecipes(Recipe.class, recipe -> new ExtractorRecipeWrapper(jeiHelpers, (Recipe)recipe), "TechReborn.Extractor");
        registry.handleRecipes(Recipe.class, recipe -> new GrinderRecipeWrapper(jeiHelpers, (Recipe)recipe), "TechReborn.Grinder");
        registry.handleRecipes(Recipe.class, recipe -> new PlateBendingMachineRecipeWrapper(jeiHelpers, (Recipe)recipe), "TechReborn.PlateBendingMachine");
        registry.handleRecipes(Recipe.class, recipe -> new SolidCanningMachineRecipeWrapper(jeiHelpers, (Recipe)recipe), "TechReborn.SolidCanningMachine");
        registry.handleRecipes(Recipe.class, recipe -> new WireMillRecipeWrapper(jeiHelpers, (Recipe)recipe), "TechReborn.WireMill");
        registry.handleRecipes(Fuel.class, fuel -> new DieselGeneratorFuelWrapper(jeiHelpers, (Fuel)fuel), "TechReborn.DieselGenerator");
        registry.handleRecipes(Fuel.class, fuel -> new GasTurbineFuelWrapper(jeiHelpers, (Fuel)fuel), "TechReborn.GasTurbine");
        registry.handleRecipes(Fuel.class, fuel -> new PlasmaGeneratorFuelWrapper(jeiHelpers, (Fuel)fuel), "TechReborn.PlasmaGenerator");
        registry.handleRecipes(Fuel.class, fuel -> new SemiFluidGeneratorFuelWrapper(jeiHelpers, (Fuel)fuel), "TechReborn.SemifluidGenerator");
        registry.handleRecipes(Fuel.class, fuel -> new ThermalGeneratorFuelWrapper(jeiHelpers, (Fuel)fuel), "TechReborn.ThermalGenerator");
        if (CompatConfigs.showScrapbox) {
            registry.handleRecipes(ScrapboxRecipe.class, recipe -> new ScrapboxRecipeWrapper(jeiHelpers, (ScrapboxRecipe)recipe), "TechReborn.Scrapbox");
        }
        registry.addRecipes((Collection)RecipeHandler.recipeList.stream().filter(recipe -> {
            if (recipe instanceof ScrapboxRecipe) {
                return CompatConfigs.showScrapbox;
            }
            return true;
        }).collect(Collectors.toList()));
        registry.addRecipes(FusionReactorRecipeHelper.reactorRecipes, "TechReborn.FusionReactor");
        registry.addRecipes(FluidReplicatorRecipeList.recipes, "TechReborn.FluidReplicator");
        GeneratorRecipeHelper.fluidRecipes.forEach((type, list) -> registry.addRecipes(list.getRecipes(), type.getRecipeID()));
        try {
            registry.addRecipes(RollingMachineRecipeMaker.getRecipes(jeiHelpers), "TechReborn.RollingMachine");
        }
        catch (RuntimeException e) {
            Core.logHelper.error((Object)"Could not register rolling machine recipes. JEI may have changed its internal recipe wrapper locations.");
            e.printStackTrace();
        }
        registry.addRecipes(Recipes.alloySmelter.getRecipes(), "TechReborn.AlloySmelter");
        registry.addRecipes(Recipes.assemblingMachine.getRecipes(), "TechReborn.AssemblingMachine");
        registry.addRecipes(Recipes.centrifuge.getRecipes(), "TechReborn.Centrifuge");
        registry.addRecipes(Recipes.chemicalReactor.getRecipes(), "TechReborn.ChemicalReactor");
        registry.addRecipes(Recipes.compressor.getRecipes(), "TechReborn.Compressor");
        registry.addRecipes(Recipes.extractor.getRecipes(), "TechReborn.Extractor");
        registry.addRecipes(Recipes.grinder.getRecipes(), "TechReborn.Grinder");
        registry.addRecipes(Recipes.plateBendingMachine.getRecipes(), "TechReborn.PlateBendingMachine");
        registry.addRecipes(Recipes.solidCanningMachine.getRecipes(), "TechReborn.SolidCanningMachine");
        registry.addRecipes(Recipes.wireMill.getRecipes(), "TechReborn.WireMill");
        registry.addRecipes(Fuels.dieselGenerator.getFuels(), "TechReborn.DieselGenerator");
        registry.addRecipes(Fuels.gasTurbine.getFuels(), "TechReborn.GasTurbine");
        registry.addRecipes(Fuels.plasmaGenerator.getFuels(), "TechReborn.PlasmaGenerator");
        registry.addRecipes(Fuels.semiFluidGenerator.getFuels(), "TechReborn.SemifluidGenerator");
        registry.addRecipes(Fuels.thermalGenerator.getFuels(), "TechReborn.ThermalGenerator");
        registry.addIngredientInfo((Object)ItemParts.getPartByName("rubberSap"), ItemStack.class, new String[]{StringUtils.t((String)"techreborn.jei.desc.rubberSap")});
        if (!BehaviorDispenseScrapbox.dispenseScrapboxes) {
            registry.addIngredientInfo((Object)new ItemStack(ModItems.SCRAP_BOX), ItemStack.class, new String[]{StringUtils.t((String)"techreborn.desc.scrapBoxNoDispenser")});
        } else {
            registry.addIngredientInfo((Object)new ItemStack(ModItems.SCRAP_BOX), ItemStack.class, new String[]{StringUtils.t((String)"techreborn.desc.scrapBox")});
        }
        this.addRecipeClickArea(GuiCentrifuge.class, 158, 5, 12, 12, "TechReborn.Centrifuge");
        this.addRecipeClickArea(GuiElectricFurnace.class, 158, 5, 12, 12, "minecraft.smelting");
        this.addRecipeClickArea(GuiGenerator.class, 158, 5, 12, 12, "minecraft.fuel");
        this.addRecipeClickArea(GuiExtractor.class, 158, 5, 12, 12, "TechReborn.Extractor");
        this.addRecipeClickArea(GuiCompressor.class, 158, 5, 12, 12, "TechReborn.Compressor");
        this.addRecipeClickArea(GuiGrinder.class, 158, 5, 12, 12, "TechReborn.Grinder");
        this.addRecipeClickArea(GuiVacuumFreezer.class, 158, 5, 12, 12, "TechReborn.VacuumFreezer");
        this.addRecipeClickArea(GuiBlastFurnace.class, 158, 5, 12, 12, "TechReborn.BlastFurnace");
        this.addRecipeClickArea(GuiChemicalReactor.class, 158, 5, 12, 12, "TechReborn.ChemicalReactor");
        this.addRecipeClickArea(GuiImplosionCompressor.class, 158, 5, 12, 12, "TechReborn.ImplosionCompressor");
        this.addRecipeClickArea(GuiIndustrialGrinder.class, 158, 5, 12, 12, "TechReborn.IndustrialGrinder");
        this.addRecipeClickArea(GuiIndustrialSawmill.class, 158, 5, 20, 15, "TechReborn.IndustrialSawmill");
        this.addRecipeClickArea(GuiIndustrialElectrolyzer.class, 158, 5, 12, 12, "TechReborn.IndustrialElectrolyzer");
        this.addRecipeClickArea(GuiSemifluidGenerator.class, 158, 5, 12, 12, "TechReborn.SemifluidGenerator");
        this.addRecipeClickArea(GuiDieselGenerator.class, 158, 5, 12, 12, "TechReborn.DieselGenerator");
        this.addRecipeClickArea(GuiGasTurbine.class, 158, 5, 12, 12, "TechReborn.GasTurbine");
        this.addRecipeClickArea(GuiThermalGenerator.class, 158, 5, 12, 12, "TechReborn.ThermalGenerator");
        this.addRecipeClickArea(GuiAlloySmelter.class, 158, 5, 12, 12, "TechReborn.AlloySmelter");
        this.addRecipeClickArea(GuiPlateBendingMachine.class, 158, 5, 12, 12, "TechReborn.PlateBendingMachine");
        this.addRecipeClickArea(GuiPlasmaGenerator.class, 158, 5, 12, 12, "TechReborn.PlasmaGenerator");
        this.addRecipeClickArea(GuiDistillationTower.class, 158, 5, 12, 12, "TechReborn.DistillationTower");
        this.addRecipeClickArea(GuiScrapboxinator.class, 158, 5, 12, 12, "TechReborn.Scrapbox");
        this.addRecipeClickArea(GuiFusionReactor.class, 158, 5, 12, 12, "TechReborn.FusionReactor");
        this.addRecipeClickArea(GuiRollingMachine.class, 158, 5, 12, 12, "TechReborn.RollingMachine");
        this.addRecipeClickArea(GuiFluidReplicator.class, 158, 5, 12, 12, "TechReborn.FluidReplicator");
        this.addRecipeClickArea(GuiAssemblingMachine.class, 158, 5, 12, 12, "TechReborn.AssemblingMachine");
        this.addRecipeClickArea(GuiSolidCanningMachine.class, 158, 5, 12, 12, "TechReborn.SolidCanningMachine");
        this.addRecipeClickArea(GuiWireMill.class, 158, 5, 12, 12, "TechReborn.WireMill");
        this.addRecipeClickArea(GuiAlloyFurnace.class, 80, 35, 26, 20, "TechReborn.AlloySmelter", "minecraft.fuel");
        this.addRecipeClickArea(GuiIronFurnace.class, 78, 36, 24, 16, "minecraft.smelting", "minecraft.fuel");
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.IRON_FURNACE), new String[]{"minecraft.smelting", "minecraft.fuel"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.IRON_ALLOY_FURNACE), new String[]{"TechReborn.AlloySmelter", "minecraft.fuel"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.SOLID_FUEL_GENEREATOR), new String[]{"minecraft.fuel"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.SEMI_FLUID_GENERATOR), new String[]{"TechReborn.SemifluidGenerator"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.GAS_TURBINE), new String[]{"TechReborn.GasTurbine"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.DIESEL_GENERATOR), new String[]{"TechReborn.DieselGenerator"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.THERMAL_GENERATOR), new String[]{"TechReborn.ThermalGenerator"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.PLASMA_GENERATOR), new String[]{"TechReborn.PlasmaGenerator"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.COMPRESSOR), new String[]{"TechReborn.Compressor"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.EXTRACTOR), new String[]{"TechReborn.Extractor"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.GRINDER), new String[]{"TechReborn.Grinder"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.VACUUM_FREEZER), new String[]{"TechReborn.VacuumFreezer"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.ELECTRIC_FURNACE), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.ALLOY_SMELTER), new String[]{"TechReborn.AlloySmelter"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.ASSEMBLING_MACHINE), new String[]{"TechReborn.AssemblingMachine"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.CHEMICAL_REACTOR), new String[]{"TechReborn.ChemicalReactor"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.FUSION_CONTROL_COMPUTER), new String[]{"TechReborn.FusionReactor"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.IMPLOSION_COMPRESSOR), new String[]{"TechReborn.ImplosionCompressor"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.INDUSTRIAL_BLAST_FURNACE), new String[]{"TechReborn.BlastFurnace"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.INDUSTRIAL_CENTRIFUGE), new String[]{"TechReborn.Centrifuge"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.INDUSTRIAL_ELECTROLYZER), new String[]{"TechReborn.IndustrialElectrolyzer"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.INDUSTRIAL_GRINDER), new String[]{"TechReborn.IndustrialGrinder"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.INDUSTRIAL_SAWMILL), new String[]{"TechReborn.IndustrialSawmill"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.PLATE_BENDING_MACHINE), new String[]{"TechReborn.PlateBendingMachine"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.ROLLING_MACHINE), new String[]{"TechReborn.RollingMachine"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.DISTILLATION_TOWER), new String[]{"TechReborn.DistillationTower"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.FLUID_REPLICATOR), new String[]{"TechReborn.FluidReplicator"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.SOLID_CANNING_MACHINE), new String[]{"TechReborn.SolidCanningMachine"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.WIRE_MILL), new String[]{"TechReborn.WireMill"});
        if (CompatConfigs.showScrapbox) {
            registry.addRecipeCatalyst((Object)new ItemStack(ModItems.SCRAP_BOX), new String[]{"TechReborn.Scrapbox"});
        }
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("fusionreactor", "TechReborn.FusionReactor", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("industrialelectrolyzer", "TechReborn.IndustrialElectrolyzer", 40, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("industrialgrinder", "TechReborn.IndustrialGrinder", 40, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("implosioncompressor", "TechReborn.ImplosionCompressor", 40, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("vacuumfreezer", "TechReborn.VacuumFreezer", 40, 1, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("blastfurnace", "TechReborn.BlastFurnace", 40, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("alloyfurnace", "TechReborn.AlloySmelter", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("alloyfurnace", "minecraft.fuel", 39, 1, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("alloysmelter", "TechReborn.AlloySmelter", 40, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("assemblingmachine", "TechReborn.AssemblingMachine", 40, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("chemicalreactor", "TechReborn.ChemicalReactor", 40, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("centrifuge", "TechReborn.Centrifuge", 40, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("grinder", "TechReborn.Grinder", 40, 1, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("extractor", "TechReborn.Extractor", 40, 1, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("compressor", "TechReborn.Compressor", 40, 1, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("industrialsawmill", "TechReborn.IndustrialSawmill", 40, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("distillationtower", "TechReborn.DistillationTower", 40, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("autocraftingtable", "minecraft.crafting", 40, 9, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("platebendingmachine", "TechReborn.PlateBendingMachine", 40, 1, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("solidcanningmachine", "TechReborn.SolidCanningMachine", 40, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("wiremill", "TechReborn.WireMill", 40, 1, 0, 36));
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new AdvancedGuiHandler()});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipesGui = jeiRuntime.getRecipesGui();
    }

    public void addRecipeClickArea(Class<? extends GuiContainer> guiContainerClass, int xPos, int yPos, int width, int height, String ... recipeCategoryUids) {
        ErrorUtil.checkNotNull(guiContainerClass, (String)"guiContainerClass");
        ErrorUtil.checkNotEmpty((Object[])recipeCategoryUids, (String)"recipeCategoryUids");
        RecipeClickableArea recipeClickableArea = new RecipeClickableArea(yPos, yPos + height, xPos, xPos + width, recipeCategoryUids);
        recipeClickableAreas.put(guiContainerClass, (Object)recipeClickableArea);
    }

    public static RecipeClickableArea getRecipeClickableArea(GuiContainer gui, int mouseX, int mouseY) {
        for (RecipeClickableArea recipeClickableArea : recipeClickableAreas.toImmutable().get(gui.getClass())) {
            if (!recipeClickableArea.checkHover(mouseX, mouseY)) continue;
            return recipeClickableArea;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void drawScreenEvent(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiContainer guiContainer;
        if (GuiBase.slotConfigType != GuiBase.SlotConfigType.NONE) {
            return;
        }
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiContainer && TechRebornJeiPlugin.getRecipeClickableArea(guiContainer = (GuiContainer)gui, event.getMouseX() - guiContainer.getGuiLeft(), event.getMouseY() - guiContainer.getGuiTop()) != null) {
            TooltipRenderer.drawHoveringText((Minecraft)guiContainer.field_146297_k, (String)Translator.translateToLocal((String)"jei.tooltip.show.recipes"), (int)event.getMouseX(), (int)event.getMouseY());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void handleMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (GuiBase.slotConfigType != GuiBase.SlotConfigType.NONE) {
            return;
        }
        int eventButton = Mouse.getEventButton();
        if (eventButton > -1 && Mouse.getEventButtonState() && event.getGui() instanceof GuiContainer) {
            int x = Mouse.getEventX() * event.getGui().field_146294_l / event.getGui().field_146297_k.field_71443_c;
            int y = event.getGui().field_146295_m - Mouse.getEventY() * event.getGui().field_146295_m / event.getGui().field_146297_k.field_71440_d - 1;
            GuiContainer guiContainer = (GuiContainer)event.getGui();
            RecipeClickableArea clickableArea = TechRebornJeiPlugin.getRecipeClickableArea(guiContainer, x - guiContainer.getGuiLeft(), y - guiContainer.getGuiTop());
            if (clickableArea != null) {
                List recipeCategoryUids = clickableArea.getRecipeCategoryUids();
                recipesGui.showCategories(recipeCategoryUids);
                event.setCanceled(true);
            }
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(TechRebornJeiPlugin.class);
    }

    public static class AdvancedGuiHandler
    implements IAdvancedGuiHandler<GuiBase> {
        public Class<GuiBase> getGuiContainerClass() {
            return GuiBase.class;
        }

        @Nullable
        public List<Rectangle> getGuiExtraAreas(GuiBase guiContainer) {
            return GuiSlotConfiguration.getExtraSpace((GuiBase)guiContainer);
        }

        @Nullable
        public Object getIngredientUnderMouse(GuiBase guiContainer, int mouseX, int mouseY) {
            return null;
        }
    }
}

