/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.praescriptum.alloysmelter;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import net.minecraft.client.Minecraft;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.compat.jei.RecipeWrapper;

public class AlloySmelterRecipeWrapper
extends RecipeWrapper {
    private final IDrawableAnimated progressLeft;
    private final IDrawableAnimated progressRight;

    public AlloySmelterRecipeWrapper(IJeiHelpers jeiHelpers, Recipe recipe) {
        super(recipe);
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        GuiBuilder.ProgressDirection right = GuiBuilder.ProgressDirection.RIGHT;
        GuiBuilder.ProgressDirection left = GuiBuilder.ProgressDirection.LEFT;
        IDrawableStatic progressLeftStatic = guiHelper.createDrawable(GuiBuilder.defaultTextureSheet, right.xActive, right.yActive, right.width, right.height);
        IDrawableStatic progressRightStatic = guiHelper.createDrawable(GuiBuilder.defaultTextureSheet, left.xActive, left.yActive, left.width, left.height);
        int ticksPerCycle = recipe.getOperationDuration();
        this.progressLeft = guiHelper.createAnimatedDrawable(progressLeftStatic, ticksPerCycle, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressRight = guiHelper.createAnimatedDrawable(progressRightStatic, ticksPerCycle, IDrawableAnimated.StartDirection.RIGHT, false);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        this.progressLeft.draw(minecraft, 25, 12);
        this.progressRight.draw(minecraft, 75, 12);
        int y = 31;
        int lineHeight = minecraft.field_71466_p.field_78288_b;
        String duration = this.recipe.getOperationDuration() / 20 + " seconds";
        minecraft.field_71466_p.func_78276_b(duration, recipeWidth / 2 - minecraft.field_71466_p.func_78256_a(duration) / 2, y, 0x444444);
        String energyCost = PowerSystem.getLocaliszedPowerFormatted((int)(this.recipe.getEnergyCostPerTick() * this.recipe.getOperationDuration()));
        minecraft.field_71466_p.func_78276_b(energyCost, recipeWidth / 2 - minecraft.field_71466_p.func_78256_a(energyCost) / 2, y + lineHeight + 1, 0x444444);
    }
}

