/*
 * Decompiled with CFR 0.152.
 */
package techreborn.events;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.OreDrop;
import techreborn.init.ModItems;
import techreborn.items.ingredients.ItemDusts;
import techreborn.items.ingredients.ItemGems;
import techreborn.utils.OreDictUtils;

@RebornRegistry(modID="techreborn")
public class BlockBreakHandler {
    @ConfigRegistry(config="compat", category="general", key="secondaryGemDrops", comment="Drop red and yellow garnets and peridot from any harvested oreRuby, oreSapphire, oreSphalerite. False will also disable drop from TechReborn ores.")
    public static boolean secondaryGemDrops = true;
    @ConfigRegistry(config="misc", category="blocks", key="redGarnetDropChance", comment="Chance to get Red Garnet from Ruby Ore")
    public static double redGarnetDropChance = 0.125;
    @ConfigRegistry(config="misc", category="blocks", key="peridotDropChance", comment="Chance to get Peridot from Sapphire Ore")
    public static double peridotDropChance = 0.125;
    @ConfigRegistry(config="misc", category="blocks", key="aluminiumDropChance", comment="Chance to get Aluminium dust from Sodalite Ore")
    public static double aluminiumDropChance = 0.5;
    @ConfigRegistry(config="misc", category="blocks", key="redstoneDropChance", comment="Chance to get Redstone from Cinnabar Ore")
    public static double redstoneDropChance = 0.25;
    @ConfigRegistry(config="misc", category="blocks", key="yellowGarnetDropChance", comment="Chance to get Yellow Garnet gem from Sphalerite Ore")
    public static double yellowGarnetDropChance = 0.125;

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (secondaryGemDrops && !event.isSilkTouching()) {
            IBlockState state = event.getState();
            List drops = event.getDrops();
            Random random = new Random();
            if (OreDictUtils.isOre(state, "oreRuby")) {
                OreDrop redGarnet = new OreDrop(ItemGems.getGemByName("red_garnet"), redGarnetDropChance, 1);
                drops.add(redGarnet.getDrops(event.getFortuneLevel(), random));
            } else if (OreDictUtils.isOre(state, "oreSapphire")) {
                OreDrop peridot = new OreDrop(ItemGems.getGemByName("peridot"), peridotDropChance, 1);
                drops.add(peridot.getDrops(event.getFortuneLevel(), random));
            } else if (OreDictUtils.isOre(state, "oreSodalite")) {
                OreDrop aluminium = new OreDrop(ItemDusts.getDustByName("aluminum"), aluminiumDropChance, 1);
                drops.add(aluminium.getDrops(event.getFortuneLevel(), random));
            } else if (OreDictUtils.isOre(state, "oreCinnabar")) {
                OreDrop redstone = new OreDrop(new ItemStack(Items.field_151137_ax), redstoneDropChance, 1);
                drops.add(redstone.getDrops(event.getFortuneLevel(), random));
            } else if (OreDictUtils.isOre(state, "oreSphalerite")) {
                OreDrop yellowGarnet = new OreDrop(ItemGems.getGemByName("yellowGarnet"), yellowGarnetDropChance, 1);
                drops.add(yellowGarnet.getDrops(event.getFortuneLevel(), random));
            }
        }
    }

    @SubscribeEvent
    public void getBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ModItems.ADVANCED_CHAINSAW && event.getOriginalSpeed() > 1.0f) {
            BlockPos pos = event.getPos();
            World worldIn = event.getEntityPlayer().field_70170_p;
            float speed = 20.0f;
            int blocks = 0;
            for (int i = 1; i < 10; ++i) {
                BlockPos nextPos = pos.func_177981_b(i);
                IBlockState nextState = worldIn.func_180495_p(nextPos);
                if (!nextState.func_177230_c().isWood((IBlockAccess)worldIn, nextPos)) continue;
                ++blocks;
            }
            event.setNewSpeed(speed / (float)blocks);
        }
    }
}

