/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import java.security.InvalidParameterException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import reborncore.api.tile.IUpgrade;
import reborncore.api.tile.IUpgradeable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.IUpgradeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.init.ModItems;
import techreborn.items.ItemTR;
import techreborn.tiles.storage.TileAdjustableSU;

@RebornRegistry(modID="techreborn")
public class ItemUpgrades
extends ItemTR
implements IUpgrade {
    @ConfigRegistry(config="items", category="upgrades", key="overclocker_speed", comment="Overclocker upgrade speed multipiler")
    public static double overclockerSpeed = 0.25;
    @ConfigRegistry(config="items", category="upgrades", key="overclocker_power", comment="Overclocker upgrade power multipiler")
    public static double overclockerPower = 0.75;
    @ConfigRegistry(config="items", category="upgrades", key="energy_storage", comment="Energy storage upgrade extra power")
    public static double energyStoragePower = 40000.0;
    public static final String[] types = new String[]{"overclock", "transformer", "energy_storage", "superconductor"};

    public ItemUpgrades() {
        this.func_77655_b("techreborn.upgrade");
        this.func_77627_a(true);
        this.func_77625_d(16);
    }

    public static ItemStack getUpgradeByName(String name, int count) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModItems.UPGRADES, count, i);
        }
        throw new InvalidParameterException("The upgrade " + name + " could not be found.");
    }

    public static ItemStack getUpgradeByName(String name) {
        return ItemUpgrades.getUpgradeByName(name, 1);
    }

    public String func_77667_c(ItemStack itemStack) {
        int meta = itemStack.func_77952_i();
        if (meta < 0 || meta >= types.length) {
            meta = 0;
        }
        return super.func_77658_a() + "." + types[meta];
    }

    public void func_150895_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTabs)) {
            return;
        }
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack((Item)this, 1, meta));
        }
    }

    public void process(IUpgradeHandler handler, ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            handler.addSpeedMulti(overclockerSpeed);
            handler.addPowerMulti(overclockerPower);
            if (handler instanceof TilePowerAcceptor) {
                TilePowerAcceptor powerAcceptor = (TilePowerAcceptor)handler;
                powerAcceptor.extraPowerInput += powerAcceptor.getMaxInput();
                powerAcceptor.extraPowerStoage += powerAcceptor.getBaseMaxPower();
            }
        }
        if (handler instanceof TilePowerAcceptor) {
            TilePowerAcceptor acceptor;
            if (stack.func_77952_i() == 2) {
                acceptor = (TilePowerAcceptor)handler;
                acceptor.extraPowerStoage += energyStoragePower;
            }
            if (stack.func_77952_i() == 1) {
                acceptor = (TilePowerAcceptor)handler;
                ++acceptor.extraTeir;
            }
        }
        if (handler instanceof TileAdjustableSU) {
            // empty if block
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleRightClick(TileEntity tile, ItemStack stack, Container container, int slotID) {
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77952_i() == 3) {
            tooltip.add(TextFormatting.LIGHT_PURPLE + "Increases the max transfer of the Adjustable SU");
            if (Keyboard.isKeyDown((int)42)) {
                tooltip.add(TextFormatting.GOLD + "Blame obstinate_3 for this");
            }
        }
    }

    public boolean isValidForInventory(IUpgradeable upgradeable, ItemStack stack) {
        if (stack.func_77952_i() == 3) {
            return upgradeable instanceof TileAdjustableSU;
        }
        return true;
    }
}

