/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.tile.RebornMachineTile;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

public class TileTechStorageBase
extends RebornMachineTile
implements IInventoryProvider,
IToolDrop,
IListInfoProvider,
IDeepStorageUnit {
    public final int maxCapacity;
    public final Inventory inventory;
    public InvWrapper invWrapper;
    public ItemStack storedItem;

    public TileTechStorageBase(String name, int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.storedItem = ItemStack.field_190927_a;
        this.inventory = new Inventory(3, name, maxCapacity, (TileEntity)this);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.storedItem = ItemStack.field_190927_a;
        if (tagCompound.func_74764_b("storedStack")) {
            this.storedItem = new ItemStack((NBTTagCompound)tagCompound.func_74781_a("storedStack"));
        }
        if (!this.storedItem.func_190926_b()) {
            this.storedItem.func_190920_e(Math.min(tagCompound.func_74762_e("storedQuantity"), this.maxCapacity));
        }
        this.inventory.readFromNBT(tagCompound);
    }

    public NBTTagCompound writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
        if (!this.storedItem.func_190926_b()) {
            ItemStack temp = this.storedItem.func_77946_l();
            if (this.storedItem.func_190916_E() > this.storedItem.func_77976_d()) {
                temp.func_190920_e(this.storedItem.func_77976_d());
            }
            tagCompound.func_74782_a("storedStack", (NBTBase)temp.func_77955_b(new NBTTagCompound()));
            tagCompound.func_74768_a("storedQuantity", Math.min(this.storedItem.func_190916_E(), this.maxCapacity));
        } else {
            tagCompound.func_74768_a("storedQuantity", 0);
        }
        this.inventory.writeToNBT(tagCompound);
        return tagCompound;
    }

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(this.func_145838_q(), 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.func_77982_d(new NBTTagCompound());
        dropStack.func_77978_p().func_74782_a("tileEntity", (NBTBase)tileEntity);
        this.storedItem.func_190920_e(0);
        this.func_70299_a(1, ItemStack.field_190927_a);
        this.syncWithAll();
        return dropStack;
    }

    public InvWrapper getInvWrapper() {
        if (this.invWrapper == null) {
            this.invWrapper = new InvWrapper((IInventory)this);
        }
        return this.invWrapper;
    }

    public int getStoredCount() {
        return this.storedItem.func_190916_E();
    }

    public List<ItemStack> getContentDrops() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!this.getStoredItemType().func_190926_b()) {
            if (!this.func_70301_a(1).func_190926_b()) {
                stacks.add(this.func_70301_a(1));
            }
            int size = this.storedItem.func_77976_d();
            for (int i = 0; i < this.getStoredCount() / size; ++i) {
                ItemStack droped = this.storedItem.func_77946_l();
                droped.func_190920_e(size);
                stacks.add(droped);
            }
            if (this.getStoredCount() % size != 0) {
                ItemStack droped = this.storedItem.func_77946_l();
                droped.func_190920_e(this.getStoredCount() % size);
                stacks.add(droped);
            }
        }
        return stacks;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack outputStack = ItemStack.field_190927_a;
            if (!this.func_70301_a(1).func_190926_b()) {
                outputStack = this.func_70301_a(1);
            }
            if (!this.func_70301_a(0).func_190926_b() && this.storedItem.func_190916_E() + outputStack.func_190916_E() < this.maxCapacity) {
                ItemStack inputStack = this.func_70301_a(0);
                if (this.getStoredItemType().func_190926_b() || this.storedItem.func_190926_b() && ItemUtils.isItemEqual((ItemStack)inputStack, (ItemStack)outputStack, (boolean)true, (boolean)true)) {
                    this.storedItem = inputStack;
                    this.func_70299_a(0, ItemStack.field_190927_a);
                } else if (ItemUtils.isItemEqual((ItemStack)this.getStoredItemType(), (ItemStack)inputStack, (boolean)true, (boolean)true)) {
                    int reminder = this.maxCapacity - this.storedItem.func_190916_E() - outputStack.func_190916_E();
                    if (inputStack.func_190916_E() <= reminder) {
                        this.setStoredItemCount(inputStack.func_190916_E());
                        this.func_70299_a(0, ItemStack.field_190927_a);
                    } else {
                        this.setStoredItemCount(this.maxCapacity - outputStack.func_190916_E());
                        this.func_70301_a(0).func_190918_g(reminder);
                    }
                }
                this.func_70296_d();
                this.syncWithAll();
            }
            if (!this.storedItem.func_190926_b()) {
                if (outputStack.func_190926_b()) {
                    ItemStack delivered = this.storedItem.func_77946_l();
                    delivered.func_190920_e(Math.min(this.storedItem.func_190916_E(), delivered.func_77976_d()));
                    this.storedItem.func_190918_g(delivered.func_190916_E());
                    if (this.storedItem.func_190926_b()) {
                        this.storedItem = ItemStack.field_190927_a;
                    }
                    this.func_70299_a(1, delivered);
                    this.func_70296_d();
                    this.syncWithAll();
                } else if (ItemUtils.isItemEqual((ItemStack)this.storedItem, (ItemStack)outputStack, (boolean)true, (boolean)true) && outputStack.func_190916_E() < outputStack.func_77976_d()) {
                    int wanted = Math.min(this.storedItem.func_190916_E(), outputStack.func_77976_d() - outputStack.func_190916_E());
                    outputStack.func_190920_e(outputStack.func_190916_E() + wanted);
                    this.storedItem.func_190918_g(wanted);
                    if (this.storedItem.func_190926_b()) {
                        this.storedItem = ItemStack.field_190927_a;
                    }
                    this.func_70296_d();
                    this.syncWithAll();
                }
            }
        }
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readFromNBTWithoutCoords(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.writeToNBTWithoutCoords(tagCompound);
        return tagCompound;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getInvWrapper());
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return this.getDropWithNBT();
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        if (isRealTile) {
            int size = 0;
            String name = "of nothing";
            if (!this.storedItem.func_190926_b()) {
                name = this.storedItem.func_82833_r();
                size += this.storedItem.func_190916_E();
            }
            if (!this.func_70301_a(1).func_190926_b()) {
                name = this.func_70301_a(1).func_82833_r();
                size += this.func_70301_a(1).func_190916_E();
            }
            info.add(size + " " + name);
        }
    }

    public ItemStack getStoredItemType() {
        return this.storedItem.func_190926_b() ? this.func_70301_a(1) : this.storedItem;
    }

    public void setStoredItemCount(int amount) {
        this.storedItem.func_190917_f(amount);
        this.func_70296_d();
    }

    public void setStoredItemType(ItemStack type, int amount) {
        this.storedItem = type;
        this.storedItem.func_190920_e(amount);
        this.func_70296_d();
    }

    public int getMaxStoredCount() {
        return this.maxCapacity;
    }
}

