/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.api.IToolDrop;
import reborncore.common.blocks.RebornMachineBlock;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.WorldUtils;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TilePlayerDectector
extends TilePowerAcceptor
implements IToolDrop {
    @ConfigRegistry(config="machines", category="player_detector", key="PlayerDetectorMaxInput", comment="Player Detector Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="player_detector", key="PlayerDetectorMaxEnergy", comment="Player Detector Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    @ConfigRegistry(config="machines", category="player_detector", key="PlayerDetectorEUPerSecond", comment="Player Detector Energy Consumption per second (Value in EU)")
    public static int euPerTick = 10;
    public String owenerUdid = "";
    boolean redstone = false;

    public boolean isProvidingPower() {
        return this.redstone;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_72820_D() % 20L == 0L) {
            boolean lastRedstone = this.redstone;
            this.redstone = false;
            if (this.canUseEnergy(euPerTick)) {
                for (EntityPlayer player : this.field_145850_b.field_73010_i) {
                    if (!(player.func_70092_e((double)super.func_174877_v().func_177958_n() + 0.5, (double)super.func_174877_v().func_177956_o() + 0.5, (double)super.func_174877_v().func_177952_p() + 0.5) <= 256.0)) continue;
                    RebornMachineBlock blockMachineBase = (RebornMachineBlock)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
                    int meta = blockMachineBase.func_176201_c(this.field_145850_b.func_180495_p(this.field_174879_c));
                    if (meta == 0) {
                        this.redstone = true;
                        continue;
                    }
                    if (meta == 1) {
                        if (this.owenerUdid.isEmpty() || this.owenerUdid.equals(player.func_110124_au().toString())) continue;
                        this.redstone = true;
                        continue;
                    }
                    if (this.owenerUdid.isEmpty() || !this.owenerUdid.equals(player.func_110124_au().toString())) continue;
                    this.redstone = true;
                }
                this.useEnergy(euPerTick);
            }
            if (lastRedstone != this.redstone) {
                WorldUtils.updateBlock((World)this.field_145850_b, (BlockPos)this.field_174879_c);
                this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
            }
        }
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.owenerUdid = tag.func_74779_i("ownerID");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74778_a("ownerID", this.owenerUdid);
        return tag;
    }

    public ItemStack getToolDrop(EntityPlayer p0) {
        return new ItemStack(ModBlocks.PLAYER_DETECTOR, 1, 0);
    }
}

