/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blocks.RebornMachineBlock;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.RebornMachineTile;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.RollingMachineRecipe;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileRollingMachine
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="rolling_machine", key="RollingMachineMaxInput", comment="Rolling Machine Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="rolling_machine", key="RollingMachineEnergyPerTick", comment="Rolling Machine Energy Per Tick (Value in EU)")
    public static int energyPerTick = 5;
    @ConfigRegistry(config="machines", category="rolling_machine", key="RollingMachineEnergyRunTime", comment="Rolling Machine Run Time")
    public static int runTime = 250;
    @ConfigRegistry(config="machines", category="rolling_machine", key="RollingMachineMaxEnergy", comment="Rolling Machine Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    public int[] craftingSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private InventoryCrafting craftCache;
    public Inventory inventory = new Inventory(12, "TileRollingMachine", 64, (TileEntity)this);
    public boolean isRunning;
    public int tickTime;
    @Nonnull
    public ItemStack currentRecipeOutput;
    public IRecipe currentRecipe;
    private int outputSlot = 9;
    public boolean locked = false;
    public int balanceSlot = 0;

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.charge(10);
        InventoryCrafting craftMatrix = this.getCraftingMatrix();
        this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(craftMatrix, this.field_145850_b);
        if (this.currentRecipe != null) {
            Optional<InventoryCrafting> balanceResult;
            this.setIsActive(true);
            if (this.field_145850_b.func_82737_E() % 2L == 0L && (balanceResult = this.balanceRecipe(craftMatrix)).isPresent()) {
                craftMatrix = balanceResult.get();
            }
            this.currentRecipeOutput = this.currentRecipe.func_77572_b(craftMatrix);
        } else {
            this.currentRecipeOutput = ItemStack.field_190927_a;
        }
        if (!this.currentRecipeOutput.func_190926_b() && this.canMake(craftMatrix)) {
            if (this.tickTime >= Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1)) {
                this.currentRecipeOutput = RollingMachineRecipe.instance.findMatchingRecipeOutput(craftMatrix, this.field_145850_b);
                if (!this.currentRecipeOutput.func_190926_b()) {
                    boolean hasCrafted = false;
                    if (this.inventory.func_70301_a(this.outputSlot).func_190926_b()) {
                        this.inventory.func_70299_a(this.outputSlot, this.currentRecipeOutput);
                        this.tickTime = 0;
                        hasCrafted = true;
                    } else if (this.inventory.func_70301_a(this.outputSlot).func_190916_E() + this.currentRecipeOutput.func_190916_E() <= this.currentRecipeOutput.func_77976_d()) {
                        ItemStack stack = this.inventory.func_70301_a(this.outputSlot);
                        stack.func_190920_e(stack.func_190916_E() + this.currentRecipeOutput.func_190916_E());
                        this.inventory.func_70299_a(this.outputSlot, stack);
                        this.tickTime = 0;
                        hasCrafted = true;
                    } else {
                        this.setIsActive(false);
                    }
                    if (hasCrafted) {
                        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                            this.inventory.func_70298_a(i, 1);
                        }
                        this.currentRecipeOutput = ItemStack.field_190927_a;
                        this.currentRecipe = null;
                    }
                }
            }
        } else {
            this.tickTime = 0;
        }
        if (!this.currentRecipeOutput.func_190926_b()) {
            if (this.canUseEnergy(this.getEuPerTick(energyPerTick)) && this.tickTime < Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1) && this.canMake(craftMatrix)) {
                this.useEnergy(this.getEuPerTick(energyPerTick));
                ++this.tickTime;
            } else {
                this.setIsActive(false);
            }
        }
        if (this.currentRecipeOutput.func_190926_b()) {
            this.tickTime = 0;
            this.currentRecipe = null;
            this.setIsActive(this.canMake(this.getCraftingMatrix()));
        }
    }

    public void setIsActive(boolean active) {
        if (active == this.isRunning) {
            return;
        }
        this.isRunning = active;
        if (this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() instanceof RebornMachineBlock) {
            this.setActive(active);
        }
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public Optional<InventoryCrafting> balanceRecipe(InventoryCrafting craftCache) {
        ItemStack sourceStack;
        if (this.currentRecipe == null) {
            return Optional.empty();
        }
        if (this.field_145850_b.field_72995_K) {
            return Optional.empty();
        }
        if (!this.locked) {
            return Optional.empty();
        }
        if (craftCache.func_191420_l()) {
            return Optional.empty();
        }
        ++this.balanceSlot;
        if (this.balanceSlot > craftCache.func_70302_i_()) {
            this.balanceSlot = 0;
        }
        if ((sourceStack = this.inventory.func_70301_a(this.balanceSlot)).func_190926_b()) {
            return Optional.empty();
        }
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>();
        for (int s = 0; s < this.currentRecipe.func_192400_c().size(); ++s) {
            ItemStack stackInSlot = this.inventory.func_70301_a(s);
            Ingredient ingredient = (Ingredient)this.currentRecipe.func_192400_c().get(s);
            if (ingredient == Ingredient.field_193370_a || !ingredient.apply(sourceStack)) continue;
            if (stackInSlot.func_190926_b()) {
                possibleSlots.add(s);
                continue;
            }
            if (stackInSlot.func_77973_b() != sourceStack.func_77973_b() || stackInSlot.func_77952_i() != sourceStack.func_77952_i()) continue;
            possibleSlots.add(s);
        }
        if (!possibleSlots.isEmpty()) {
            int totalItems = possibleSlots.stream().mapToInt(value -> this.inventory.func_70301_a(value.intValue()).func_190916_E()).sum();
            int slots = possibleSlots.size();
            int[] split = new int[slots];
            int remainder = totalItems % slots;
            Arrays.fill(split, totalItems / slots);
            while (remainder > 0) {
                for (int i = 0; i < split.length; ++i) {
                    if (remainder <= 0) continue;
                    int n = i;
                    split[n] = split[n] + 1;
                    --remainder;
                }
            }
            List slotDistrubution = possibleSlots.stream().mapToInt(value -> this.inventory.func_70301_a(value.intValue()).func_190916_E()).boxed().collect(Collectors.toList());
            boolean needsBalance = false;
            for (int i = 0; i < split.length; ++i) {
                int required = split[i];
                if (slotDistrubution.contains(required)) {
                    slotDistrubution.remove(new Integer(required));
                    continue;
                }
                needsBalance = true;
            }
            if (!needsBalance) {
                return Optional.empty();
            }
        } else {
            return Optional.empty();
        }
        Pair bestSlot = null;
        for (Integer slot : possibleSlots) {
            ItemStack slotStack = this.inventory.func_70301_a(slot.intValue());
            if (slotStack.func_190926_b()) {
                bestSlot = Pair.of((Object)slot, (Object)0);
            }
            if (bestSlot == null) {
                bestSlot = Pair.of((Object)slot, (Object)slotStack.func_190916_E());
                continue;
            }
            if ((Integer)bestSlot.getRight() < slotStack.func_190916_E()) continue;
            bestSlot = Pair.of((Object)slot, (Object)slotStack.func_190916_E());
        }
        if (bestSlot == null || (Integer)bestSlot.getLeft() == this.balanceSlot || ((Integer)bestSlot.getRight()).intValue() == sourceStack.func_190916_E() || this.inventory.func_70301_a(((Integer)bestSlot.getLeft()).intValue()).func_190926_b() || !ItemUtils.isItemEqual((ItemStack)sourceStack, (ItemStack)this.inventory.func_70301_a(((Integer)bestSlot.getLeft()).intValue()), (boolean)true, (boolean)true, (boolean)true)) {
            return Optional.empty();
        }
        sourceStack.func_190918_g(1);
        this.inventory.func_70301_a(((Integer)bestSlot.getLeft()).intValue()).func_190917_f(1);
        this.inventory.hasChanged = true;
        return Optional.of(this.getCraftingMatrix());
    }

    private InventoryCrafting getCraftingMatrix() {
        if (this.craftCache == null) {
            this.craftCache = new InventoryCrafting((Container)new RollingTileContainer(), 3, 3);
        }
        if (this.inventory.hasChanged) {
            for (int i = 0; i < 9; ++i) {
                this.craftCache.func_70299_a(i, this.inventory.func_70301_a(i).func_77946_l());
            }
            this.inventory.hasChanged = false;
        }
        return this.craftCache;
    }

    public boolean canMake(InventoryCrafting craftMatrix) {
        ItemStack stack = RollingMachineRecipe.instance.findMatchingRecipeOutput(craftMatrix, this.field_145850_b);
        if (this.locked) {
            for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                ItemStack stack1 = craftMatrix.func_70301_a(i);
                if (stack1.func_190926_b() || stack1.func_190916_E() >= 2) continue;
                return false;
            }
        }
        if (stack.func_190926_b()) {
            return false;
        }
        ItemStack output = this.func_70301_a(this.outputSlot);
        if (output.func_190926_b()) {
            return true;
        }
        return ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)output, (boolean)true, (boolean)true);
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ROLLING_MACHINE, 1);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.isRunning = tagCompound.func_74767_n("isRunning");
        this.tickTime = tagCompound.func_74762_e("tickTime");
        this.locked = tagCompound.func_74767_n("locked");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("isRunning", this.isRunning);
        tagCompound.func_74768_a("tickTime", this.tickTime);
        tagCompound.func_74757_a("locked", this.locked);
        return tagCompound;
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.tickTime;
    }

    public void setBurnTime(int burnTime) {
        this.tickTime = burnTime;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.tickTime == 0 || Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1) == 0) {
            return 0;
        }
        return this.tickTime * scale / Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1);
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("rollingmachine").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 30, 22).slot(1, 48, 22).slot(2, 66, 22).slot(3, 30, 40).slot(4, 48, 40).slot(5, 66, 40).slot(6, 30, 58).slot(7, 48, 58).slot(8, 66, 58).onCraft(inv -> this.inventory.func_70299_a(1, RollingMachineRecipe.instance.findMatchingRecipeOutput(this.getCraftingMatrix(), this.field_145850_b))).outputSlot(9, 124, 40).energySlot(10, 8, 70).syncEnergyValue().syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getLockedInt, this::setLockedInt).addInventory().create((RebornMachineTile)this);
    }

    public int getLockedInt() {
        return this.locked ? 1 : 0;
    }

    public void setLockedInt(int lockedInt) {
        this.locked = lockedInt == 1;
    }

    public int getProgressScaled(int scale) {
        if (this.tickTime != 0 && Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1) != 0) {
            return this.tickTime * scale / Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1);
        }
        return 0;
    }

    public boolean canBeUpgraded() {
        return true;
    }

    private static class RollingTileContainer
    extends Container {
        private RollingTileContainer() {
        }

        public boolean func_75145_c(EntityPlayer entityplayer) {
            return true;
        }
    }
}

