/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.modules;

import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.command.CommandModule;
import me.lucko.spark.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.common.monitor.cpu.CpuMonitor;
import me.lucko.spark.common.monitor.tick.TickStatistics;
import me.lucko.spark.common.util.FormatUtil;
import me.lucko.spark.common.util.RollingAverage;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.TextColor;
import me.lucko.spark.lib.adventure.text.format.TextDecoration;

public class HealthModule
implements CommandModule {
    private static final int MSPT_95_PERCENTILE = 95;

    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("tps", "cpu").executor((platform, sender, resp, arguments) -> {
            TickStatistics tickStatistics = platform.getTickStatistics();
            if (tickStatistics != null) {
                resp.replyPrefixed(Component.text("TPS from last 5s, 10s, 1m, 5m, 15m:"));
                resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(" ").append((Component)HealthModule.formatTps(tickStatistics.tps5Sec()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatTps(tickStatistics.tps10Sec()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatTps(tickStatistics.tps1Min()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatTps(tickStatistics.tps5Min()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatTps(tickStatistics.tps15Min()))).build());
                resp.replyPrefixed(Component.empty());
                if (tickStatistics.isDurationSupported()) {
                    resp.replyPrefixed(Component.text("Tick durations (min/med/95%ile/max ms) from last 10s, 1m:"));
                    resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(" ").append((Component)HealthModule.formatTickDurations(tickStatistics.duration10Sec()))).append((Component)Component.text(";  "))).append((Component)HealthModule.formatTickDurations(tickStatistics.duration1Min()))).build());
                    resp.replyPrefixed(Component.empty());
                }
            }
            resp.replyPrefixed(Component.text("CPU usage from last 10s, 1m, 15m:"));
            resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(" ").append((Component)HealthModule.formatCpuUsage(CpuMonitor.systemLoad10SecAvg()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatCpuUsage(CpuMonitor.systemLoad1MinAvg()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatCpuUsage(CpuMonitor.systemLoad15MinAvg()))).append((Component)Component.text("  (system)", (TextColor)NamedTextColor.DARK_GRAY))).build());
            resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(" ").append((Component)HealthModule.formatCpuUsage(CpuMonitor.processLoad10SecAvg()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatCpuUsage(CpuMonitor.processLoad1MinAvg()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatCpuUsage(CpuMonitor.processLoad15MinAvg()))).append((Component)Component.text("  (process)", (TextColor)NamedTextColor.DARK_GRAY))).build());
        }).tabCompleter(Command.TabCompleter.empty()).build());
        consumer.accept(Command.builder().aliases("healthreport", "health", "ht").argumentUsage("memory", null).executor((platform, sender, resp, arguments) -> {
            resp.replyPrefixed(Component.text("Generating server health report..."));
            platform.getPlugin().executeAsync(() -> {
                LinkedList<Object> report = new LinkedList<Object>();
                report.add(Component.empty());
                TickStatistics tickStatistics = platform.getTickStatistics();
                if (tickStatistics != null) {
                    report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("TPS from last 5s, 10s, 1m, 5m, 15m:", (TextColor)NamedTextColor.GOLD))).build());
                    report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)HealthModule.formatTps(tickStatistics.tps5Sec()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatTps(tickStatistics.tps10Sec()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatTps(tickStatistics.tps1Min()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatTps(tickStatistics.tps5Min()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatTps(tickStatistics.tps15Min()))).build());
                    report.add(Component.empty());
                    if (tickStatistics.isDurationSupported()) {
                        report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("Tick durations (min/med/95%ile/max ms) from last 10s, 1m:", (TextColor)NamedTextColor.GOLD))).build());
                        report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)HealthModule.formatTickDurations(tickStatistics.duration10Sec()))).append((Component)Component.text("; "))).append((Component)HealthModule.formatTickDurations(tickStatistics.duration1Min()))).build());
                        report.add(Component.empty());
                    }
                }
                report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("CPU usage from last 10s, 1m, 15m:", (TextColor)NamedTextColor.GOLD))).build());
                report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)HealthModule.formatCpuUsage(CpuMonitor.systemLoad10SecAvg()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatCpuUsage(CpuMonitor.systemLoad1MinAvg()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatCpuUsage(CpuMonitor.systemLoad15MinAvg()))).append((Component)Component.text("  (system)", (TextColor)NamedTextColor.DARK_GRAY))).build());
                report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)HealthModule.formatCpuUsage(CpuMonitor.processLoad10SecAvg()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatCpuUsage(CpuMonitor.processLoad1MinAvg()))).append((Component)Component.text(", "))).append((Component)HealthModule.formatCpuUsage(CpuMonitor.processLoad15MinAvg()))).append((Component)Component.text("  (process)", (TextColor)NamedTextColor.DARK_GRAY))).build());
                report.add(Component.empty());
                MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                MemoryUsage heapUsage = memoryMXBean.getHeapMemoryUsage();
                report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("Memory usage:", (TextColor)NamedTextColor.GOLD))).build());
                report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(FormatUtil.formatBytes(heapUsage.getUsed()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("/", (TextColor)NamedTextColor.GRAY))).append((Component)Component.space())).append((Component)Component.text(FormatUtil.formatBytes(heapUsage.getMax()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text("   "))).append((Component)Component.text("(", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text(FormatUtil.percent(heapUsage.getUsed(), heapUsage.getMax()), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(")", (TextColor)NamedTextColor.GRAY))).build());
                report.add(((TextComponent.Builder)Component.text().content("    ").append((Component)HealthModule.generateMemoryUsageDiagram(heapUsage, 40))).build());
                report.add(Component.empty());
                if (arguments.boolFlag("memory")) {
                    MemoryUsage nonHeapUsage = memoryMXBean.getNonHeapMemoryUsage();
                    report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("Non-heap memory usage:", (TextColor)NamedTextColor.GOLD))).build());
                    report.add(((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(FormatUtil.formatBytes(nonHeapUsage.getUsed()), (TextColor)NamedTextColor.WHITE))).build());
                    report.add(Component.empty());
                    List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
                    for (MemoryPoolMXBean memoryPool : memoryPoolMXBeans) {
                        if (memoryPool.getType() != MemoryType.HEAP) continue;
                        MemoryUsage usage = memoryPool.getUsage();
                        MemoryUsage collectionUsage = memoryPool.getCollectionUsage();
                        if (usage.getMax() == -1L) {
                            usage = new MemoryUsage(usage.getInit(), usage.getUsed(), usage.getCommitted(), usage.getCommitted());
                        }
                        report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text(memoryPool.getName() + " pool usage:", (TextColor)NamedTextColor.GOLD))).build());
                        report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(FormatUtil.formatBytes(usage.getUsed()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("/", (TextColor)NamedTextColor.GRAY))).append((Component)Component.space())).append((Component)Component.text(FormatUtil.formatBytes(usage.getMax()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text("   "))).append((Component)Component.text("(", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text(FormatUtil.percent(usage.getUsed(), usage.getMax()), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(")", (TextColor)NamedTextColor.GRAY))).build());
                        report.add(((TextComponent.Builder)Component.text().content("    ").append((Component)HealthModule.generateMemoryPoolDiagram(usage, collectionUsage, 40))).build());
                        if (collectionUsage != null) {
                            report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("     ").append((Component)Component.text("-", (TextColor)NamedTextColor.RED))).append((Component)Component.space())).append((Component)Component.text("Usage at last GC:", (TextColor)NamedTextColor.GRAY))).append((Component)Component.space())).append((Component)Component.text(FormatUtil.formatBytes(collectionUsage.getUsed()), (TextColor)NamedTextColor.WHITE))).build());
                        }
                        report.add(Component.empty());
                    }
                }
                try {
                    FileStore fileStore = Files.getFileStore(Paths.get(".", new String[0]));
                    long totalSpace = fileStore.getTotalSpace();
                    long usedSpace = totalSpace - fileStore.getUsableSpace();
                    report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("Disk usage:", (TextColor)NamedTextColor.GOLD))).build());
                    report.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append((Component)Component.text(FormatUtil.formatBytes(usedSpace), (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("/", (TextColor)NamedTextColor.GRAY))).append((Component)Component.space())).append((Component)Component.text(FormatUtil.formatBytes(totalSpace), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text("   "))).append((Component)Component.text("(", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text(FormatUtil.percent(usedSpace, totalSpace), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(")", (TextColor)NamedTextColor.GRAY))).build());
                    report.add(((TextComponent.Builder)Component.text().content("    ").append((Component)HealthModule.generateDiskUsageDiagram(usedSpace, totalSpace, 40))).build());
                    report.add(Component.empty());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                report.forEach(resp::reply);
            });
        }).tabCompleter((platform, sender, arguments) -> TabCompleter.completeForOpts(arguments, "--memory")).build());
    }

    public static TextComponent formatTps(double tps) {
        NamedTextColor color = tps > 18.0 ? NamedTextColor.GREEN : (tps > 16.0 ? NamedTextColor.YELLOW : NamedTextColor.RED);
        return Component.text((tps > 20.0 ? "*" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0), (TextColor)color);
    }

    public static TextComponent formatTickDurations(RollingAverage average) {
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)HealthModule.formatTickDuration(average.getMin()))).append((Component)Component.text('/', (TextColor)NamedTextColor.GRAY))).append((Component)HealthModule.formatTickDuration(average.getMedian()))).append((Component)Component.text('/', (TextColor)NamedTextColor.GRAY))).append((Component)HealthModule.formatTickDuration(average.getPercentile(95)))).append((Component)Component.text('/', (TextColor)NamedTextColor.GRAY))).append((Component)HealthModule.formatTickDuration(average.getMax()))).build();
    }

    public static TextComponent formatTickDuration(double duration) {
        NamedTextColor color = duration >= 50.0 ? NamedTextColor.RED : (duration >= 40.0 ? NamedTextColor.YELLOW : NamedTextColor.GREEN);
        return Component.text(String.format("%.1f", duration), (TextColor)color);
    }

    public static TextComponent formatCpuUsage(double usage) {
        NamedTextColor color = usage > 0.9 ? NamedTextColor.RED : (usage > 0.65 ? NamedTextColor.YELLOW : NamedTextColor.GREEN);
        return Component.text(FormatUtil.percent(usage, 1.0), (TextColor)color);
    }

    private static TextComponent generateMemoryUsageDiagram(MemoryUsage usage, int length) {
        double used = usage.getUsed();
        double committed = usage.getCommitted();
        double max = usage.getMax();
        int usedChars = (int)(used * (double)length / max);
        int committedChars = (int)(committed * (double)length / max);
        TextComponent.Builder line = (TextComponent.Builder)Component.text().content(Strings.repeat((String)"/", (int)usedChars)).color(NamedTextColor.GRAY);
        if (committedChars > usedChars) {
            line.append((Component)Component.text(Strings.repeat((String)" ", (int)(committedChars - usedChars - 1))));
            line.append((Component)Component.text("|", (TextColor)NamedTextColor.YELLOW));
        }
        if (length > committedChars) {
            line.append((Component)Component.text(Strings.repeat((String)" ", (int)(length - committedChars))));
        }
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("[", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)line.build())).append((Component)Component.text("]", (TextColor)NamedTextColor.DARK_GRAY))).build();
    }

    private static TextComponent generateMemoryPoolDiagram(MemoryUsage usage, MemoryUsage collectionUsage, int length) {
        double used;
        double collectionUsed = used = (double)usage.getUsed();
        if (collectionUsage != null) {
            collectionUsed = collectionUsage.getUsed();
        }
        double committed = usage.getCommitted();
        double max = usage.getMax();
        int usedChars = (int)(used * (double)length / max);
        int collectionUsedChars = (int)(collectionUsed * (double)length / max);
        int committedChars = (int)(committed * (double)length / max);
        TextComponent.Builder line = (TextComponent.Builder)Component.text().content(Strings.repeat((String)"/", (int)collectionUsedChars)).color(NamedTextColor.GRAY);
        if (usedChars > collectionUsedChars) {
            line.append((Component)Component.text("|", (TextColor)NamedTextColor.RED));
            line.append((Component)Component.text(Strings.repeat((String)"/", (int)(usedChars - collectionUsedChars - 1)), (TextColor)NamedTextColor.GRAY));
        }
        if (committedChars > usedChars) {
            line.append((Component)Component.text(Strings.repeat((String)" ", (int)(committedChars - usedChars - 1))));
            line.append((Component)Component.text("|", (TextColor)NamedTextColor.YELLOW));
        }
        if (length > committedChars) {
            line.append((Component)Component.text(Strings.repeat((String)" ", (int)(length - committedChars))));
        }
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("[", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)line.build())).append((Component)Component.text("]", (TextColor)NamedTextColor.DARK_GRAY))).build();
    }

    private static TextComponent generateDiskUsageDiagram(double used, double max, int length) {
        int usedChars = (int)(used * (double)length / max);
        String line = Strings.repeat((String)"/", (int)usedChars) + Strings.repeat((String)" ", (int)(length - usedChars));
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("[", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(line, (TextColor)NamedTextColor.GRAY))).append((Component)Component.text("]", (TextColor)NamedTextColor.DARK_GRAY))).build();
    }
}

