/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.block;

import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Transportation;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTransportationStone
extends Block {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);

    public BlockTransportationStone(Material material) {
        super(material);
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP, false)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISpellCastingItem && WizardData.get(player) != null) {
            WizardData data = WizardData.get(player);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, 0, z);
                    if (!BlockTransportationStone.testForCircle(world, pos1)) continue;
                    Location here = new Location(pos1, player.field_71093_bK);
                    List<Location> locations = data.getVariable(Transportation.LOCATIONS_KEY);
                    if (locations == null) {
                        locations = new ArrayList<Location>(4);
                        data.setVariable(Transportation.LOCATIONS_KEY, locations);
                    }
                    if (ItemArtefact.isArtefactActive(player, WizardryItems.charm_transportation)) {
                        if (locations.contains(here)) {
                            locations.remove(here);
                            if (!world.field_72995_K) {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.ebwizardry:transportation_stone.forget", new Object[]{here.pos.func_177958_n(), here.pos.func_177956_o(), here.pos.func_177952_p(), here.dimension}), true);
                            }
                        } else {
                            locations.add(here);
                            if (!world.field_72995_K) {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.ebwizardry:transportation_stone.remember", new Object[]{here.pos.func_177958_n(), here.pos.func_177956_o(), here.pos.func_177952_p(), here.dimension}), true);
                            }
                            if (locations.size() > 4) {
                                Location removed = locations.remove(0);
                                if (!world.field_72995_K) {
                                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.ebwizardry:transportation_stone.forget", new Object[]{removed.pos.func_177958_n(), removed.pos.func_177956_o(), removed.pos.func_177952_p(), removed.dimension}), true);
                                }
                            }
                        }
                    } else {
                        if (locations.isEmpty()) {
                            locations.add(here);
                        } else {
                            locations.remove(here);
                            if (locations.isEmpty()) {
                                locations.add(here);
                            } else {
                                locations.set(Math.max(locations.size() - 1, 0), here);
                            }
                        }
                        if (!world.field_72995_K) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.ebwizardry:transportation_stone.confirm", new Object[]{Spells.transportation.getNameForTranslationFormatted()}), true);
                        }
                    }
                    return true;
                }
            }
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.ebwizardry:transportation_stone.invalid", new Object[0]), true);
            } else {
                BlockPos centre = BlockTransportationStone.findMostLikelyCircle(world, pos);
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0) continue;
                        ParticleBuilder.create(ParticleBuilder.Type.PATH).pos(GeometryUtils.getCentre(centre).func_72441_c((double)x, -0.3125, (double)z)).clr(8847205).time(200).scale(2.0f).spawn(world);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static boolean testForCircle(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76230_c() || world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76230_c()) {
            return false;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0 || world.func_180495_p(pos.func_177982_a(x, 0, z)).func_177230_c() == WizardryBlocks.transportation_stone) continue;
                return false;
            }
        }
        return true;
    }

    private static BlockPos findMostLikelyCircle(World world, BlockPos pos) {
        int bestSoFar = 0;
        BlockPos result = null;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos pos1;
                int n;
                if (x == 0 && z == 0 || (n = BlockTransportationStone.getCircleCompleteness(world, pos1 = pos.func_177982_a(x, 0, z))) <= bestSoFar) continue;
                bestSoFar = n;
                result = pos1;
            }
        }
        return result;
    }

    private static int getCircleCompleteness(World world, BlockPos pos) {
        int n = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0 || world.func_180495_p(pos.func_177982_a(x, 0, z)).func_177230_c() != WizardryBlocks.transportation_stone) continue;
                ++n;
            }
        }
        return n;
    }
}

