/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.animation;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.animation.Animation;
import electroblob.wizardry.client.animation.ModelRendererExtended;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.JavaUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class PlayerAnimator {
    private static final List<Animation> animations = new ArrayList<Animation>();
    private static final Map<RenderPlayer, List<LayerRenderer<? extends EntityLivingBase>>> playerLayers = new HashMap<RenderPlayer, List<LayerRenderer<? extends EntityLivingBase>>>();
    private static final Map<RenderPlayer, List<ModelBiped>> playerLayerModels = new HashMap<RenderPlayer, List<ModelBiped>>();
    private static final Field layerRenderers = ObfuscationReflectionHelper.findField(RenderLivingBase.class, (String)"field_177097_h");
    private static boolean overridden;

    public static void registerAnimation(Animation animation) {
        if (animations.contains(animation)) {
            Wizardry.logger.warn("Animation {} is already registered!", (Object)animation.getName());
        } else {
            animations.add(animation);
        }
    }

    public static boolean areAnimationsEnabled() {
        return Wizardry.settings.spellcastingAnimations && !overridden;
    }

    public static void init() {
        if (Loader.isModLoaded((String)"mobends")) {
            overridden = true;
        }
        if (!PlayerAnimator.areAnimationsEnabled()) {
            return;
        }
        for (RenderPlayer renderer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            PlayerAnimator.loadLayersForRenderer(renderer);
        }
    }

    private static void loadLayersForRenderer(RenderPlayer renderer) {
        ArrayList<Object> models = new ArrayList<Object>();
        ModelRendererExtended.wrap((ModelBiped)renderer.func_177087_b());
        models.add(renderer.func_177087_b());
        try {
            List layers = (List)layerRenderers.get(renderer);
            playerLayers.put(renderer, layers.stream().filter(l -> l instanceof LayerBipedArmor).collect(Collectors.toList()));
            for (LayerRenderer layer : layers) {
                for (Field field : JavaUtils.getAllFields(layer.getClass())) {
                    field.setAccessible(true);
                    if (!(field.get(layer) instanceof ModelBiped)) continue;
                    ModelBiped model = (ModelBiped)field.get(layer);
                    ModelRendererExtended.wrap(model);
                    models.add(model);
                }
            }
        }
        catch (IllegalAccessException e) {
            Wizardry.logger.error("Error during reflective access of render layers: ", (Throwable)e);
        }
        playerLayerModels.put(renderer, models);
    }

    private static void updateModels(EntityPlayer player, Render<?> renderer, float partialTicks, boolean firstPerson) {
        List<ModelBiped> models;
        if (renderer instanceof RenderPlayer && !playerLayerModels.containsKey(renderer)) {
            PlayerAnimator.loadLayersForRenderer((RenderPlayer)renderer);
        }
        if ((models = playerLayerModels.get(renderer)) != null) {
            List<LayerRenderer<? extends EntityLivingBase>> layers = playerLayers.get(renderer);
            if (layers != null) {
                for (LayerRenderer layerRenderer : layers) {
                    if (!(layerRenderer instanceof LayerBipedArmor)) continue;
                    for (EntityEquipmentSlot slot : InventoryUtils.ARMOUR_SLOTS) {
                        ItemStack armour = player.func_184582_a(slot);
                        ModelBiped model = ForgeHooksClient.getArmorModel((EntityLivingBase)player, (ItemStack)armour, (EntityEquipmentSlot)slot, (ModelBiped)((ModelBiped)((LayerBipedArmor)layerRenderer).func_188360_a(slot)));
                        if (models.contains(model)) continue;
                        models.add(model);
                        ModelRendererExtended.wrap(model);
                    }
                }
            }
            for (Animation animation : animations) {
                if (!animation.shouldDisplay(player, firstPerson)) continue;
                boolean autoRotateSecondLayer = animation.autoRotateSecondLayer(player, firstPerson);
                for (ModelBiped model : models) {
                    if (!ModelRendererExtended.isWrapped(model)) continue;
                    animation.setRotationAngles(player, model, partialTicks, firstPerson);
                    if (!autoRotateSecondLayer || !(model instanceof ModelPlayer)) continue;
                    PlayerAnimator.alignSecondLayer((ModelPlayer)model);
                }
            }
        }
    }

    public static void alignSecondLayer(ModelPlayer model) {
        ((ModelRendererExtended)model.field_178730_v).setRotationTo((ModelRendererExtended)model.field_78115_e);
        ((ModelRendererExtended)model.field_178732_b).setRotationTo((ModelRendererExtended)model.field_178723_h);
        ((ModelRendererExtended)model.field_178734_a).setRotationTo((ModelRendererExtended)model.field_178724_i);
        ((ModelRendererExtended)model.field_178731_d).setRotationTo((ModelRendererExtended)model.field_78115_e);
        ((ModelRendererExtended)model.field_178733_c).setRotationTo((ModelRendererExtended)model.field_78115_e);
    }

    @SubscribeEvent
    public static void onRenderHandEvent(RenderSpecificHandEvent event) {
        if (!PlayerAnimator.areAnimationsEnabled()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        EnumAction action = event.getItemStack().func_77975_n();
        if (player.func_184587_cr() && player.func_184600_cs() == event.getHand() && SpellActions.getSpellActions().contains(action)) {
            int i = player.func_184591_cq() == EnumHandSide.RIGHT == (event.getHand() == EnumHand.MAIN_HAND) ? 1 : -1;
            GlStateManager.func_179109_b((float)((float)i * 0.56f), (float)(-0.52f + event.getEquipProgress() * -0.6f), (float)-0.72f);
        }
        PlayerAnimator.updateModels((EntityPlayer)player, Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)player), event.getPartialTicks(), true);
    }

    @SubscribeEvent
    public static void onRenderPlayerPreEvent(RenderPlayerEvent.Pre event) {
        if (!PlayerAnimator.areAnimationsEnabled()) {
            return;
        }
        PlayerAnimator.updateModels(event.getEntityPlayer(), event.getRenderer(), event.getPartialRenderTick(), false);
    }

    @SubscribeEvent
    public static void onRenderPlayerPostEvent(RenderPlayerEvent.Post event) {
        if (!PlayerAnimator.areAnimationsEnabled()) {
            return;
        }
        List<ModelBiped> models = playerLayerModels.get(event.getRenderer());
        if (models != null) {
            for (ModelBiped model : models) {
                for (ModelRenderer box : model.field_78092_r) {
                    if (!(box instanceof ModelRendererExtended)) continue;
                    ((ModelRendererExtended)box).resetRotation();
                }
            }
        }
    }
}

