/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.model;

import com.google.common.collect.ImmutableMap;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.model.ItemOverrideListMapped;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class BakedModelGenerateOverrides
implements IBakedModel {
    private static final String OVERRIDE_GENERATORS = "override_generators";
    private final IBakedModel delegate;
    private final ItemOverrideList overrides;

    public BakedModelGenerateOverrides(IBakedModel delegate, ItemOverrideList overrides) {
        this.delegate = delegate;
        this.overrides = overrides;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.delegate.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.delegate.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.delegate.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.delegate.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.delegate.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.delegate.func_177552_f();
    }

    public boolean isAmbientOcclusion(IBlockState state) {
        return this.delegate.isAmbientOcclusion(state);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return this.delegate.handlePerspective(cameraTransformType);
    }

    @SubscribeEvent
    public static void bake(ModelBakeEvent event) {
        for (ModelResourceLocation location : event.getModelRegistry().func_148742_b()) {
            IBakedModel original = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
            try {
                if (original == null || original.func_188617_f() == null || original.func_188617_f().getOverrides() == null) continue;
                original.func_188617_f().getOverrides().stream().map(ItemOverride::func_188026_a).filter(l -> l.func_110623_a().contains(OVERRIDE_GENERATORS)).findFirst().ifPresent(l -> event.getModelRegistry().func_82595_a((Object)location, (Object)BakedModelGenerateOverrides.substituteWandModel(event.getModelManager(), location, original, l)));
            }
            catch (NullPointerException e) {
                Wizardry.logger.info("The model {} threw an error when trying to access item overrides, it will be ignored. If you're an addon dev and you made this model, something is wrong with it! Otherwise, please ignore this message.", (Object)location);
            }
        }
    }

    private static IBakedModel substituteWandModel(ModelManager modelManager, ModelResourceLocation location, IBakedModel original, ResourceLocation overrideLocation) {
        try {
            IModel unbakedOriginal = ModelLoaderRegistry.getModel((ResourceLocation)location);
            IModel referenceModel = ModelLoaderRegistry.getModel((ResourceLocation)overrideLocation);
            ModelBlock vanillaOriginal = unbakedOriginal.asVanillaModel().orElse(null);
            ModelBlock vanillaRefModel = referenceModel.asVanillaModel().orElse(null);
            if (vanillaOriginal != null && vanillaRefModel != null) {
                List overrides = vanillaRefModel.func_187966_f();
                HashMap<ResourceLocation, IBakedModel> replacementMap = new HashMap<ResourceLocation, IBakedModel>();
                for (ItemOverride override : overrides) {
                    IModel replacement = ModelLoaderRegistry.getModel((ResourceLocation)override.func_188026_a()).retexture(ImmutableMap.copyOf((Map)vanillaOriginal.field_178318_c));
                    replacementMap.put(override.func_188026_a(), replacement.bake(unbakedOriginal.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()));
                }
                ItemOverrideListMapped overrideList = new ItemOverrideListMapped(overrides, replacementMap);
                return new BakedModelGenerateOverrides(original, overrideList);
            }
        }
        catch (Exception exception) {
            Wizardry.logger.error("Error baking item display override models: ", (Throwable)exception);
        }
        return modelManager.func_174951_a();
    }
}

