/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.particle;

import electroblob.wizardry.client.ClientProxy;
import electroblob.wizardry.entity.ICustomHitbox;
import electroblob.wizardry.util.EntityUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ParticleWizardry
extends Particle {
    protected final TextureAtlasSprite[] sprites;
    protected long seed;
    protected Random random = new Random();
    protected boolean shaded = false;
    protected float initialRed;
    protected float initialGreen;
    protected float initialBlue;
    protected float fadeRed = 0.0f;
    protected float fadeGreen = 0.0f;
    protected float fadeBlue = 0.0f;
    protected float angle;
    protected double radius = 0.0;
    protected double speed = 0.0;
    @Nullable
    protected Entity entity = null;
    protected double relativeX;
    protected double relativeY;
    protected double relativeZ;
    protected double relativeMotionX;
    protected double relativeMotionY;
    protected double relativeMotionZ;
    protected float yaw = Float.NaN;
    protected float pitch = Float.NaN;
    private static final double SPREAD_FACTOR = 0.2;
    private static final double IMPACT_FRICTION = 0.2;
    private double prevVelX;
    private double prevVelY;
    private double prevVelZ;

    public ParticleWizardry(World world, double x, double y, double z, ResourceLocation ... textures) {
        super(world, x, y, z);
        this.relativeX = x;
        this.relativeY = y;
        this.relativeZ = z;
        if (textures.length > 0) {
            this.sprites = Arrays.stream(textures).map(t -> Minecraft.func_71410_x().func_147117_R().func_110572_b(t.toString())).collect(Collectors.toList()).toArray(new TextureAtlasSprite[0]);
            this.func_187117_a(this.sprites[0]);
        } else {
            this.sprites = new TextureAtlasSprite[0];
        }
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.random = new Random(seed);
    }

    public void setShaded(boolean shaded) {
        this.shaded = shaded;
    }

    public void setGravity(boolean gravity) {
        this.field_70545_g = gravity ? 1.0f : 0.0f;
    }

    public void setCollisions(boolean canCollide) {
        this.field_190017_n = canCollide;
    }

    public void setVelocity(double vx, double vy, double vz) {
        this.field_187129_i = vx;
        this.field_187130_j = vy;
        this.field_187131_k = vz;
    }

    public void setSpin(double radius, double speed) {
        this.radius = radius;
        this.speed = speed * 2.0 * Math.PI;
        this.angle = this.field_187136_p.nextFloat() * (float)Math.PI * 2.0f;
        this.field_187126_f = this.relativeX - radius * (double)MathHelper.func_76134_b((float)this.angle);
        this.field_187128_h = this.relativeZ + radius * (double)MathHelper.func_76126_a((float)this.angle);
        this.relativeMotionX = this.field_187129_i;
        this.relativeMotionY = this.field_187130_j;
        this.relativeMotionZ = this.field_187131_k;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
        if (entity != null) {
            this.func_187109_b(this.entity.field_70165_t + this.relativeX, this.entity.field_70163_u + this.relativeY, this.entity.field_70161_v + this.relativeZ);
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            this.relativeMotionX = this.field_187129_i;
            this.relativeMotionY = this.field_187130_j;
            this.relativeMotionZ = this.field_187131_k;
        }
    }

    public void func_70538_b(float r, float g, float b) {
        super.func_70538_b(r, g, b);
        this.initialRed = r;
        this.initialGreen = g;
        this.initialBlue = b;
        this.setFadeColour(r, g, b);
    }

    public void setFadeColour(float r, float g, float b) {
        this.fadeRed = r;
        this.fadeGreen = g;
        this.fadeBlue = b;
    }

    public void setFacing(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void setTargetPosition(double x, double y, double z) {
    }

    public void setTargetVelocity(double vx, double vy, double vz) {
    }

    public void setTargetEntity(Entity target) {
    }

    public void setLength(double length) {
    }

    public int func_70537_b() {
        return this.sprites.length == 0 ? super.func_70537_b() : 1;
    }

    public int func_189214_a(float partialTick) {
        return this.shaded ? super.func_189214_a(partialTick) : 0xF000F0;
    }

    public void func_180434_a(BufferBuilder buffer, Entity viewer, float partialTicks, float lookZ, float lookY, float lookX, float lookXY, float lookYZ) {
        this.updateEntityLinking(viewer, partialTicks);
        if (Float.isNaN(this.yaw) || Float.isNaN(this.pitch)) {
            this.drawParticle(buffer, viewer, partialTicks, lookZ, lookY, lookX, lookXY, lookYZ);
        } else {
            float degToRadFactor = (float)Math.PI / 180;
            float rotationX = MathHelper.func_76134_b((float)(this.yaw * degToRadFactor));
            float rotationZ = MathHelper.func_76126_a((float)(this.yaw * degToRadFactor));
            float rotationY = MathHelper.func_76134_b((float)(this.pitch * degToRadFactor));
            float rotationYZ = -rotationZ * MathHelper.func_76126_a((float)(this.pitch * degToRadFactor));
            float rotationXY = rotationX * MathHelper.func_76126_a((float)(this.pitch * degToRadFactor));
            this.drawParticle(buffer, viewer, partialTicks, rotationX, rotationY, rotationZ, rotationYZ, rotationXY);
        }
    }

    protected void drawParticle(BufferBuilder buffer, Entity viewer, float partialTicks, float rotationX, float rotationY, float rotationZ, float rotationYZ, float rotationXY) {
        super.func_180434_a(buffer, viewer, partialTicks, rotationX, rotationY, rotationZ, rotationYZ, rotationXY);
    }

    protected void updateEntityLinking(Entity viewer, float partialTicks) {
        if (this.entity != null) {
            this.field_187123_c = this.field_187126_f + this.entity.field_70169_q - this.entity.field_70165_t - this.relativeMotionX * (double)(1.0f - partialTicks);
            this.field_187124_d = this.field_187127_g + this.entity.field_70167_r - this.entity.field_70163_u - this.relativeMotionY * (double)(1.0f - partialTicks);
            this.field_187125_e = this.field_187128_h + this.entity.field_70166_s - this.entity.field_70161_v - this.relativeMotionZ * (double)(1.0f - partialTicks);
        } else if (this.func_70537_b() == 3) {
            field_70556_an = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
            field_70554_ao = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
            field_70555_ap = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
        }
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.field_190017_n && this.field_187132_l) {
            this.field_187129_i /= (double)0.7f;
            this.field_187131_k /= (double)0.7f;
        }
        if (this.entity != null || this.radius > 0.0) {
            double x = this.relativeX;
            double y = this.relativeY;
            double z = this.relativeZ;
            if (this.entity != null) {
                if (this.entity.field_70128_L) {
                    this.func_187112_i();
                } else {
                    x += this.entity.field_70165_t;
                    y += this.entity.field_70163_u;
                    z += this.entity.field_70161_v;
                }
            }
            if (this.radius > 0.0) {
                this.angle = (float)((double)this.angle + this.speed);
                x += this.radius * (double)(-MathHelper.func_76134_b((float)this.angle));
                z += this.radius * (double)MathHelper.func_76126_a((float)this.angle);
            }
            this.func_187109_b(x, y, z);
            this.relativeX += this.relativeMotionX;
            this.relativeY += this.relativeMotionY;
            this.relativeZ += this.relativeMotionZ;
        }
        float ageFraction = (float)this.field_70546_d / (float)this.field_70547_e;
        this.field_70552_h = this.initialRed + (this.fadeRed - this.initialRed) * ageFraction;
        this.field_70553_i = this.initialGreen + (this.fadeGreen - this.initialGreen) * ageFraction;
        this.field_70551_j = this.initialBlue + (this.fadeBlue - this.initialBlue) * ageFraction;
        if (this.sprites.length > 1) {
            this.func_187117_a(this.sprites[Math.min((int)(ageFraction * (float)this.sprites.length), this.sprites.length - 1)]);
        }
        if (this.field_190017_n) {
            double searchRadius;
            List<Entity> nearbyEntities;
            if (this.field_187129_i == 0.0 && this.prevVelX != 0.0) {
                this.field_187130_j *= 0.2;
                this.field_187131_k *= 0.2;
                this.field_187130_j += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelX * 0.2;
                this.field_187131_k += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelX * 0.2;
            }
            if (this.field_187130_j == 0.0 && this.prevVelY != 0.0) {
                this.field_187129_i *= 0.2;
                this.field_187131_k *= 0.2;
                this.field_187129_i += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelY * 0.2;
                this.field_187131_k += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelY * 0.2;
            }
            if (this.field_187131_k == 0.0 && this.prevVelZ != 0.0) {
                this.field_187129_i *= 0.2;
                this.field_187130_j *= 0.2;
                this.field_187129_i += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelZ * 0.2;
                this.field_187130_j += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelZ * 0.2;
            }
            if ((nearbyEntities = EntityUtils.getEntitiesWithinRadius(searchRadius = 20.0, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187122_b, Entity.class)).stream().anyMatch(e -> e instanceof ICustomHitbox && ((ICustomHitbox)e).calculateIntercept(new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h), new Vec3d(this.field_187123_c, this.field_187124_d, this.field_187125_e), 0.0f) != null)) {
                this.func_187112_i();
            }
        }
        this.prevVelX = this.field_187129_i;
        this.prevVelY = this.field_187130_j;
        this.prevVelZ = this.field_187131_k;
    }

    public void func_187110_a(double x, double y, double z) {
        double origY = y;
        double origX = x;
        double origZ = z;
        if (this.field_190017_n) {
            List list = this.field_187122_b.func_184144_a(null, this.func_187116_l().func_72321_a(x, y, z));
            for (AxisAlignedBB axisalignedbb : list) {
                y = axisalignedbb.func_72323_b(this.func_187116_l(), y);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(0.0, y, 0.0));
            for (AxisAlignedBB axisalignedbb1 : list) {
                x = axisalignedbb1.func_72316_a(this.func_187116_l(), x);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(x, 0.0, 0.0));
            for (AxisAlignedBB axisalignedbb2 : list) {
                z = axisalignedbb2.func_72322_c(this.func_187116_l(), z);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(0.0, 0.0, z));
        } else {
            this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        }
        this.func_187118_j();
        boolean bl = this.field_187132_l = origY != y && origY < 0.0;
        if (origX != x) {
            this.field_187129_i = 0.0;
        }
        if (origY != y) {
            this.field_187130_j = 0.0;
        }
        if (origZ != z) {
            this.field_187131_k = 0.0;
        }
    }

    public static ResourceLocation[] generateTextures(String stem, int n) {
        return ParticleWizardry.generateTextures("ebwizardry", stem, n);
    }

    public static ResourceLocation[] generateTextures(String modID, String stem, int n) {
        ResourceLocation[] textures = new ResourceLocation[n];
        for (int i = 0; i < n; ++i) {
            textures[i] = new ResourceLocation(modID, "particle/" + stem + "_" + i);
        }
        return textures;
    }

    static ResourceLocation[][] generateTextures(String stem, int m, int n) {
        return ParticleWizardry.generateTextures("ebwizardry", stem, m, n);
    }

    public static ResourceLocation[][] generateTextures(String modID, String stem, int m, int n) {
        ResourceLocation[][] textures = new ResourceLocation[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                textures[i][j] = new ResourceLocation(modID, "particle/" + stem + "_" + i + "_" + j);
            }
        }
        return textures;
    }

    public static void registerParticle(ResourceLocation name, IWizardryParticleFactory factory) {
        ClientProxy.addParticleFactory(name, factory);
    }

    @SideOnly(value=Side.CLIENT)
    @FunctionalInterface
    public static interface IWizardryParticleFactory {
        public ParticleWizardry createParticle(World var1, double var2, double var4, double var6);
    }
}

