/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.renderer.entity;

import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.entity.construct.EntityRadiantTotem;
import electroblob.wizardry.util.GeometryUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class RenderRadiantTotem
extends Render<EntityRadiantTotem> {
    private static final ResourceLocation FLARE_TEXTURE = new ResourceLocation("ebwizardry", "textures/entity/totem/flare.png");
    private static final ResourceLocation[] CUBE_TEXTURES = new ResourceLocation[14];

    public RenderRadiantTotem(RenderManager manager) {
        super(manager);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityRadiantTotem entity) {
        return CUBE_TEXTURES[entity.field_70173_aa % CUBE_TEXTURES.length];
    }

    public void doRender(EntityRadiantTotem entity, double x, double y, double z, float entityYaw, float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179129_p();
        GlStateManager.func_179137_b((double)x, (double)(y + (double)(entity.field_70131_O / 2.0f)), (double)z);
        float s = DrawingUtils.smoothScaleFactor(entity.lifetime, entity.field_70173_aa, partialTicks, 10, 10);
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        this.drawFlare(tessellator);
        this.drawCube(entity, tessellator, partialTicks);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private void drawFlare(Tessellator tessellator) {
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)260);
        GlStateManager.func_179124_c((float)1.0f, (float)0.957f, (float)0.608f);
        GlStateManager.func_179112_b((int)770, (int)771);
        this.func_110776_a(FLARE_TEXTURE);
        float yaw = Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 ? Minecraft.func_71410_x().func_175598_ae().field_78732_j : -Minecraft.func_71410_x().func_175598_ae().field_78732_j;
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)yaw, (float)1.0f, (float)0.0f, (float)0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float r = 0.5f;
        buffer.func_181662_b((double)(-r), (double)r, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)r, (double)r, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)r, (double)(-r), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-r), (double)(-r), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void drawCube(EntityRadiantTotem entity, Tessellator tessellator, float partialTicks) {
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        float age = (float)entity.field_70173_aa + partialTicks;
        float rotationSpeed = 2.0f;
        GlStateManager.func_179114_b((float)(age * rotationSpeed / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)60.0f, (float)0.7071f, (float)0.0f, (float)0.7071f);
        GlStateManager.func_179114_b((float)(age * rotationSpeed), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179112_b((int)770, (int)1);
        this.func_180548_c(entity);
        Vec3d[] vertices = GeometryUtils.getVertices(entity.func_174813_aQ().func_191194_a(entity.func_174791_d().func_72441_c(0.0, (double)(entity.field_70131_O / 2.0f), 0.0).func_186678_a(-1.0)));
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderRadiantTotem.drawFace(buffer, vertices[0], vertices[1], vertices[3], vertices[2], 0.5f, 0.0f, 0.75f, 0.5f);
        RenderRadiantTotem.drawFace(buffer, vertices[6], vertices[7], vertices[2], vertices[3], 0.75f, 0.5f, 1.0f, 1.0f);
        RenderRadiantTotem.drawFace(buffer, vertices[5], vertices[6], vertices[1], vertices[2], 0.0f, 0.5f, 0.25f, 1.0f);
        RenderRadiantTotem.drawFace(buffer, vertices[4], vertices[5], vertices[0], vertices[1], 0.25f, 0.5f, 0.5f, 1.0f);
        RenderRadiantTotem.drawFace(buffer, vertices[7], vertices[4], vertices[3], vertices[0], 0.5f, 0.5f, 0.75f, 1.0f);
        RenderRadiantTotem.drawFace(buffer, vertices[5], vertices[4], vertices[6], vertices[7], 0.25f, 0.0f, 0.5f, 0.5f);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private static void drawFace(BufferBuilder buffer, Vec3d topLeft, Vec3d topRight, Vec3d bottomLeft, Vec3d bottomRight, float u1, float v1, float u2, float v2) {
        buffer.func_181662_b(topLeft.field_72450_a, topLeft.field_72448_b, topLeft.field_72449_c).func_187315_a((double)u1, (double)v1).func_181675_d();
        buffer.func_181662_b(topRight.field_72450_a, topRight.field_72448_b, topRight.field_72449_c).func_187315_a((double)u2, (double)v1).func_181675_d();
        buffer.func_181662_b(bottomRight.field_72450_a, bottomRight.field_72448_b, bottomRight.field_72449_c).func_187315_a((double)u2, (double)v2).func_181675_d();
        buffer.func_181662_b(bottomLeft.field_72450_a, bottomLeft.field_72448_b, bottomLeft.field_72449_c).func_187315_a((double)u1, (double)v2).func_181675_d();
    }

    static {
        for (int i = 0; i < CUBE_TEXTURES.length; ++i) {
            RenderRadiantTotem.CUBE_TEXTURES[i] = new ResourceLocation("ebwizardry", "textures/entity/totem/cube_" + i + ".png");
        }
    }
}

