/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.renderer.entity.layers;

import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public abstract class LayerTiledOverlay<T extends EntityLivingBase>
implements LayerRenderer<T> {
    private final RenderLivingBase<?> renderer;
    private final int textureWidth;
    private final int textureHeight;

    public LayerTiledOverlay(RenderLivingBase<?> renderer, int textureWidth, int textureHeight) {
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.renderer = renderer;
    }

    public LayerTiledOverlay(RenderLivingBase<?> renderer) {
        this(renderer, 16, 16);
    }

    public abstract boolean shouldRender(T var1, float var2);

    public abstract ResourceLocation getTexture(T var1, float var2);

    public ModelBase getModel(T entity, float partialTicks) {
        return this.renderer.func_177087_b();
    }

    public boolean renderSecondLayer(T entity, float partialTicks) {
        return false;
    }

    protected void applyTextureSpaceTransformations(T entity, float partialTicks) {
    }

    public void func_177141_a(T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (this.shouldRender(entity, partialTicks)) {
            this.renderer.func_110776_a(this.getTexture(entity, partialTicks));
            this.renderEntityModel(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public boolean func_177142_b() {
        return false;
    }

    protected static int getBlockBrightnessForEntity(Entity entity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), 0, MathHelper.func_76128_c((double)entity.field_70161_v));
        if (entity.field_70170_p.func_175667_e((BlockPos)pos)) {
            pos.func_185336_p(MathHelper.func_76128_c((double)(entity.field_70163_u + (double)entity.func_70047_e())));
            return entity.field_70170_p.func_175626_b((BlockPos)pos, 0);
        }
        return 0;
    }

    private void renderEntityModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        ModelBase model = this.getModel(entity, partialTicks);
        double scaleX = 1.0;
        double scaleY = 1.0;
        if (model.field_78092_r != null && model.field_78092_r.size() >= 1 && model.field_78092_r.get(0) != null) {
            scaleX = (double)((ModelRenderer)model.field_78092_r.get((int)0)).field_78801_a / (double)this.textureWidth;
            scaleY = (double)((ModelRenderer)model.field_78092_r.get((int)0)).field_78799_b / (double)this.textureHeight;
        } else {
            scaleX = (double)model.field_78090_t / (double)this.textureWidth;
            scaleY = (double)model.field_78089_u / (double)this.textureHeight;
        }
        GlStateManager.func_179139_a((double)scaleX, (double)scaleY, (double)1.0);
        this.applyTextureSpaceTransformations(entity, partialTicks);
        GlStateManager.func_179128_n((int)5888);
        boolean headWearHidden = false;
        boolean bodyWearHidden = false;
        boolean leftArmWearHidden = false;
        boolean rightArmWearHidden = false;
        boolean leftLegWearHidden = false;
        boolean rightLegWearHidden = false;
        if (!this.renderSecondLayer(entity, partialTicks)) {
            if (model instanceof ModelBiped) {
                headWearHidden = ((ModelBiped)model).field_178720_f.field_78807_k;
                ((ModelBiped)model).field_178720_f.field_78807_k = true;
            }
            if (model instanceof ModelPlayer) {
                bodyWearHidden = ((ModelPlayer)model).field_178730_v.field_78807_k;
                leftArmWearHidden = ((ModelPlayer)model).field_178734_a.field_78807_k;
                rightArmWearHidden = ((ModelPlayer)model).field_178732_b.field_78807_k;
                leftLegWearHidden = ((ModelPlayer)model).field_178733_c.field_78807_k;
                rightLegWearHidden = ((ModelPlayer)model).field_178731_d.field_78807_k;
                ((ModelPlayer)model).field_178730_v.field_78807_k = true;
                ((ModelPlayer)model).field_178734_a.field_78807_k = true;
                ((ModelPlayer)model).field_178732_b.field_78807_k = true;
                ((ModelPlayer)model).field_178733_c.field_78807_k = true;
                ((ModelPlayer)model).field_178731_d.field_78807_k = true;
            }
        }
        model.func_78086_a(entity, limbSwing, limbSwingAmount, partialTicks);
        model.func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (!this.renderSecondLayer(entity, partialTicks)) {
            if (model instanceof ModelBiped) {
                ((ModelBiped)model).field_178720_f.field_78807_k = headWearHidden;
            }
            if (model instanceof ModelPlayer) {
                ((ModelPlayer)model).field_178730_v.field_78807_k = bodyWearHidden;
                ((ModelPlayer)model).field_178734_a.field_78807_k = leftArmWearHidden;
                ((ModelPlayer)model).field_178732_b.field_78807_k = rightArmWearHidden;
                ((ModelPlayer)model).field_178733_c.field_78807_k = leftLegWearHidden;
                ((ModelPlayer)model).field_178731_d.field_78807_k = rightLegWearHidden;
            }
        }
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
    }

    public static <T extends EntityLivingBase> void initialiseLayers(Class<T> entityType, Function<RenderLivingBase<T>, LayerRenderer<? extends T>> layerFactory) {
        for (Class c : Minecraft.func_71410_x().func_175598_ae().field_78729_o.keySet()) {
            Render renderer;
            if (!entityType.isAssignableFrom(c) || !((renderer = Minecraft.func_71410_x().func_175598_ae().func_78715_a(c)) instanceof RenderLivingBase)) continue;
            ((RenderLivingBase)renderer).func_177094_a(layerFactory.apply((RenderLivingBase)renderer));
        }
        if (entityType.isAssignableFrom(EntityPlayer.class)) {
            for (RenderPlayer renderer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
                renderer.func_177094_a(layerFactory.apply((RenderLivingBase<RenderLivingBase>)renderer));
            }
        }
    }

    public static void initialiseLayers(Function<RenderLivingBase<EntityLivingBase>, LayerRenderer<? extends EntityLivingBase>> layerFactory) {
        LayerTiledOverlay.initialiseLayers(EntityLivingBase.class, layerFactory);
    }
}

