/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.renderer.overlay;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.WizardryClientEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class RenderBlinkEffect {
    private static int blinkEffectTimer;
    private static final int BLINK_EFFECT_DURATION = 8;
    private static final ResourceLocation SCREEN_OVERLAY_TEXTURE;

    public static void playBlinkEffect() {
        if (Wizardry.settings.blinkEffect) {
            blinkEffectTimer = 8;
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.player == Minecraft.func_71410_x().field_71439_g && event.phase == TickEvent.Phase.END) {
            if (Wizardry.settings.blinkEffect) {
                if (blinkEffectTimer > 0) {
                    --blinkEffectTimer;
                }
            } else {
                blinkEffectTimer = 0;
            }
        }
    }

    @SubscribeEvent
    public static void onFOVUpdateEvent(FOVUpdateEvent event) {
        if (blinkEffectTimer > 0) {
            float f = (float)Math.max(blinkEffectTimer - 2, 0) / 8.0f;
            event.setNewfov(event.getFov() + f * f * 0.7f);
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HELMET && blinkEffectTimer > 0) {
            float alpha = (float)blinkEffectTimer / 8.0f;
            OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GlStateManager.func_179118_c();
            WizardryClientEventHandler.renderScreenOverlay(event.getResolution(), SCREEN_OVERLAY_TEXTURE);
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    static {
        SCREEN_OVERLAY_TEXTURE = new ResourceLocation("ebwizardry", "textures/gui/blink_overlay.png");
    }
}

