/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.data;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketDispenserCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class BlockCastingData<T extends TileEntity>
implements INBTSerializable<NBTTagCompound> {
    protected final T tileEntity;
    protected Spell spell;
    protected double x;
    protected double y;
    protected double z;
    protected int castingTick;
    protected SpellModifiers modifiers;

    public BlockCastingData(T tileEntity) {
        this.tileEntity = tileEntity;
        this.spell = Spells.none;
        this.modifiers = new SpellModifiers();
        this.castingTick = 0;
    }

    public boolean isCasting() {
        return this.spell != null && this.spell != Spells.none;
    }

    public Spell currentlyCasting() {
        return this.spell;
    }

    protected void startCasting(Spell spell, double x, double y, double z, SpellModifiers modifiers) {
        if (!spell.isContinuous) {
            Wizardry.logger.warn("Tried to start casting a continuous spell from a tile entity, but the given spell was not continuous!");
            return;
        }
        this.spell = spell;
        this.x = x;
        this.y = y;
        this.z = z;
        this.castingTick = 0;
        this.modifiers = modifiers;
    }

    protected void stopCasting() {
        this.spell = Spells.none;
        this.castingTick = 0;
        this.modifiers.reset();
    }

    protected void stopCastingAndNotify() {
        this.stopCasting();
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            PacketDispenserCastSpell.Message msg = new PacketDispenserCastSpell.Message(this.x, this.y, this.z, this.getDirection(), this.tileEntity.func_174877_v(), this.spell, 0, this.modifiers);
            WizardryPacketHandler.net.sendToDimension((IMessage)msg, this.tileEntity.func_145831_w().field_73011_w.getDimension());
        }
    }

    protected void update() {
        if (this.tileEntity.func_145837_r()) {
            return;
        }
        if (this.isCasting() && this.spell.isContinuous) {
            if (!this.shouldContinueCasting()) {
                this.stopCasting();
                return;
            }
            EnumFacing direction = this.getDirection();
            if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(this.getSource(), this.spell, this.tileEntity.func_145831_w(), this.x, this.y, this.z, direction, this.modifiers, this.castingTick))) {
                this.stopCastingAndNotify();
                return;
            }
            this.spell.cast(this.tileEntity.func_145831_w(), this.x, this.y, this.z, direction, this.castingTick, -1, this.modifiers);
            ++this.castingTick;
        } else {
            this.castingTick = 0;
        }
    }

    protected abstract EnumFacing getDirection();

    protected abstract SpellCastEvent.Source getSource();

    protected abstract boolean shouldContinueCasting();

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("spell", this.spell.metadata());
        nbt.func_74768_a("castingTick", this.castingTick);
        NBTExtras.storeTagSafely(nbt, "modifiers", (NBTBase)this.modifiers.toNBT());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.spell = Spell.byMetadata(nbt.func_74762_e("spell"));
            this.castingTick = nbt.func_74762_e("castingTick");
            this.modifiers = SpellModifiers.fromNBT(nbt.func_74775_l("modifiers"));
        }
    }
}

